/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.InitializationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.graalvm.collections.Pair;

public class ClassInitializationConfiguration {
    private static final String ROOT_QUALIFIER = "";
    private static final int MAX_NUMBER_OF_REASONS = 10;
    private InitializationNode root = new InitializationNode("", null, null, false, new String[0]);

    public synchronized void insert(String classOrPackage, InitKind kind, String reason, boolean strict) {
        assert (kind != null);
        this.insertRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), kind, reason, strict);
    }

    synchronized Pair<InitKind, Boolean> lookupKind(String classOrPackage) {
        Pair<InitializationNode, Boolean> kindPair = this.lookupRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), null);
        return Pair.create((Object)((Object)(kindPair.getLeft() == null ? null : ((InitializationNode)kindPair.getLeft()).kind)), (Object)kindPair.getRight());
    }

    synchronized String lookupReason(String classOrPackage) {
        InitializationNode initializationNode = (InitializationNode)this.lookupRec(this.root, ClassInitializationConfiguration.qualifierList(classOrPackage), null).getLeft();
        if (initializationNode == null) {
            return null;
        }
        return String.join((CharSequence)" and ", initializationNode.reasons);
    }

    private static List<String> qualifierList(String classOrPackage) {
        List qualifiers = classOrPackage.isEmpty() ? Collections.emptyList() : Arrays.asList(classOrPackage.split("\\."));
        ArrayList<String> prefixed = new ArrayList<String>(Collections.singletonList(ROOT_QUALIFIER));
        prefixed.addAll(qualifiers);
        return prefixed;
    }

    private void insertRec(InitializationNode node, List<String> classOrPackage, InitKind kind, String reason, boolean strict) {
        assert (!classOrPackage.isEmpty());
        assert (node.qualifier.equals(classOrPackage.get(0)));
        if (classOrPackage.size() == 1) {
            if (node.kind == null) {
                node.kind = kind;
                node.strict = strict;
            } else if (node.kind == kind) {
                if (node.reasons.size() < 10) {
                    node.reasons.add((Object)reason);
                } else if (node.reasons.size() == 10) {
                    node.reasons.add((Object)"others");
                }
            } else {
                if (node.strict) {
                    throw UserError.abort("Incompatible change of initialization policy for %s: trying to change %s %s to %s %s", new Object[]{ClassInitializationConfiguration.qualifiedName(node), node.kind, String.join((CharSequence)" and ", node.reasons), kind, reason});
                }
                node.kind = node.kind.max(kind);
            }
        } else {
            ArrayList<String> tail = new ArrayList<String>(classOrPackage);
            tail.remove(0);
            String nextQualifier = (String)tail.get(0);
            if (!node.children.containsKey((Object)nextQualifier)) {
                node.children.put((Object)nextQualifier, (Object)new InitializationNode(nextQualifier, node, null, false, reason));
                assert (node.children.containsKey((Object)nextQualifier));
            }
            this.insertRec((InitializationNode)node.children.get((Object)nextQualifier), tail, kind, reason, strict);
        }
    }

    private Pair<InitializationNode, Boolean> lookupRec(InitializationNode node, List<String> classOrPackage, InitializationNode lastNonNullKind) {
        ArrayList<String> tail = new ArrayList<String>(classOrPackage);
        tail.remove(0);
        boolean reachedBottom = tail.isEmpty();
        if (!reachedBottom && node.children.containsKey(tail.get(0))) {
            return this.lookupRec((InitializationNode)node.children.get(tail.get(0)), tail, node.kind != null ? node : lastNonNullKind);
        }
        if (node.kind == null) {
            return Pair.create((Object)lastNonNullKind, (Object)reachedBottom);
        }
        return Pair.create((Object)node, (Object)reachedBottom);
    }

    private static String qualifiedName(InitializationNode node) {
        InitializationNode currentNode = node;
        ArrayList<String> name = new ArrayList<String>();
        while (currentNode != null) {
            name.add(currentNode.qualifier);
            currentNode = currentNode.parent;
        }
        Collections.reverse(name);
        name.remove(0);
        return String.join((CharSequence)".", name);
    }

    synchronized List<ClassOrPackageConfig> allConfigs() {
        LinkedList<InitializationNode> printingQueue = new LinkedList<InitializationNode>();
        printingQueue.add(this.root);
        ArrayList<ClassOrPackageConfig> allClasses = new ArrayList<ClassOrPackageConfig>();
        while (!printingQueue.isEmpty()) {
            InitializationNode node = (InitializationNode)printingQueue.remove();
            if (node.kind != null) {
                String name = node.qualifier.isEmpty() ? "whole type hierarchy" : ClassInitializationConfiguration.qualifiedName(node);
                allClasses.add(new ClassOrPackageConfig(name, node.reasons, node.kind));
            }
            node.children.getValues().forEach(printingQueue::push);
        }
        return allClasses;
    }
}

