/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.classinitialization.ClassInitializationInfo;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedSnippets;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ExceptionSynthesizer;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ConfigurableClassInitialization;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.classinitialization.TypeInitializerGraph;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class ClassInitializationFeature
implements GraalFeature {
    public static final String REPORTS_PATH = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "reports").toAbsolutePath().toString();
    private ClassInitializationSupport classInitializationSupport;
    private AnalysisUniverse universe;
    private AnalysisMetaAccess metaAccess;

    public static void processClassInitializationOptions(ClassInitializationSupport initializationSupport) {
        ClassInitializationFeature.initializeNativeImagePackagesAtBuildTime(initializationSupport);
        ClassInitializationOptions.ClassInitialization.getValue().getValuesWithOrigins().forEach(entry -> {
            for (String info : ((String)entry.getLeft()).split(",")) {
                boolean noMatches = Arrays.stream(InitKind.values()).noneMatch(v -> info.endsWith(v.suffix()));
                String origin = (String)entry.getRight();
                if (noMatches) {
                    throw UserError.abort("Element in class initialization configuration must end in %s, %s, or %s. Found: %s (from %s)", InitKind.RUN_TIME.suffix(), InitKind.RERUN.suffix(), InitKind.BUILD_TIME.suffix(), info, origin);
                }
                Pair<String, InitKind> elementType = InitKind.strip(info);
                ((InitKind)((Object)((Object)elementType.getRight()))).stringConsumer(initializationSupport, origin).accept((String)elementType.getLeft());
            }
        });
    }

    private static void initializeNativeImagePackagesAtBuildTime(ClassInitializationSupport initializationSupport) {
        initializationSupport.initializeAtBuildTime("com.oracle.svm", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("com.oracle.graal", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.collections", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.compiler", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.word", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.nativeimage", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.util", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.home", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.polyglot", "Native Image classes are always initialized at build time");
        initializationSupport.initializeAtBuildTime("org.graalvm.options", "Native Image classes are always initialized at build time");
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitializationSupport = access.getHostVM().getClassInitializationSupport();
        this.classInitializationSupport.setUnsupportedFeatures(access.getBigBang().getUnsupportedFeatures());
        access.registerObjectReplacer(this::checkImageHeapInstance);
        this.universe = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getUniverse();
        this.metaAccess = ((FeatureImpl.DuringSetupAccessImpl)a).getBigBang().getMetaAccess();
    }

    private Object checkImageHeapInstance(Object obj) {
        if (obj != null && this.classInitializationSupport.shouldInitializeAtRuntime(obj.getClass())) {
            String msg = "No instances of " + obj.getClass().getTypeName() + " are allowed in the image heap as this class should be initialized at image runtime.";
            msg = msg + this.classInitializationSupport.objectInstantiationTraceMessage(obj, " To fix the issue mark " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + " or use the the information from the trace to find the culprit and " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, "<culprit>", "initialize-at-run-time") + " to prevent its instantiation.\n");
            throw new UnsupportedFeatureException(msg);
        }
        return obj;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : EnsureClassInitializedSnippets.FOREIGN_CALLS) {
            access.getBigBang().addRootMethod((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()));
        }
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, SubstrateForeignCallsProvider foreignCalls, boolean hosted) {
        foreignCalls.register(providers, EnsureClassInitializedSnippets.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        EnsureClassInitializedSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.classInitializationSupport.checkDelayedInitialization();
        for (AnalysisType type : access.getUniverse().getTypes()) {
            DynamicHub hub;
            if (!type.isReachable() || (hub = access.getHostVM().dynamicHub((ResolvedJavaType)type)).getClassInitializationInfo() != null) continue;
            this.buildClassInitializationInfo(access, type, hub);
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        String imageName = ((FeatureImpl.AfterAnalysisAccessImpl)access).getBigBang().getHostVM().getImageName();
        try (Timer.StopTimer ignored = new Timer(imageName, "(clinit)").start();){
            this.classInitializationSupport.setUnsupportedFeatures(null);
            String path = REPORTS_PATH;
            assert (this.classInitializationSupport.checkDelayedInitialization());
            TypeInitializerGraph initGraph = new TypeInitializerGraph(this.universe);
            initGraph.computeInitializerSafety();
            this.classInitializationSupport.setProvenSafeLate(this.initializeSafeDelayedClasses(initGraph));
            if (ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
                ClassInitializationFeature.reportInitializerDependencies(this.universe, initGraph, path);
                this.reportClassInitializationInfo(path);
            }
            if (SubstrateOptions.TraceClassInitialization.hasBeenSet()) {
                ClassInitializationFeature.reportTrackedClassInitializationTraces(path);
            }
        }
    }

    private static void reportInitializerDependencies(AnalysisUniverse universe, TypeInitializerGraph initGraph, String path) {
        ReportUtils.report((String)"class initialization dependencies", (String)path, (String)"class_initialization_dependencies", (String)"dot", writer -> {
            writer.println("digraph class_initializer_dependencies {");
            universe.getTypes().stream().filter(ClassInitializationFeature::isRelevantForPrinting).forEach(t -> writer.println(ClassInitializationFeature.quote(t.toClassName()) + "[fillcolor=" + (initGraph.isUnsafe((AnalysisType)t) ? "red" : "green") + "]"));
            universe.getTypes().stream().filter(ClassInitializationFeature::isRelevantForPrinting).forEach(t -> initGraph.getDependencies((AnalysisType)t).forEach(t1 -> writer.println(ClassInitializationFeature.quote(t.toClassName()) + " -> " + ClassInitializationFeature.quote(t1.toClassName()))));
            writer.println("}");
        });
    }

    private void reportClassInitializationInfo(String path) {
        ReportUtils.report((String)"class initialization report", (String)path, (String)"class_initialization_report", (String)"csv", writer -> {
            writer.println("Class Name, Initialization Kind, Reason for Initialization");
            this.reportKind((PrintWriter)writer, InitKind.BUILD_TIME);
            this.reportKind((PrintWriter)writer, InitKind.RERUN);
            this.reportKind((PrintWriter)writer, InitKind.RUN_TIME);
        });
    }

    private void reportKind(PrintWriter writer, InitKind kind) {
        ArrayList allClasses = new ArrayList(this.classInitializationSupport.classesWithKind(kind));
        allClasses.sort(Comparator.comparing(Class::getTypeName));
        allClasses.forEach(clazz -> {
            writer.print(clazz.getTypeName() + ", ");
            writer.print((Object)((Object)kind) + ", ");
            writer.println(this.classInitializationSupport.reasonForClass((Class<?>)clazz));
        });
    }

    private static void reportTrackedClassInitializationTraces(String path) {
        Map<Class<?>, StackTraceElement[]> initializedClasses = ConfigurableClassInitialization.getInitializedClasses();
        int size = initializedClasses.size();
        if (size > 0) {
            ReportUtils.report((String)(size + " class initialization trace(s) of class(es) traced by " + SubstrateOptions.TraceClassInitialization.getName()), (String)path, (String)"traced_class_initialization", (String)"txt", writer -> initializedClasses.forEach((k, v) -> {
                writer.println(k.getName());
                writer.println("---------------------------------------------");
                writer.println(ConfigurableClassInitialization.getTraceString(v));
                writer.println();
            }));
        }
    }

    private static boolean isRelevantForPrinting(AnalysisType type) {
        return !type.isPrimitive() && !type.isArray() && type.isReachable();
    }

    private static String quote(String className) {
        return "\"" + className + "\"";
    }

    private Set<Class<?>> initializeSafeDelayedClasses(TypeInitializerGraph initGraph) {
        HashSet provenSafe = new HashSet();
        this.classInitializationSupport.setConfigurationSealed(false);
        this.classInitializationSupport.classesWithKind(InitKind.RUN_TIME).stream().filter(t -> this.metaAccess.optionalLookupJavaType(t).isPresent()).filter(t -> this.metaAccess.lookupJavaType(t).isReachable()).filter(t -> this.classInitializationSupport.canBeProvenSafe((Class<?>)t)).forEach(c -> {
            AnalysisType type = this.metaAccess.lookupJavaType(c);
            if (!initGraph.isUnsafe(type)) {
                this.classInitializationSupport.forceInitializeHosted((Class<?>)c, "proven safe to initialize", true);
                if (!this.classInitializationSupport.shouldInitializeAtRuntime((Class<?>)c)) {
                    provenSafe.add((Class<?>)c);
                    ClassInitializationInfo initializationInfo = type.getClassInitializer() == null ? ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON : ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
                    ((SVMHost)this.universe.hostVM()).dynamicHub((ResolvedJavaType)type).setClassInitializationInfo(initializationInfo);
                }
            }
        });
        return provenSafe;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        this.classInitializationSupport.checkDelayedInitialization();
    }

    private void buildClassInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type, DynamicHub hub) {
        ClassInitializationInfo info;
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type)) {
            info = ClassInitializationFeature.buildRuntimeInitializationInfo(access, type);
        } else {
            assert (type.isInitialized());
            info = type.getClassInitializer() == null ? ClassInitializationInfo.NO_INITIALIZER_INFO_SINGLETON : ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
        }
        hub.setClassInitializationInfo(info, type.hasDefaultMethods(), type.declaresDefaultMethods());
    }

    private static ClassInitializationInfo buildRuntimeInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type) {
        assert (!type.isInitialized());
        try {
            type.link();
        }
        catch (VerifyError e) {
            AnalysisMethod throwVerifyError = access.getMetaAccess().lookupJavaMethod((Executable)ExceptionSynthesizer.throwExceptionMethod(VerifyError.class));
            access.registerAsCompiled(throwVerifyError);
            return new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)throwVerifyError));
        }
        catch (Throwable t) {
            return ClassInitializationInfo.FAILED_INFO_SINGLETON;
        }
        assert (type.isLinked());
        AnalysisMethod classInitializer = type.getClassInitializer();
        if (classInitializer != null) {
            assert (classInitializer.getCode() != null);
            access.registerAsCompiled(classInitializer);
        }
        return new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)classInitializer));
    }
}

