/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.hosted.config.HybridLayoutSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;

public class HybridLayout<T> {
    private final ObjectLayout layout;
    private final HostedField arrayField;
    private final HostedField typeIDSlotsField;
    private final int arrayBaseOffset;

    public static boolean isHybrid(HostedType clazz) {
        return ((HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class)).isHybrid(clazz);
    }

    public static boolean isHybridField(HostedField field) {
        return ((HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class)).isHybridField(field);
    }

    public static boolean canHybridFieldsBeDuplicated(HostedType clazz) {
        return ((HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class)).canHybridFieldsBeDuplicated(clazz);
    }

    public HybridLayout(Class<T> hybridClass, ObjectLayout layout, HostedMetaAccess metaAccess) {
        this((HostedInstanceClass)metaAccess.lookupJavaType((Class)hybridClass), layout);
    }

    public HybridLayout(HostedInstanceClass hybridClass, ObjectLayout layout) {
        this.layout = layout;
        HybridLayoutSupport utils = (HybridLayoutSupport)ImageSingletons.lookup(HybridLayoutSupport.class);
        HybridLayoutSupport.HybridFields hybridFields = utils.findHybridFields(hybridClass);
        this.arrayField = hybridFields.arrayField;
        this.typeIDSlotsField = hybridFields.typeIDSlotsField;
        this.arrayBaseOffset = NumUtil.roundUp((int)hybridClass.getAfterFieldsOffset(), (int)layout.sizeInBytes(this.getArrayElementStorageKind()));
    }

    public JavaKind getArrayElementStorageKind() {
        return this.arrayField.getType().getComponentType().getStorageKind();
    }

    public int getArrayBaseOffset() {
        return this.arrayBaseOffset;
    }

    public long getArrayElementOffset(int index) {
        return this.getArrayBaseOffset() + index * this.layout.sizeInBytes(this.getArrayElementStorageKind());
    }

    public long getTotalSize(int length) {
        return this.layout.alignUp(this.getArrayElementOffset(length));
    }

    public HostedField getArrayField() {
        return this.arrayField;
    }

    public HostedField getTypeIDSlotsField() {
        return this.typeIDSlotsField;
    }

    public static int getTypeIDSlotsFieldOffset(ObjectLayout layout) {
        return layout.getArrayLengthOffset() + layout.sizeInBytes(JavaKind.Int);
    }
}

