/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.DeoptTest;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.NeverInlineTrivial;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.phases.ExperimentalNativeImageInlineDuringParsingSupport;
import com.oracle.svm.hosted.phases.IntrinsifyMethodHandlesInvocationPlugin;
import com.oracle.svm.hosted.phases.SharedGraphBuilderPhase;
import com.oracle.svm.hosted.phases.TrivialMethodDetector;
import com.oracle.svm.hosted.snippets.IntrinsificationPluginRegistry;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.util.GuardedAnnotationAccess;

public class ExperimentalNativeImageInlineDuringParsingPlugin
implements InlineInvokePlugin {
    private final ParsingReason reason;
    private final HostedProviders providers;

    public ExperimentalNativeImageInlineDuringParsingPlugin(ParsingReason reason, HostedProviders providers) {
        this.reason = reason;
        this.providers = providers;
    }

    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod callee, ValueNode[] args) {
        ResolvedJavaMethod caller = b.getMethod();
        if (ExperimentalNativeImageInlineDuringParsingPlugin.inliningBeforeAnalysisNotAllowed(b, callee, caller)) {
            return null;
        }
        InvocationResult inline = null;
        CallSite callSite = new CallSite(b.getCallingContext(), ExperimentalNativeImageInlineDuringParsingPlugin.toAnalysisMethod(callee));
        if (this.reason == ParsingReason.PointsToAnalysis) {
            DebugContext debug = b.getDebug();
            try (DebugContext.Scope ignored = debug.scope((Object)"TrivialMethodDetectorAnalysis", (Object)this);
                 AutoCloseable ignored1 = ReflectionPlugins.ReflectionPluginRegistry.startThreadLocalRegistry();
                 AutoCloseable ignored2 = IntrinsifyMethodHandlesInvocationPlugin.IntrinsificationRegistry.startThreadLocalnRegistry();){
                TrivialMethodDetector detector = new TrivialMethodDetector(this.providers, ((SharedGraphBuilderPhase.SharedBytecodeParser)b).getGraphBuilderConfig(), b.getOptions(), b.getDebug());
                InvocationResult newResult = detector.analyzeMethod(callSite, (AnalysisMethod)callee, args);
                ExperimentalNativeImageInlineDuringParsingPlugin.support().add(callSite, newResult);
                inline = newResult;
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        } else {
            inline = ExperimentalNativeImageInlineDuringParsingPlugin.support().inlineData.get(callSite);
        }
        if (inline instanceof InvocationResultInline) {
            InvocationResultInline inlineData = (InvocationResultInline)inline;
            VMError.guarantee(inlineData.callee.equals((Object)ExperimentalNativeImageInlineDuringParsingPlugin.toAnalysisMethod(callee)));
            if (this.reason == ParsingReason.PointsToAnalysis) {
                AnalysisType receiverType;
                AnalysisMethod aMethod = (AnalysisMethod)callee;
                if (!SubstrateOptions.parseOnce()) {
                    aMethod.registerAsImplementationInvoked(null);
                }
                if (!aMethod.isStatic() && args[0].isConstant() && (receiverType = (AnalysisType)StampTool.typeOrNull((ValueNode)args[0])) != null) {
                    receiverType.registerAsInHeap();
                }
            }
            return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)callee);
        }
        return null;
    }

    static boolean inliningBeforeAnalysisNotAllowed(GraphBuilderContext b, ResolvedJavaMethod callee, ResolvedJavaMethod caller) {
        return b.parsingIntrinsic() || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, NeverInline.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, NeverInlineTrivial.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, Uninterruptible.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)caller, Uninterruptible.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)callee, RestrictHeapAccess.class) || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)caller, RestrictHeapAccess.class) || caller.isClassInitializer() || GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)caller, DeoptTest.class) || b.getDepth() > (Integer)Options.InlineBeforeAnalysisMaxDepth.getValue(b.getOptions()) || ExperimentalNativeImageInlineDuringParsingPlugin.isRecursiveCall(b.getCallingContext(), callee) || b.bciCanBeDuplicated();
    }

    public static boolean isRecursiveCall(List<Pair<ResolvedJavaMethod, Integer>> callingContext, ResolvedJavaMethod callee) {
        return callingContext.stream().map(Pair::getLeft).anyMatch(caller -> caller.equals(callee));
    }

    public static ExperimentalNativeImageInlineDuringParsingSupport support() {
        return (ExperimentalNativeImageInlineDuringParsingSupport)ImageSingletons.lookup(ExperimentalNativeImageInlineDuringParsingSupport.class);
    }

    static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
        if (method instanceof AnalysisMethod) {
            return (AnalysisMethod)method;
        }
        return ((HostedMethod)method).getWrapped();
    }

    public static class InvocationResultInline
    extends InvocationResult {
        final CallSite callSite;
        final AnalysisMethod callee;

        InvocationResultInline(CallSite callSite, AnalysisMethod callee) {
            this.callSite = callSite;
            this.callee = callee;
        }

        public String toString() {
            return this.callSite + " -> " + this.callee.format("%h.%n(%p)");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvocationResultInline that = (InvocationResultInline)o;
            return this.callSite.equals(that.callSite) && Objects.equals(this.callee, that.callee);
        }

        public int hashCode() {
            return Objects.hash(this.callSite, this.callee);
        }
    }

    static class InvocationResult {
        static final InvocationResult ANALYSIS_TOO_COMPLICATED = new InvocationResult(){

            public String toString() {
                return "Analysis to complicated.";
            }
        };

        InvocationResult() {
        }
    }

    static final class CallSite
    extends IntrinsificationPluginRegistry.CallSiteDescriptor {
        final AnalysisMethod callee;

        CallSite(List<Pair<ResolvedJavaMethod, Integer>> callingContext, AnalysisMethod callee) {
            super(callingContext);
            this.callee = callee;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.callee.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.callee.equals((Object)((CallSite)obj).callee);
        }

        @Override
        public String toString() {
            return super.toString() + this.callee.format("%h.%n(%p)");
        }
    }

    public static class Options {
        @Option(help={"Experimental: Inline methods which folds to constant during parsing before the static analysis."})
        public static final HostedOptionKey<Boolean> OldInlineBeforeAnalysis = new HostedOptionKey<Boolean>(false);
        @Option(help={"Maximum depth when inlining."})
        public static final HostedOptionKey<Integer> InlineBeforeAnalysisMaxDepth = new HostedOptionKey<Integer>(9);
    }
}

