/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultData;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedCompilationResultInfo
implements TruffleCompilerListener.CompilationResultInfo {
    private CompilerHandle<TruffleCompilerListener.CompilationResultInfo> originalObjectHandle;
    private final int targetCodeSize;
    private final int totalFrameSize;
    private final int exceptionHandlersCount;
    private final int infopointsCount;
    private final int marksCount;
    private final int dataPatchesCount;

    IsolatedCompilationResultInfo(IsolatedCompilationResultData data) {
        this.originalObjectHandle = data.getOriginalObjectHandle();
        this.targetCodeSize = data.getTargetCodeSize();
        this.totalFrameSize = data.getTotalFrameSize();
        this.exceptionHandlersCount = data.getExceptionHandlersCount();
        this.infopointsCount = data.getInfopointsCount();
        this.marksCount = data.getMarksCount();
        this.dataPatchesCount = data.getDataPatchesCount();
    }

    public int getTargetCodeSize() {
        return this.targetCodeSize;
    }

    public int getTotalFrameSize() {
        return this.totalFrameSize;
    }

    public int getExceptionHandlersCount() {
        return this.exceptionHandlersCount;
    }

    public int getInfopointsCount() {
        return this.infopointsCount;
    }

    public String[] getInfopoints() {
        ClientHandle<String[]> handle = IsolatedCompilationResultInfo.getInfopoints0(IsolatedCompileClient.get().getCompiler(), this.originalObjectHandle);
        return IsolatedCompileClient.get().unhand(handle);
    }

    public int getMarksCount() {
        return this.marksCount;
    }

    public int getDataPatchesCount() {
        return this.dataPatchesCount;
    }

    @CEntryPoint
    @CEntryPointOptions(include=CEntryPointOptions.NotIncludedAutomatically.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<String[]> getInfopoints0(CompilerIsolateThread compiler, CompilerHandle<TruffleCompilerListener.CompilationResultInfo> infoHandle) {
        TruffleCompilerListener.CompilationResultInfo info = IsolatedCompileContext.get().unhand(infoHandle);
        return IsolatedCompileContext.get().createStringArrayInClient(info.getInfopoints());
    }
}

