/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.MappingsDatabaseCollector;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class JDBCBinder {
    private Settings settings;
    private ConnectionProvider connectionProvider;
    private static final Log log = LogFactory.getLog((Class)JDBCBinder.class);
    private final Mappings mappings;
    private final JDBCMetaDataConfiguration cfg;
    private ReverseEngineeringStrategy revengStrategy;

    public JDBCBinder(JDBCMetaDataConfiguration cfg, Settings settings, Mappings mappings, ReverseEngineeringStrategy revengStrategy) {
        this.cfg = cfg;
        this.settings = settings;
        this.mappings = mappings;
        this.revengStrategy = revengStrategy;
    }

    public void readFromDatabase(String catalog, String schema, Mapping mapping) {
        this.connectionProvider = this.settings.getConnectionProvider();
        try {
            Map oneToManyCandidates = this.readDatabaseSchema(catalog, schema);
            this.createPersistentClasses(oneToManyCandidates, mapping);
        }
        catch (SQLException e) {
            throw this.settings.getSQLExceptionConverter().convert(e, "Reading from database", null);
        }
        finally {
            if (this.connectionProvider != null) {
                this.connectionProvider.close();
            }
        }
    }

    public Map readDatabaseSchema(String catalog, String schema) throws SQLException {
        catalog = catalog != null ? catalog : this.settings.getDefaultCatalogName();
        schema = schema != null ? schema : this.settings.getDefaultSchemaName();
        JDBCReader reader = JDBCReaderFactory.newJDBCReader(this.cfg.getProperties(), this.settings, this.revengStrategy);
        DatabaseCollector dbs = new MappingsDatabaseCollector(this.mappings);
        dbs = reader.readDatabaseSchema(dbs, catalog, schema);
        return dbs.getOneToManyCandidates();
    }

    private void createPersistentClasses(Map manyToOneCandidates, Mapping mapping) {
        Iterator iter = this.mappings.iterateTables();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.getColumnSpan() == 0) {
                log.warn((Object)("Cannot create persistent class for " + table + " as no columns were found."));
                continue;
            }
            RootClass rc = new RootClass();
            rc.setEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(table)));
            rc.setClassName(this.revengStrategy.tableToClassName(TableIdentifier.create(table)));
            rc.setProxyInterfaceName(rc.getEntityName());
            rc.setLazy(true);
            rc.setDiscriminatorValue(rc.getEntityName());
            rc.setTable(table);
            this.mappings.addClass((PersistentClass)rc);
            this.mappings.addImport(rc.getEntityName(), rc.getEntityName());
            HashSet processed = new HashSet();
            this.bindPrimaryKeyToProperties(table, rc, processed, mapping);
            this.bindOutgoingForeignKeys(table, rc, processed);
            this.bindColumnsToProperties(table, rc, processed, mapping);
            List incomingForeignKeys = (List)manyToOneCandidates.get(rc.getEntityName());
            this.bindIncomingForeignKeys((PersistentClass)rc, processed, incomingForeignKeys, mapping);
        }
    }

    private void bindIncomingForeignKeys(PersistentClass rc, java.util.Set processed, List foreignKeys, Mapping mapping) {
        if (foreignKeys != null) {
            Iterator iter = foreignKeys.iterator();
            while (iter.hasNext()) {
                ForeignKey fk = (ForeignKey)iter.next();
                Property property = this.bindOneToMany(rc, fk, processed, mapping);
                rc.addProperty(property);
            }
        }
    }

    private Property bindManyToOne(String propertyName, Table table, ForeignKey fk, java.util.Set processedColumns) {
        ManyToOne value = new ManyToOne(table);
        value.setReferencedEntityName(fk.getReferencedEntityName());
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            this.checkColumn(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
        value.setFetchMode(FetchMode.SELECT);
        return JDBCBinder.makeProperty(propertyName, (Value)value, true, true, value.getFetchMode() != FetchMode.JOIN, null, null);
    }

    private Property bindOneToMany(PersistentClass rc, ForeignKey foreignKey, java.util.Set processed, Mapping mapping) {
        Table collectionTable = foreignKey.getTable();
        Set collection = new Set(rc);
        collection.setCollectionTable(collectionTable);
        boolean b = this.isUniqueReference(foreignKey);
        String collectionRole = this.revengStrategy.foreignKeyToCollectionName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), b);
        collectionRole = this.makeUnique(rc, collectionRole);
        String fullRolePath = StringHelper.qualify((String)rc.getEntityName(), (String)collectionRole);
        if (this.mappings.getCollection(fullRolePath) != null) {
            log.debug((Object)(fullRolePath + " found twice!"));
        }
        collection.setRole(fullRolePath);
        collection.setInverse(true);
        collection.setLazy(true);
        collection.setFetchMode(FetchMode.SELECT);
        OneToMany oneToMany = new OneToMany(collection.getOwner());
        oneToMany.setReferencedEntityName(this.revengStrategy.tableToClassName(TableIdentifier.create(foreignKey.getTable())));
        this.mappings.addSecondPass((SecondPass)new JDBCCollectionSecondPass(this.mappings, (Collection)collection));
        collection.setElement((Value)oneToMany);
        String propRef = collection.getReferencedPropertyName();
        KeyValue referencedKeyValue = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propRef).getValue();
        DependantValue keyValue = new DependantValue(collectionTable, referencedKeyValue);
        Iterator columnIterator = foreignKey.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column fkcolumn = (Column)columnIterator.next();
            if (fkcolumn.getSqlTypeCode() != null) {
                this.guessAndAlignType(collectionTable, fkcolumn, mapping);
            }
            keyValue.addColumn(fkcolumn);
        }
        collection.setKey((KeyValue)keyValue);
        this.mappings.addCollection((Collection)collection);
        return JDBCBinder.makeProperty(collectionRole, (Value)collection, true, true, true, "all", null);
    }

    private boolean isUniqueReference(ForeignKey foreignKey) {
        Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
        while (foreignKeyIterator.hasNext()) {
            ForeignKey element = (ForeignKey)foreignKeyIterator.next();
            if (element == foreignKey || !element.getReferencedTable().equals(foreignKey.getReferencedTable())) continue;
            return false;
        }
        return true;
    }

    private void bindPrimaryKeyToProperties(Table table, RootClass rc, java.util.Set processed, Mapping mapping) {
        SimpleValue id = null;
        String idPropertyname = null;
        ArrayList<Column> keyColumns = null;
        if (table.getPrimaryKey() != null) {
            keyColumns = table.getPrimaryKey().getColumns();
        } else {
            log.debug((Object)("No primary key found for " + table + ", using all properties as the identifier."));
            keyColumns = new ArrayList<Column>();
            Iterator iter = table.getColumnIterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyColumns.add(col);
            }
        }
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        if (keyColumns.size() > 1) {
            id = this.handleCompositeKey(rc, processed, keyColumns, mapping);
            idPropertyname = "id";
        } else {
            Column pkc = (Column)keyColumns.get(0);
            this.checkColumn(pkc);
            id = this.bindColumnToSimpleValue(table, pkc, mapping);
            idPropertyname = this.revengStrategy.columnToPropertyName(tableIdentifier, pkc.getName());
            processed.add(pkc);
        }
        id.setIdentifierGeneratorStrategy(this.revengStrategy.getTableIdentifierStrategyName(tableIdentifier));
        id.setIdentifierGeneratorProperties(this.revengStrategy.getTableIdentifierProperties(tableIdentifier));
        if ("assigned".equals(id.getIdentifierGeneratorStrategy())) {
            id.setNullValue("undefined");
        }
        Property property = JDBCBinder.makeProperty(this.makeUnique((PersistentClass)rc, idPropertyname), (Value)id, true, true, false, null, null);
        rc.setIdentifierProperty(property);
        rc.setIdentifier((KeyValue)id);
    }

    private void bindOutgoingForeignKeys(Table table, RootClass rc, java.util.Set processedColumns) {
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            boolean mutable = true;
            if (this.contains(foreignKey.getColumnIterator(), processedColumns)) {
                if (!this.cfg.preferBasicCompositeIds()) continue;
                mutable = false;
            }
            boolean isUnique = this.isUniqueReference(foreignKey);
            String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), isUnique);
            Property property = this.bindManyToOne(this.makeUnique((PersistentClass)rc, propertyName), table, foreignKey, processedColumns);
            property.setUpdateable(mutable);
            property.setInsertable(mutable);
            rc.addProperty(property);
        }
    }

    private void bindColumnsToProperties(Table table, RootClass rc, java.util.Set processedColumns, Mapping mapping) {
        Iterator iterator = table.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (processedColumns.contains(column)) continue;
            this.checkColumn(column);
            String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
            Property property = this.bindBasicProperty(this.makeUnique((PersistentClass)rc, propertyName), table, column, processedColumns, mapping);
            rc.addProperty(property);
        }
    }

    private Property bindBasicProperty(String propertyName, Table table, Column column, java.util.Set processedColumns, Mapping mapping) {
        SimpleValue value = this.bindColumnToSimpleValue(table, column, mapping);
        return JDBCBinder.makeProperty(propertyName, (Value)value, true, true, false, null, null);
    }

    private SimpleValue bindColumnToSimpleValue(Table table, Column column, Mapping mapping) {
        SimpleValue value = new SimpleValue(table);
        value.addColumn(column);
        value.setTypeName(this.guessAndAlignType(table, column, mapping));
        return value;
    }

    private boolean contains(Iterator columnIterator, java.util.Set processedColumns) {
        while (columnIterator.hasNext()) {
            Column element = (Column)columnIterator.next();
            if (!processedColumns.contains(element)) continue;
            return true;
        }
        return false;
    }

    private void checkColumn(Column column) {
        if (column.getValue() != null) {
            // empty if block
        }
    }

    private String guessAndAlignType(Table table, Column pkc, Mapping mapping) {
        Integer sqlTypeCode = pkc.getSqlTypeCode();
        String location = "Table: " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getQuotedName()) + " column: " + pkc.getQuotedName();
        if (sqlTypeCode == null) {
            throw new JDBCBinderException("sqltype is null for " + location);
        }
        String preferredHibernateType = this.revengStrategy.columnToHibernateTypeName(TableIdentifier.create(table), pkc.getName(), sqlTypeCode, pkc.getLength(), pkc.getPrecision(), pkc.getScale());
        Type wantedType = TypeFactory.heuristicType((String)preferredHibernateType);
        if (wantedType != null) {
            int[] wantedSqlTypes = wantedType.sqlTypes(mapping);
            if (wantedSqlTypes.length > 1) {
                throw new JDBCBinderException("The type " + preferredHibernateType + " found on " + location + " spans multiple columns. Only single column types allowed.");
            }
            int wantedSqlType = wantedSqlTypes[0];
            if (wantedSqlType != sqlTypeCode) {
                log.debug((Object)("Sql type mismatch for " + location + " between DB and wanted hibernate type. Sql type set to " + this.typeCodeName(sqlTypeCode) + " instead of " + this.typeCodeName(wantedSqlType)));
                pkc.setSqlTypeCode(new Integer(wantedSqlType));
            }
        } else {
            log.debug((Object)("No Hibernate type found for " + preferredHibernateType + ". Most likely cause is a missing UserType class."));
        }
        if (preferredHibernateType == null) {
            throw new JDBCBinderException("Could not find javatype for " + this.typeCodeName(sqlTypeCode));
        }
        return preferredHibernateType;
    }

    private String typeCodeName(int sqlTypeCode) {
        return sqlTypeCode + "(" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlTypeCode) + ")";
    }

    private SimpleValue handleCompositeKey(RootClass rc, java.util.Set processedColumns, List keyColumns, Mapping mapping) {
        Component pkc = new Component((PersistentClass)rc);
        pkc.setMetaAttributes(Collections.EMPTY_MAP);
        pkc.setEmbedded(false);
        pkc.setComponentClassName(this.revengStrategy.classNameToCompositeIdName(rc.getClassName()));
        Table table = rc.getTable();
        List list = null;
        list = this.cfg.preferBasicCompositeIds() ? new ArrayList(keyColumns) : this.findForeignKeys(table.getForeignKeyIterator(), keyColumns);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Property property;
            Object element = iter.next();
            if (element instanceof Column) {
                Column column = (Column)element;
                if (processedColumns.contains(column)) {
                    throw new JDBCBinderException("Binding column twice for primary key should not happen: " + column);
                }
                this.checkColumn(column);
                String propertyName = this.revengStrategy.columnToPropertyName(TableIdentifier.create(table), column.getName());
                property = this.bindBasicProperty(this.makeUnique(pkc, propertyName), table, column, processedColumns, mapping);
                processedColumns.add(column);
            } else if (element instanceof ForeignKeyForColumns) {
                ForeignKeyForColumns fkfc = (ForeignKeyForColumns)element;
                ForeignKey foreignKey = fkfc.key;
                String propertyName = this.revengStrategy.foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), true);
                property = this.bindManyToOne(this.makeUnique(pkc, propertyName), table, foreignKey, processedColumns);
                processedColumns.addAll(fkfc.columns);
            } else {
                throw new JDBCBinderException("unknown thing");
            }
            this.markAsUseInEquals(property);
            pkc.addProperty(property);
        }
        return pkc;
    }

    private void markAsUseInEquals(Property property) {
        HashMap<String, MetaAttribute> m = new HashMap<String, MetaAttribute>();
        MetaAttribute ma = new MetaAttribute("use-in-equals");
        ma.addValue("true");
        m.put(ma.getName(), ma);
        property.setMetaAttributes(m);
    }

    private List findForeignKeys(Iterator foreignKeyIterator, List pkColumns) {
        ArrayList tempList = new ArrayList();
        while (foreignKeyIterator.hasNext()) {
            tempList.add(foreignKeyIterator.next());
        }
        ArrayList<ForeignKeyForColumns> result = new ArrayList<ForeignKeyForColumns>();
        Column[] myPkColumns = pkColumns.toArray(new Column[pkColumns.size()]);
        for (int i = 0; i < myPkColumns.length; ++i) {
            boolean foundKey = false;
            foreignKeyIterator = tempList.iterator();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey key = (ForeignKey)foreignKeyIterator.next();
                List matchingColumns = this.columnMatches(myPkColumns, i, key);
                if (matchingColumns == null) continue;
                result.add(new ForeignKeyForColumns(key, matchingColumns));
                i += matchingColumns.size() - 1;
                foreignKeyIterator.remove();
                foundKey = true;
                break;
            }
            if (foundKey) continue;
            result.add((ForeignKeyForColumns)myPkColumns[i]);
        }
        return result;
    }

    private List columnMatches(Column[] myPkColumns, int offset, ForeignKey key) {
        if (key.getColumnSpan() > myPkColumns.length - offset) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int j = 0; j < key.getColumnSpan(); ++j) {
            Column column = myPkColumns[j + offset];
            if (!column.equals(key.getColumn(j))) {
                return null;
            }
            columns.add(column);
        }
        return columns.isEmpty() ? null : columns;
    }

    private static Property makeProperty(String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade, String propertyAccessorName) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade == null ? "none" : cascade);
        prop.setPropertyAccessorName(propertyAccessorName == null ? "property" : propertyAccessorName);
        prop.setMetaAttributes(Collections.EMPTY_MAP);
        log.debug((Object)("Cascading " + propertyName + " with " + cascade));
        return prop;
    }

    private String makeUnique(Component clazz, String propertyName) {
        return JDBCBinder.makeUnique(clazz.getPropertyIterator(), propertyName);
    }

    private String makeUnique(PersistentClass clazz, String propertyName) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (clazz.hasIdentifierProperty()) {
            list.add(clazz.getIdentifierProperty());
        }
        if (clazz.isVersioned()) {
            list.add(clazz.getVersion());
        }
        JoinedIterator iterator = new JoinedIterator(list.iterator(), clazz.getPropertyClosureIterator());
        return JDBCBinder.makeUnique((Iterator)iterator, propertyName);
    }

    private static String makeUnique(Iterator props, String originalPropertyName) {
        int cnt = 0;
        String propertyName = originalPropertyName;
        HashSet<String> uniqueNames = new HashSet<String>();
        while (props.hasNext()) {
            Property element = (Property)props.next();
            uniqueNames.add(element.getName());
        }
        while (uniqueNames.contains(propertyName)) {
            propertyName = originalPropertyName + "_" + ++cnt;
        }
        return propertyName;
    }

    public static void bindCollectionSecondPass(Collection collection, Map persistentClasses, Mappings mappings, Map inheritedMetas) throws MappingException {
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            PersistentClass persistentClass = mappings.getClass(oneToMany.getReferencedEntityName());
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(persistentClass);
        }
    }

    static class JDBCCollectionSecondPass
    extends CollectionSecondPass {
        JDBCCollectionSecondPass(Mappings mappings, Collection coll) {
            super(mappings, coll);
        }

        public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
            JDBCBinder.bindCollectionSecondPass(this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class ForeignKeyForColumns {
        protected final List columns;
        protected final ForeignKey key;

        public ForeignKeyForColumns(ForeignKey key, List columns) {
            this.key = key;
            this.columns = columns;
        }
    }
}

