/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.beans.Introspector;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.mapping.Column;
import org.hibernate.util.StringHelper;

public class DefaultReverseEngineeringStrategy
implements ReverseEngineeringStrategy {
    Log log = LogFactory.getLog((Class)DefaultReverseEngineeringStrategy.class);
    String packageName = "";
    private static Set RESERVED_KEYWORDS = new HashSet();

    public String columnToPropertyName(TableIdentifier table, String columnName) {
        String decapitalize = Introspector.decapitalize(this.toUpperCamelCase(columnName));
        return this.keywordCheck(decapitalize);
    }

    private String keywordCheck(String decapitalize) {
        if (RESERVED_KEYWORDS.contains(decapitalize)) {
            decapitalize = decapitalize + "_";
        }
        return decapitalize;
    }

    protected String toUpperCamelCase(String s) {
        if ("".equals(s)) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        boolean capitalize = true;
        boolean lastCapital = false;
        boolean lastDecapitalized = false;
        String p = null;
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("_".equals(c) || " ".equals(c) || "-".equals(c)) {
                capitalize = true;
                continue;
            }
            if (c.toUpperCase().equals(c)) {
                if (lastDecapitalized && !lastCapital) {
                    capitalize = true;
                }
                lastCapital = true;
            } else {
                lastCapital = false;
            }
            if (capitalize) {
                if (p == null || !p.equals("_")) {
                    result.append(c.toUpperCase());
                    capitalize = false;
                    p = c;
                    continue;
                }
                result.append(c.toLowerCase());
                capitalize = false;
                p = c;
                continue;
            }
            result.append(c.toLowerCase());
            lastDecapitalized = true;
            p = c;
        }
        String r = result.toString();
        return r;
    }

    public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(fromTable)));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (fromColumns != null && fromColumns.size() == 1) {
                String columnName = ((Column)fromColumns.get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    protected String pluralize(String singular) {
        char last = singular.charAt(singular.length() - 1);
        switch (last) {
            case 's': 
            case 'x': {
                singular = singular + "es";
                break;
            }
            case 'y': {
                singular = singular.substring(0, singular.length() - 1) + "ies";
                break;
            }
            default: {
                singular = singular + "s";
            }
        }
        return singular;
    }

    public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(referencedTable)));
        if (!uniqueReference) {
            if (fromColumnNames != null && fromColumnNames.size() == 1) {
                String columnName = ((Column)fromColumnNames.get(0)).getName();
                propertyName = propertyName + "By" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "By" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    public void setPackageName(String pkg) {
        if (pkg == null) {
            this.packageName = "";
        }
        this.packageName = pkg.trim();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale) {
        String preferredHibernateType = JDBCToHibernateTypeHelper.getPreferredHibernateType(sqlType, length, precision, scale);
        if (preferredHibernateType == null) {
            this.log.debug((Object)("No preferred hibernate type found for " + table.toString() + " column: " + columnName + " falling back to 'serializable'"));
            return "java.lang.Serializable";
        }
        return preferredHibernateType;
    }

    public boolean excludeTable(TableIdentifier ti) {
        return ti.getName().startsWith("BIN$");
    }

    public String tableToClassName(TableIdentifier tableIdentifier) {
        String pkgName = this.packageName == null ? "" : this.packageName;
        String className = this.toUpperCamelCase(tableIdentifier.getName());
        if (pkgName.length() > 0) {
            return StringHelper.qualify((String)pkgName, (String)className);
        }
        return className;
    }

    public List getForeignKeys(TableIdentifier referencedTable) {
        return Collections.EMPTY_LIST;
    }

    public String columnToHibernateTypeName(TableIdentifier identifier, String name) {
        return null;
    }

    public String getTableIdentifierStrategyName(TableIdentifier identifier) {
        return "assigned";
    }

    public Properties getTableIdentifierProperties(TableIdentifier identifier) {
        return null;
    }

    public List getPrimaryKeyColumnNames(TableIdentifier identifier) {
        return null;
    }

    public String classNameToCompositeIdName(String className) {
        return className + "Id";
    }

    public void configure(ConnectionProvider provider, SQLExceptionConverter sec) {
    }

    public void close() {
    }

    static {
        RESERVED_KEYWORDS.add("abstract");
        RESERVED_KEYWORDS.add("continue");
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("new");
        RESERVED_KEYWORDS.add("switch");
        RESERVED_KEYWORDS.add("assert");
        RESERVED_KEYWORDS.add("default");
        RESERVED_KEYWORDS.add("goto");
        RESERVED_KEYWORDS.add("package");
        RESERVED_KEYWORDS.add("synchronized");
        RESERVED_KEYWORDS.add("boolean");
        RESERVED_KEYWORDS.add("do");
        RESERVED_KEYWORDS.add("if");
        RESERVED_KEYWORDS.add("private");
        RESERVED_KEYWORDS.add("this");
        RESERVED_KEYWORDS.add("break");
        RESERVED_KEYWORDS.add("double");
        RESERVED_KEYWORDS.add("implements");
        RESERVED_KEYWORDS.add("protected");
        RESERVED_KEYWORDS.add("throw");
        RESERVED_KEYWORDS.add("byte");
        RESERVED_KEYWORDS.add("else");
        RESERVED_KEYWORDS.add("import");
        RESERVED_KEYWORDS.add("public");
        RESERVED_KEYWORDS.add("throws");
        RESERVED_KEYWORDS.add("case");
        RESERVED_KEYWORDS.add("enum");
        RESERVED_KEYWORDS.add("instanceof");
        RESERVED_KEYWORDS.add("return");
        RESERVED_KEYWORDS.add("transient");
        RESERVED_KEYWORDS.add("catch");
        RESERVED_KEYWORDS.add("extends");
        RESERVED_KEYWORDS.add("int");
        RESERVED_KEYWORDS.add("short");
        RESERVED_KEYWORDS.add("try");
        RESERVED_KEYWORDS.add("char");
        RESERVED_KEYWORDS.add("final");
        RESERVED_KEYWORDS.add("interface");
        RESERVED_KEYWORDS.add("static");
        RESERVED_KEYWORDS.add("void");
        RESERVED_KEYWORDS.add("class");
        RESERVED_KEYWORDS.add("finally");
        RESERVED_KEYWORDS.add("long");
        RESERVED_KEYWORDS.add("strictfp");
        RESERVED_KEYWORDS.add("volatile");
        RESERVED_KEYWORDS.add("const");
        RESERVED_KEYWORDS.add("float");
        RESERVED_KEYWORDS.add("native");
        RESERVED_KEYWORDS.add("super");
        RESERVED_KEYWORDS.add("while");
    }
}

