/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;

public final class JDBCToHibernateTypeHelper {
    private static final Map PREFERRED_HIBERNATETYPE_FOR_SQLTYPE = new HashMap();
    static Map jdbcTypes;
    static Map jdbcTypeValues;

    private JDBCToHibernateTypeHelper() {
    }

    public static String getPreferredHibernateType(int sqlType, int size, int precision, int scale) {
        if ((sqlType == 3 || sqlType == 2) && scale <= 0) {
            if (precision == 1) {
                return "boolean";
            }
            if (precision < 3) {
                return "byte";
            }
            if (precision < 5) {
                return "short";
            }
            if (precision < 10) {
                return "integer";
            }
            if (precision < 19) {
                return "long";
            }
            return "big_decimal";
        }
        if (sqlType == 1 && size > 1) {
            return "string";
        }
        String result = (String)PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.get(new Integer(sqlType));
        return result;
    }

    public static String[] getJDBCTypes() {
        JDBCToHibernateTypeHelper.checkTypes();
        return jdbcTypes.keySet().toArray(new String[jdbcTypes.size()]);
    }

    public static int getJDBCType(String value) {
        JDBCToHibernateTypeHelper.checkTypes();
        Integer number = (Integer)jdbcTypes.get(value);
        if (number == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new MappingException("jdbc-type: " + value + " is not a known JDBC Type nor a valid number");
            }
        }
        return number;
    }

    private static void checkTypes() {
        if (jdbcTypes == null) {
            jdbcTypes = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypes.put(field.getName(), field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getJDBCTypeName(int value) {
        String name;
        if (jdbcTypeValues == null) {
            jdbcTypeValues = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypeValues.put(field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types), field.getName());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if ((name = (String)jdbcTypeValues.get(new Integer(value))) != null) {
            return name;
        }
        return "" + value;
    }

    public static boolean typeHasScaleAndPrecision(int sqlType) {
        return sqlType == 3 || sqlType == 2 || sqlType == 7 || sqlType == 6 || sqlType == 8;
    }

    public static boolean typeHasLength(int sqlType) {
        return sqlType == 1 || sqlType == 91 || sqlType == -1 || sqlType == 92 || sqlType == 93 || sqlType == 12;
    }

    static {
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-6), "byte");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(5), "short");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(4), "integer");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-5), "long");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(7), "float");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(6), "double");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(8), "double");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(3), "big_decimal");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2), "big_decimal");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-7), "boolean");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(16), "boolean");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(1), "character");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(12), "string");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-1), "string");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-2), "binary");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-3), "binary");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(-4), "binary");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(91), "date");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(92), "time");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(93), "timestamp");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2005), "clob");
        PREFERRED_HIBERNATETYPE_FOR_SQLTYPE.put(new Integer(2004), "blob");
    }
}

