/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.cglib.core.KeyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.DelegatingReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideBinder;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OverrideRepository {
    private static final Log log = LogFactory.getLog((Class)OverrideRepository.class);
    private final transient XMLHelper xmlHelper = new XMLHelper();
    private final transient EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
    private final Map typeMappings = new HashMap();
    private final List tableFilters = new ArrayList();
    private final List tables = new ArrayList();
    private final Map foreignKeys = new HashMap();
    private final Map typeForColumn = new HashMap();
    private final Map propertyNameForColumn = new HashMap();
    private final Map identifierStrategyForTable = new HashMap();
    private final Map identifierPropertiesForTable = new HashMap();
    private final Map primaryKeyColumnsForTable = new HashMap();
    private String defaultCatalog = null;
    private String defaultSchema = null;
    private HashMap tableToClassName = new HashMap();
    private static final TableColumnKeyFactory TABLECOLUMN_KEY_FACTORY = (TableColumnKeyFactory)KeyFactory.create((Class)TableColumnKeyFactory.class);

    public OverrideRepository(String defaultCatalog, String defaultSchema) {
    }

    public OverrideRepository addFile(File xmlFile) {
        log.info((Object)("Override file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure overrides from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException("Could not configure overrides from file: " + xmlFile.getPath(), (Throwable)e);
        }
        return this;
    }

    public OverrideRepository addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = OverrideRepository.class.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, (Throwable)me);
        }
    }

    public OverrideRepository addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ArrayList errors = new ArrayList();
            Document doc = this.xmlHelper.createSAXReader("XML InputStream", errors, this.entityResolver).read(new InputSource(xmlInputStream));
            if (errors.size() != 0) {
                throw new MappingException("invalid override definition", (Throwable)errors.get(0));
            }
            this.add(doc);
            OverrideRepository overrideRepository = this;
            return overrideRepository;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.error((Object)"Could not configure overrides from input stream", (Throwable)e);
            throw new MappingException((Throwable)e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
            }
        }
    }

    private OverrideRepository add(Document doc) {
        OverrideBinder.bindRoot(this, doc);
        return this;
    }

    private String getPreferredHibernateType(int sqlType, int length, int precision, int scale) {
        List l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, length));
        if (l == null) {
            l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, Integer.MAX_VALUE));
        }
        return this.scanForMatch(sqlType, length, precision, scale, l);
    }

    private String scanForMatch(int sqlType, int length, int precision, int scale, List l) {
        if (l != null) {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                SQLTypeMapping element = (SQLTypeMapping)iterator.next();
                if (element.getJDBCType() != sqlType) {
                    return null;
                }
                if (!element.match(sqlType, length, precision, scale)) continue;
                return element.getHibernateType();
            }
        }
        return null;
    }

    public OverrideRepository addTypeMapping(SQLTypeMapping sqltype) {
        TypeMappingKey key = new TypeMappingKey(sqltype);
        ArrayList<SQLTypeMapping> list = (ArrayList<SQLTypeMapping>)this.typeMappings.get(key);
        if (list == null) {
            list = new ArrayList<SQLTypeMapping>();
            this.typeMappings.put(key, list);
        }
        list.add(sqltype);
        return this;
    }

    protected String getPackageName(TableIdentifier identifier) {
        Iterator iterator = this.tableFilters.iterator();
        while (iterator.hasNext()) {
            TableFilter tf = (TableFilter)iterator.next();
            String value = tf.getPackage(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected boolean excludeTable(TableIdentifier identifier) {
        Iterator iterator = this.tableFilters.iterator();
        boolean hasInclude = false;
        while (iterator.hasNext()) {
            TableFilter tf = (TableFilter)iterator.next();
            Boolean value = tf.exclude(identifier);
            if (value != null) {
                return value;
            }
            if (tf.getExclude().booleanValue()) continue;
            hasInclude = true;
        }
        return hasInclude;
    }

    public void addTableFilter(TableFilter filter) {
        this.tableFilters.add(filter);
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy(ReverseEngineeringStrategy delegate) {
        return new DelegatingReverseEngineeringStrategy(delegate){

            public boolean excludeTable(TableIdentifier ti) {
                return OverrideRepository.this.excludeTable(ti);
            }

            public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale) {
                String result = null;
                String location = "";
                location = table != null ? "Table: " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) : location + " Column: " + columnName + " l:" + length + " p:" + precision + " s:" + scale;
                if (table != null && columnName != null && (result = (String)OverrideRepository.this.typeForColumn.get(TABLECOLUMN_KEY_FACTORY.newInstance(table, columnName))) != null) {
                    log.debug((Object)("columnToHibernateTypeName, explicit mapping found: " + result + " for " + location));
                    return result;
                }
                result = OverrideRepository.this.getPreferredHibernateType(sqlType, length, precision, scale);
                if (result == null) {
                    return super.columnToHibernateTypeName(table, columnName, sqlType, length, precision, scale);
                }
                log.debug((Object)("columnToHibernateTypeName, <type-mapping> found: " + result + " for " + location));
                return result;
            }

            public String tableToClassName(TableIdentifier tableIdentifier) {
                String className = (String)OverrideRepository.this.tableToClassName.get(tableIdentifier);
                if (className != null) {
                    return className;
                }
                String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                if (packageName == null) {
                    return super.tableToClassName(tableIdentifier);
                }
                String string = super.tableToClassName(tableIdentifier);
                if (string == null) {
                    return null;
                }
                return StringHelper.qualify((String)packageName, (String)StringHelper.unqualify((String)string));
            }

            public List getForeignKeys(TableIdentifier referencedTable) {
                List list = (List)OverrideRepository.this.foreignKeys.get(referencedTable);
                if (list == null) {
                    return super.getForeignKeys(referencedTable);
                }
                return list;
            }

            public String columnToPropertyName(TableIdentifier table, String column) {
                String result = (String)OverrideRepository.this.propertyNameForColumn.get(TABLECOLUMN_KEY_FACTORY.newInstance(table, column));
                if (result == null) {
                    return super.columnToPropertyName(table, column);
                }
                return result;
            }

            public String getTableIdentifierStrategyName(TableIdentifier tableIdentifier) {
                String result = (String)OverrideRepository.this.identifierStrategyForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierStrategyName(tableIdentifier);
                }
                return result;
            }

            public Properties getTableIdentifierProperties(TableIdentifier tableIdentifier) {
                Properties result = (Properties)OverrideRepository.this.identifierPropertiesForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierProperties(tableIdentifier);
                }
                return result;
            }

            public List getPrimaryKeyColumnNames(TableIdentifier tableIdentifier) {
                List result = (List)OverrideRepository.this.primaryKeyColumnsForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getPrimaryKeyColumnNames(tableIdentifier);
                }
                return result;
            }
        };
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.getReverseEngineeringStrategy(null);
    }

    public void addTable(Table table, String wantedClassName) {
        Iterator fkIter = table.getForeignKeyIterator();
        while (fkIter.hasNext()) {
            ForeignKey fk = (ForeignKey)fkIter.next();
            TableIdentifier identifier = TableIdentifier.create(fk.getReferencedTable());
            ArrayList<ForeignKey> existing = (ArrayList<ForeignKey>)this.foreignKeys.get(identifier);
            if (existing == null) {
                existing = new ArrayList<ForeignKey>();
                this.foreignKeys.put(identifier, existing);
            }
            existing.add(fk);
        }
        this.tables.add(table);
        if (StringHelper.isNotEmpty((String)wantedClassName)) {
            this.tableToClassName.put(TableIdentifier.create(table), wantedClassName);
        }
    }

    public void setTypeNameForColumn(TableIdentifier identifier, String columnName, String type) {
        if (StringHelper.isNotEmpty((String)type)) {
            this.typeForColumn.put(TABLECOLUMN_KEY_FACTORY.newInstance(identifier, columnName), type);
        }
    }

    public void setPropertyNameForColumn(TableIdentifier identifier, String columnName, String property) {
        if (StringHelper.isNotEmpty((String)property)) {
            this.propertyNameForColumn.put(TABLECOLUMN_KEY_FACTORY.newInstance(identifier, columnName), property);
        }
    }

    public void addTableIdentifierStrategy(Table table, String identifierClass, Properties params) {
        if (identifierClass != null) {
            TableIdentifier tid = TableIdentifier.create(table);
            this.identifierStrategyForTable.put(tid, identifierClass);
            this.identifierPropertiesForTable.put(tid, params);
        }
    }

    public void addPrimaryKeyNamesForTable(Table table, List boundColumnNames) {
        if (boundColumnNames != null && !boundColumnNames.isEmpty()) {
            this.primaryKeyColumnsForTable.put(TableIdentifier.create(table), boundColumnNames);
        }
    }

    public String getCatalog(String string) {
        return string == null ? this.defaultCatalog : string;
    }

    public String getSchema(String string) {
        return string == null ? this.defaultSchema : string;
    }

    static interface TableColumnKeyFactory {
        public Object newInstance(TableIdentifier var1, String var2);
    }

    static class TypeMappingKey {
        int type;
        int length;

        TypeMappingKey(SQLTypeMapping mpa) {
            this.type = mpa.getJDBCType();
            this.length = mpa.getLength();
        }

        public TypeMappingKey(int sqlType, int length) {
            this.type = sqlType;
            this.length = length;
        }

        public boolean equals(Object obj) {
            TypeMappingKey other = (TypeMappingKey)obj;
            if (obj == null) {
                return false;
            }
            return this.type == other.type && this.length == other.length;
        }

        public int hashCode() {
            return (this.type + this.length) % 17;
        }

        public String toString() {
            return this.getClass() + "(type:" + this.type + ", length:" + this.length + ")";
        }
    }
}

