/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import junit.framework.ComparisonFailure;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.BaseTestCase;

public abstract class JDBCMetaDataBinderTestCase
extends BaseTestCase {
    protected JDBCMetaDataConfiguration cfg;
    private static boolean storesLowerCaseIdentifiers;
    private static boolean storesUpperCaseIdentifiers;

    public JDBCMetaDataBinderTestCase() {
        super(null);
    }

    protected String identifier(String actual) {
        if (storesLowerCaseIdentifiers) {
            return actual.toLowerCase();
        }
        if (storesUpperCaseIdentifiers) {
            return actual.toUpperCase();
        }
        return actual;
    }

    protected void assertEqualIdentifiers(String expected, String actual) {
        JDBCMetaDataBinderTestCase.assertEquals((String)this.identifier(expected), (String)this.identifier(actual));
    }

    protected void executeDDL(String[] sqls) throws SQLException {
        Configuration configuration = new Configuration();
        Settings testSettings = configuration.buildSettings();
        Connection con = testSettings.getConnectionProvider().getConnection();
        DatabaseMetaData metaData = con.getMetaData();
        storesLowerCaseIdentifiers = metaData.storesLowerCaseIdentifiers();
        storesUpperCaseIdentifiers = metaData.storesUpperCaseIdentifiers();
        Statement statement = con.createStatement();
        for (int i = 0; i < sqls.length; ++i) {
            String string = sqls[i];
            System.out.println("Execute: " + string);
            statement.execute(string);
            continue;
        }
        if (statement != null) {
            statement.close();
        }
        con.commit();
        testSettings.getConnectionProvider().closeConnection(con);
    }

    protected abstract String[] getCreateSQL();

    protected abstract String[] getDropSQL();

    protected void setUp() throws Exception {
        if (this.cfg == null) {
            try {
                this.executeDDL(this.getDropSQL());
            }
            catch (SQLException se) {
                System.err.println("Error while dropping - normally ok.");
                se.printStackTrace();
            }
            this.cfg = new JDBCMetaDataConfiguration();
            this.configure(this.cfg);
            String[] sqls = this.getCreateSQL();
            this.executeDDL(sqls);
            this.cfg.readFromJDBC();
        }
    }

    protected void tearDown() throws Exception {
        this.executeDDL(this.getDropSQL());
    }

    protected void configure(JDBCMetaDataConfiguration cfg) {
    }

    protected void assertHasNext(int expected, Iterator foreignKeyIterator) {
        this.assertHasNext(null, expected, foreignKeyIterator);
    }

    protected void assertHasNext(String reason, int expected, Iterator foreignKeyIterator) {
        int actual;
        for (actual = 0; foreignKeyIterator.hasNext() && actual <= expected; ++actual) {
            foreignKeyIterator.next();
        }
        if (actual < expected) {
            throw new ComparisonFailure(reason == null ? "Expected were less" : reason, "" + expected, "" + actual);
        }
        if (actual > expected) {
            throw new ComparisonFailure(reason == null ? "Expected were higher" : reason, "" + expected, "" + actual);
        }
    }

    protected String toPropertyName(String column) {
        return this.cfg.getReverseEngineeringStrategy().columnToPropertyName(null, column);
    }

    protected String toClassName(String table) {
        return this.cfg.getReverseEngineeringStrategy().tableToClassName(new TableIdentifier(null, null, table));
    }

    protected ForeignKey getForeignKey(Table table, String fkName) {
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            if (!fk.getName().equals(fkName)) continue;
            return fk;
        }
        return null;
    }

    protected Table getTable(String tabName) {
        Iterator iter = this.cfg.getTableMappings();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (!table.getName().equals(tabName)) continue;
            return table;
        }
        return null;
    }
}

