/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool;

import java.io.File;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.tool.BaseTestCase;
import org.hibernate.tool.hbm2x.HibernateUberspect;
import org.hibernate.tool.test.TestHelper;

public abstract class NonReflectiveTestCase
extends BaseTestCase {
    private static SessionFactory sessions;
    private static Configuration cfg;
    private static Dialect dialect;
    private static Class lastTestClass;
    private Session session;
    private File outputdir;

    public NonReflectiveTestCase(String name, String outputdir) {
        super(name);
        this.outputdir = new File("hbm2xoutput", outputdir);
    }

    protected boolean recreateSchema() {
        return true;
    }

    private void buildConfiguration(String[] files) {
        NonReflectiveTestCase.setCfg(new Configuration());
        if (this.recreateSchema()) {
            cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].startsWith("net/")) {
                files[i] = this.getBaseForMappings() + files[i];
            }
            System.out.println("bc in " + ((Object)((Object)this)).getClass() + " " + this.getBaseForMappings() + " " + files[i]);
            NonReflectiveTestCase.getCfg().addResource(files[i], ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (this.getCacheConcurrencyStrategy() != null) {
            Iterator iter = cfg.getClassMappings();
            while (iter.hasNext()) {
                PersistentClass clazz = (PersistentClass)iter.next();
                Iterator props = clazz.getPropertyClosureIterator();
                boolean hasLob = false;
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    if (!prop.getValue().isSimpleValue()) continue;
                    String type = ((SimpleValue)prop.getValue()).getTypeName();
                    if ("blob".equals(type) || "clob".equals(type)) {
                        hasLob = true;
                    }
                    if (!Blob.class.getName().equals(type) && !Clob.class.getName().equals(type)) continue;
                    hasLob = true;
                }
                if (hasLob || clazz.isInherited()) continue;
                cfg.setCacheConcurrencyStrategy(clazz.getEntityName(), this.getCacheConcurrencyStrategy());
            }
            iter = cfg.getCollectionMappings();
            while (iter.hasNext()) {
                Collection coll = (Collection)iter.next();
                cfg.setCollectionCacheConcurrencyStrategy(coll.getRole(), this.getCacheConcurrencyStrategy());
            }
        }
        this.setDialect(Dialect.getDialect());
        NonReflectiveTestCase.getCfg().buildMappings();
    }

    protected String getBaseForMappings() {
        return "org/hibernate/test/";
    }

    public String getCacheConcurrencyStrategy() {
        return "nonstrict-read-write";
    }

    protected void setUp() throws Exception {
        if (this.getSessions() == null || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildConfiguration(this.getMappings());
            lastTestClass = ((Object)((Object)this)).getClass();
            this.prepareTestData();
        }
        if (this.outputdir != null) {
            this.outputdir.mkdirs();
        }
        HibernateUberspect.initMethodNotFoundCount();
    }

    protected void tearDown() throws Exception {
        if (this.outputdir != null) {
            TestHelper.deleteDir(this.outputdir);
        }
        NonReflectiveTestCase.assertEquals((String)("Method not found errors during template processing:\n " + HibernateUberspect.getMethodErrors()), (int)0, (int)HibernateUberspect.getMethodNotFoundCount());
    }

    protected void prepareTestData() {
    }

    protected void runTest() throws Throwable {
        boolean stats = sessions != null ? ((SessionFactoryImplementor)sessions).getStatistics().isStatisticsEnabled() : false;
        try {
            if (stats) {
                sessions.getStatistics().clear();
            }
            super.runTest();
            if (stats) {
                sessions.getStatistics().logSummary();
            }
            if (this.session != null && this.session.isOpen()) {
                if (this.session.isConnected()) {
                    this.session.connection().rollback();
                }
                this.session.close();
                this.session = null;
                NonReflectiveTestCase.fail((String)"unclosed session");
            } else {
                this.session = null;
            }
        }
        catch (Throwable e) {
            try {
                if (this.session != null && this.session.isOpen()) {
                    if (this.session.isConnected()) {
                        this.session.connection().rollback();
                    }
                    this.session.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (sessions != null) {
                    sessions.close();
                    sessions = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public Session openSession() throws HibernateException {
        this.session = this.getSessions().openSession();
        return this.session;
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.getSessions().openSession(interceptor);
        return this.session;
    }

    protected abstract String[] getMappings();

    protected SessionFactory getSessions() {
        return sessions;
    }

    private void setDialect(Dialect dialect) {
        NonReflectiveTestCase.dialect = dialect;
    }

    protected Dialect getDialect() {
        return dialect;
    }

    protected static void setCfg(Configuration cfg) {
        NonReflectiveTestCase.cfg = cfg;
    }

    protected static Configuration getCfg() {
        return cfg;
    }

    protected String findFirstString(String string, File file) {
        return TestHelper.findFirstString(string, file);
    }

    public File getOutputDir() {
        return this.outputdir;
    }
}

