/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.tool.ant.BuildFileTestCase;
import org.hibernate.tool.test.TestHelper;

public class HibernateToolTest
extends BuildFileTestCase {
    private String property;

    public HibernateToolTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        System.out.println(this.getLog());
    }

    protected void setUp() throws Exception {
        this.configureProject("src/testsupport/anttest-build.xml");
    }

    public void testConfiguration() {
        this.executeTarget("testantcfg");
        File baseDir = new File(this.project.getProperty("build.dir"), "topdown");
        File onlyCreate = new File(baseDir, "onlycreate.sql");
        File onlyDrop = new File(baseDir, "onlydrop.sql");
        File dropAndCreate = new File(baseDir, "dropandcreate.sql");
        HibernateToolTest.assertTrue((boolean)onlyCreate.exists());
        HibernateToolTest.assertTrue((boolean)onlyDrop.exists());
        HibernateToolTest.assertTrue((boolean)dropAndCreate.exists());
        HibernateToolTest.assertNotNull((Object)TestHelper.findFirstString("drop", dropAndCreate));
        HibernateToolTest.assertNotNull((Object)TestHelper.findFirstString("create", dropAndCreate));
        HibernateToolTest.assertEquals(null, (String)TestHelper.findFirstString("create", onlyDrop));
        HibernateToolTest.assertNotNull((Object)TestHelper.findFirstString("drop", onlyDrop));
        HibernateToolTest.assertEquals(null, (String)TestHelper.findFirstString("drop", onlyCreate));
        HibernateToolTest.assertNotNull((Object)TestHelper.findFirstString("create", onlyCreate));
    }

    public void testJDBCConfiguration() {
        this.executeTarget("testantjdbccfg");
    }

    public void testAnnotationConfiguration() {
        this.executeTarget("testantannotationcfg");
    }

    public void testHbm2JavaEJB3Configuration() {
        this.executeTarget("testantejb3hbm2java");
    }

    public void testCfg2HbmNoError() {
        this.executeTarget("testantcfg2hbm1");
    }

    public void testCfg2HbmWithCustomReverseNamingStrategy() {
        this.executeTarget("testantcfg2hbm2");
    }

    public void testCfg2HbmWithInvalidReverseNamingStrategy() {
        this.expectSpecificBuildException("testantcfg2hbm3", "namingStrategy attribute should not be loaded", "Could not create or find invalid.classname with one argument delegate constructor");
    }

    public void testCfg2HbmWithPackageName() {
        this.executeTarget("testantcfg2hbm4");
    }

    public void testCfg2HbmWithPackageNameAndReverseNamingStrategy() {
        this.executeTarget("testantcfg2hbm5");
    }

    public void testJDBCConfigWithRevEngXml() {
        this.executeTarget("testantjdbccfgoverrides");
    }

    public void testProperties() {
        this.executeTarget("testproperties");
    }

    public void testGenericExport() {
        this.executeTarget("testgeneric");
        this.property = this.project.getProperty("build.dir");
        HibernateToolTest.assertTrue((boolean)new File(this.property, "generic").exists());
        HibernateToolTest.assertTrue((boolean)new File(this.property, "generic/org/hibernate/tool/hbm2x/ant/TopDown.quote").exists());
    }

    public static Test suite() {
        return new TestSuite(HibernateToolTest.class);
    }
}

