/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.cfg.Configuration;
import org.hibernate.loader.custom.SQLQueryCollectionReturn;
import org.hibernate.loader.custom.SQLQueryJoinReturn;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.visitor.HBMTagForPersistentClassVisitor;
import org.hibernate.tool.hbm2x.visitor.HBMTagForValueVisitor;

public class Cfg2HbmTool {
    public String getTag(PersistentClass pc) {
        return (String)pc.accept(HBMTagForPersistentClassVisitor.INSTANCE);
    }

    public String getTag(Property property) {
        return (String)property.getValue().accept((ValueVisitor)HBMTagForValueVisitor.INSTANCE);
    }

    public boolean isUnsavedValue(Property property) {
        SimpleValue sv = (SimpleValue)property.getValue();
        return sv.getNullValue() != null && !"undefined".equals(sv.getNullValue());
    }

    public String getUnsavedValue(Property property) {
        return ((SimpleValue)property.getValue()).getNullValue();
    }

    public boolean isIdentifierGeneratorProperties(Property property) {
        Properties val = this.getIdentifierGeneratorProperties(property);
        return val != null;
    }

    public Properties getIdentifierGeneratorProperties(Property property) {
        return ((SimpleValue)property.getValue()).getIdentifierGeneratorProperties();
    }

    public Set getFilteredIdentifierGeneratorKeySet(Property property) {
        HashSet<String> sval = new HashSet<String>();
        Properties pval = this.getIdentifierGeneratorProperties(property);
        Iterator<Object> itr = pval.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key.startsWith("target_")) continue;
            sval.add(key);
        }
        return sval;
    }

    public boolean isOneToMany(Property property) {
        return this.isOneToMany(property.getValue());
    }

    public boolean isOneToMany(Value value) {
        if (value instanceof Collection) {
            return ((Collection)value).isOneToMany();
        }
        return value instanceof OneToMany;
    }

    public boolean isCollection(Property property) {
        return property.getValue() != null && property.getValue() instanceof Collection;
    }

    public boolean isManyToOne(Property property) {
        return property.getValue() != null && property.getValue() instanceof ManyToOne;
    }

    public boolean isNamedQueries(Configuration cfg) {
        Map nqry = cfg.getNamedQueries();
        return nqry != null && !nqry.isEmpty();
    }

    public boolean isNamedSQLQueries(Configuration cfg) {
        Map nsqlqry = cfg.getNamedSQLQueries();
        return nsqlqry != null && !nsqlqry.isEmpty();
    }

    public String getNamedSQLReturnTag(SQLQueryReturn sqlret) {
        String retVal = "return";
        if (this.isNamedSQLReturnRole(sqlret)) {
            retVal = "return-join";
        } else if (this.isNamedSQLReturnCollection(sqlret)) {
            retVal = "load-collection";
        }
        return retVal;
    }

    public boolean isNamedSQLReturnRoot(SQLQueryReturn sqlret) {
        return sqlret instanceof SQLQueryRootReturn;
    }

    public boolean isNamedSQLReturnCollection(SQLQueryReturn sqlret) {
        return sqlret instanceof SQLQueryCollectionReturn;
    }

    public boolean isNamedSQLReturnRole(SQLQueryReturn sqlret) {
        return sqlret instanceof SQLQueryJoinReturn;
    }

    public boolean isFilterDefinitions(Configuration cfg) {
        Map filterdefs = cfg.getFilterDefinitions();
        return filterdefs != null && !filterdefs.isEmpty();
    }

    public boolean isClassLevelOptimisticLockMode(PersistentClass pc) {
        return pc.getOptimisticLockMode() != 0;
    }

    public String getClassLevelOptimisticLockMode(PersistentClass pc) {
        int oMode = pc.getOptimisticLockMode();
        if (oMode == 1) {
            return "dirty";
        }
        if (oMode == 2) {
            return "all";
        }
        if (oMode == -1) {
            return "none";
        }
        return "version";
    }

    public boolean hasFetchMode(Property property) {
        String fetch = this.getFetchMode(property);
        return fetch != null && !"default".equals(fetch);
    }

    public String getFetchMode(Property property) {
        FetchMode fetchMode = property.getValue().getFetchMode();
        return fetchMode.toString().toLowerCase();
    }

    public Formula getFormulaForProperty(Property prop) {
        Iterator iter = prop.getValue().getColumnIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Formula)) continue;
            return (Formula)o;
        }
        return null;
    }

    public String columnAttributes(Column col) {
        return this.columnAttributes(col, false);
    }

    public String columnAttributes(Column column, boolean isPrimaryKeyColumn) {
        StringBuffer sb = new StringBuffer();
        if (column.getPrecision() != 19) {
            sb.append("precision=\"").append(column.getPrecision()).append("\" ");
        }
        if (column.getScale() != 2) {
            sb.append("scale=\"").append(column.getScale()).append("\" ");
        } else if (column.getLength() != 255) {
            sb.append("length=\"").append(column.getLength()).append("\" ");
        }
        if (!isPrimaryKeyColumn) {
            if (!column.isNullable()) {
                sb.append("not-null=\"true\"");
            }
            if (column.isUnique()) {
                sb.append("unique=\"true\"");
            }
        }
        if (column.getSqlType() != null) {
            sb.append("sql-type=\"");
            sb.append(column.getSqlType());
            sb.append("\" ");
        }
        return sb.toString();
    }

    public String getClassName(PersistentClass pc) {
        if (pc.hasPojoRepresentation()) {
            return pc.getClassName();
        }
        throw new ExporterException(pc + " does not have a pojo rep.");
    }

    public String getProxyInterfaceName(PersistentClass pc) {
        if (pc.hasPojoRepresentation()) {
            return pc.getClassName();
        }
        throw new ExporterException(pc + " does not have a pojo rep.");
    }

    public boolean isImportData(Configuration cfg) {
        return !cfg.getImports().isEmpty();
    }
}

