/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.VelocityProducer;
import org.hibernate.tool.hbm2x.doc.DocFile;
import org.hibernate.tool.hbm2x.doc.DocFileManager;
import org.hibernate.tool.hbm2x.doc.DocHelper;

public class DocExporter
extends AbstractExporter {
    private static final String FILE_CSS_DEFINITION = "doc/doc-style.css";
    private static final String FILE_HIBERNATE_IMAGE = "doc/hibernate_logo.gif";
    private static final String FILE_INDEX = "doc/index.html";
    private static final String FILE_HEADER = "doc/header.html";
    private static final String VM_TABLES_INDEX = "doc/tables/index.vm";
    private static final String VM_TABLES_SUMMARY = "doc/tables/summary.vm";
    private static final String VM_TABLES_TABLE_LIST = "doc/tables/table-list.vm";
    private static final String VM_TABLES_SCHEMA_LIST = "doc/tables/schema-list.vm";
    private static final String VM_TABLES_SCHEMA_SUMMARY = "doc/tables/schema-summary.vm";
    private static final String VM_TABLES_TABLE = "doc/tables/table.vm";
    private StringWriter tempWriter;
    private DocHelper docHelper;
    private DocFileManager docFileManager;

    public DocExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public DocExporter() {
    }

    public void doStart() throws ExporterException {
        this.generateCommmonAndAssets();
        this.generateTablesIndex();
        this.generateTablesSummary();
        this.generateTablesDetails();
        this.generateTablesAllSchemasList();
        this.generateTablesAllTablesList();
        this.generateTablesSchemaTableList();
        this.generateTablesSchemaDetailedInfo();
    }

    protected void setupContext() {
        super.setupContext();
        this.docHelper = new DocHelper(this.getConfiguration());
        this.docFileManager = new DocFileManager(this.docHelper, this.getOutputDirectory());
        this.getTemplateHelper().putInContext("dochelper", this.docHelper);
        this.getTemplateHelper().putInContext("docFileManager", this.docFileManager);
    }

    public void generateCommmonAndAssets() {
        try {
            DocFile cssStylesDocFile = this.docFileManager.getCssStylesDocFile();
            DocFileManager.copy(FILE_CSS_DEFINITION, cssStylesDocFile.getFile());
            DocFile hibernateLogoDocFile = this.docFileManager.getHibernateImageDocFile();
            DocFileManager.copy(FILE_HIBERNATE_IMAGE, hibernateLogoDocFile.getFile());
            DocFile mainIndexDocFile = this.docFileManager.getMainIndexDocFile();
            DocFileManager.copy(FILE_INDEX, mainIndexDocFile.getFile());
            DocFile headerFile = this.docFileManager.getHeaderDocFile();
            DocFileManager.copy(FILE_HEADER, headerFile.getFile());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while copying files.", ioe);
        }
    }

    public void generateTablesIndex() {
        DocFile docFile = this.docFileManager.getTableIndexDocFile();
        File file = docFile.getFile();
        HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, VM_TABLES_INDEX, file);
    }

    public void generateTablesSummary() {
        DocFile docFile = this.docFileManager.getTableSummaryDocFile();
        File file = this.docFileManager.getTableSummaryDocFile().getFile();
        HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
        parameters.put("docFile", docFile);
        this.processTemplate(parameters, VM_TABLES_SUMMARY, file);
    }

    public void generateTablesDetails() {
        Iterator tables = this.getConfiguration().getTableMappings();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            DocFile docFile = this.docFileManager.getTableDocFile(table);
            File file = docFile.getFile();
            HashMap<String, DocFile> parameters = new HashMap<String, DocFile>();
            parameters.put("docFile", docFile);
            parameters.put("table", (DocFile)table);
            this.processTemplate(parameters, VM_TABLES_TABLE, file);
        }
    }

    public void generateTablesAllSchemasList() {
        DocFile docFile = this.docFileManager.getAllSchemasDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "Schema List");
        parameters.put("schemaList", this.docHelper.getSchemas());
        this.processTemplate(parameters, VM_TABLES_SCHEMA_LIST, file);
    }

    public void generateTablesAllTablesList() {
        DocFile docFile = this.docFileManager.getAllTablesDocFile();
        File file = docFile.getFile();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("docFile", docFile);
        parameters.put("title", "All Tables");
        parameters.put("tableList", this.docHelper.getTables());
        this.processTemplate(parameters, VM_TABLES_TABLE_LIST, file);
    }

    public void generateTablesSchemaTableList() {
        Iterator schemas = this.docHelper.getSchemas().iterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            DocFile docFile = this.docFileManager.getSchemaTableListDocFile(schemaName);
            File file = docFile.getFile();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", docFile);
            parameters.put("title", "Tables for " + schemaName);
            parameters.put("tableList", this.docHelper.getTables(schemaName));
            this.processTemplate(parameters, VM_TABLES_TABLE_LIST, file);
        }
    }

    public void generateTablesSchemaDetailedInfo() {
        Iterator schemas = this.docHelper.getSchemas().iterator();
        while (schemas.hasNext()) {
            String schemaName = (String)schemas.next();
            DocFile summaryDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("docFile", summaryDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, VM_TABLES_SCHEMA_SUMMARY, summaryDocFile.getFile());
            DocFile tableListDocFile = this.docFileManager.getSchemaSummaryDocFile(schemaName);
            parameters = new HashMap();
            parameters.put("docFile", tableListDocFile);
            parameters.put("schema", schemaName);
            this.processTemplate(parameters, VM_TABLES_SCHEMA_SUMMARY, tableListDocFile.getFile());
        }
    }

    protected void processTemplate(Map parameters, String templateName, File outputFile) {
        VelocityProducer producer = new VelocityProducer(this.getTemplateHelper(), this.getArtifactCollector());
        String filename = outputFile.toString();
        producer.produce(parameters, templateName, outputFile, templateName);
    }

    public String getName() {
        return "hbm2doc";
    }
}

