/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;
import org.hibernate.tool.hbm2x.DocExporter;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.test.TestHelper;
import org.hibernate.util.DTDEntityResolver;
import org.hibernate.util.StringHelper;
import org.xml.sax.EntityResolver;

public class GenerateFromJDBCTest
extends JDBCMetaDataBinderTestCase {
    private File outputdir;

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected String[] getCreateSQL() {
        return new String[]{"create table master ( id char not null, name varchar(20), primary key (id) )", "create table child  ( childid char not null, masterref char, primary key (childid), foreign key (masterref) references master(id) )"};
    }

    protected String[] getDropSQL() {
        return new String[]{"drop table child", "drop table master"};
    }

    protected void configure(JDBCMetaDataConfiguration cfg2configure) {
        DefaultReverseEngineeringStrategy configurableNamingStrategy = new DefaultReverseEngineeringStrategy();
        configurableNamingStrategy.setPackageName("org.reveng");
        cfg2configure.setReverseEngineeringStrategy(configurableNamingStrategy);
    }

    public void testGenerateJava() {
        this.outputdir = new File("reverseoutput");
        this.outputdir.mkdirs();
        POJOExporter exporter = new POJOExporter(this.cfg, this.outputdir);
        exporter.start();
        exporter = new POJOExporter(this.cfg, this.outputdir);
        exporter.setEjb3(true);
        exporter.start();
        TestHelper.deleteDir(this.outputdir);
    }

    public void testGenerateMappings() {
        this.outputdir = new File("reverseoutput");
        this.outputdir.mkdirs();
        this.cfg.buildMappings();
        HibernateMappingExporter exporter = new HibernateMappingExporter(this.cfg, this.outputdir);
        exporter.start();
        Configuration derived = new Configuration();
        derived.addFile(new File(this.outputdir, "org/reveng/Child.hbm.xml"));
        derived.addFile(new File(this.outputdir, "org/reveng/Master.hbm.xml"));
        derived.buildMappings();
        GenerateFromJDBCTest.assertNotNull((Object)derived.getClassMapping("org.reveng.Child"));
        GenerateFromJDBCTest.assertNotNull((Object)derived.getClassMapping("org.reveng.Master"));
    }

    public void testGenerateCfgXml() throws DocumentException {
        this.outputdir = new File("reverseoutput");
        this.outputdir.mkdirs();
        HibernateConfigurationExporter exporter = new HibernateConfigurationExporter(this.cfg, this.outputdir);
        exporter.start();
        this.assertFileAndExists(new File(this.outputdir, "hibernate.cfg.xml"));
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(new File(this.outputdir, "hibernate.cfg.xml"));
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-configuration/session-factory/mapping");
        Element[] elements = xpath.selectNodes((Object)document).toArray(new Element[0]);
        GenerateFromJDBCTest.assertEquals((int)elements.length, (int)2);
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            GenerateFromJDBCTest.assertNotNull((Object)element.attributeValue("resource"));
            GenerateFromJDBCTest.assertNull((Object)element.attributeValue("class"));
        }
    }

    public void testGenerateAnnotationCfgXml() throws DocumentException {
        this.outputdir = new File("reverseoutput");
        this.outputdir.mkdirs();
        HibernateConfigurationExporter exporter = new HibernateConfigurationExporter(this.cfg, this.outputdir);
        exporter.setEjb3(true);
        exporter.start();
        this.assertFileAndExists(new File(this.outputdir, "hibernate.cfg.xml"));
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(new File(this.outputdir, "hibernate.cfg.xml"));
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-configuration/session-factory/mapping");
        Element[] elements = xpath.selectNodes((Object)document).toArray(new Element[0]);
        GenerateFromJDBCTest.assertEquals((String)"Expected to get one mapping", (int)elements.length, (int)2);
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            GenerateFromJDBCTest.assertNull((Object)element.attributeValue("resource"));
            GenerateFromJDBCTest.assertNotNull((Object)element.attributeValue("class"));
        }
    }

    private SAXReader getSAXReader() {
        SAXReader xmlReader = new SAXReader();
        xmlReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
        xmlReader.setValidation(true);
        return xmlReader;
    }

    public void testGenerateDoc() {
        this.outputdir = new File("docoutput");
        this.outputdir.mkdirs();
        DocExporter exporter = new DocExporter(this.cfg, this.outputdir);
        exporter.start();
        TestHelper.deleteDir(this.outputdir);
    }

    public void testPackageNames() {
        Iterator iter = this.cfg.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass element = (PersistentClass)iter.next();
            GenerateFromJDBCTest.assertEquals((String)"org.reveng", (String)StringHelper.qualifier((String)element.getClassName()));
        }
    }
}

