/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.GenericExporter;

public class GenericExporterTest
extends NonReflectiveTestCase {
    public GenericExporterTest(String name) {
        super(name, "genericexport");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSingleFileGeneration() {
        GenericExporter ge = new GenericExporter();
        ge.setConfiguration(GenericExporterTest.getCfg());
        ge.setOutputDirectory(this.getOutputDir());
        ge.setTemplateName("templates/pojo/generic-test.vm");
        ge.setFilePattern("generictest.txt");
        ge.start();
        this.assertFileAndExists(new File(this.getOutputDir(), "artifacts.txt"));
        GenericExporterTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "artifacts.txt")));
    }

    public void testClassFileGeneration() {
        GenericExporter ge = new GenericExporter();
        ge.setConfiguration(GenericExporterTest.getCfg());
        ge.setOutputDirectory(this.getOutputDir());
        ge.setTemplateName("templates/pojo/generic-class.vm");
        ge.setFilePattern("generic{class-name}.txt");
        ge.start();
        this.assertFileAndExists(new File(this.getOutputDir(), "genericAuthor.txt"));
        this.assertFileAndExists(new File(this.getOutputDir(), "genericArticle.txt"));
    }

    public void testPackageFileGeneration() {
        GenericExporter ge = new GenericExporter();
        ge.setConfiguration(GenericExporterTest.getCfg());
        ge.setOutputDirectory(this.getOutputDir());
        ge.setTemplateName("templates/pojo/generic-class.vm");
        ge.setFilePattern("{package-name}/generic{class-name}.txt");
        ge.start();
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/genericAuthor.txt"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/genericArticle.txt"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/genericArticle.txt"));
        this.assertFileAndExists(new File(this.getOutputDir(), "genericUniversalAddress.txt"));
        this.assertFileAndExists(new File(this.getOutputDir(), "genericHelloUniverse.txt"));
    }

    public void testPropertySet() throws FileNotFoundException, IOException {
        GenericExporter ge = new GenericExporter();
        ge.setConfiguration(GenericExporterTest.getCfg());
        ge.setOutputDirectory(this.getOutputDir());
        Properties p = new Properties();
        p.setProperty("proptest", "A value");
        p.setProperty("hibernatetool.booleanProperty", "true");
        p.setProperty("hibernatetool.myTool.toolclass", "org.hibernate.tool.hbm2x.Cfg2JavaTool");
        ge.setProperties(p);
        ge.setTemplateName("templates/pojo/generic-class.vm");
        ge.setFilePattern("{package-name}/generic{class-name}.txt");
        ge.start();
        Properties generated = new Properties();
        generated.load(new FileInputStream(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/genericArticle.txt")));
        GenericExporterTest.assertEquals((String)generated.getProperty("booleanProperty"), (String)"true");
        GenericExporterTest.assertEquals((String)generated.getProperty("hibernatetool.booleanProperty"), (String)"true");
        GenericExporterTest.assertNull((Object)generated.getProperty("booleanWasTrue"));
        GenericExporterTest.assertEquals((String)generated.getProperty("myTool.value"), (String)"value");
    }

    public void testGenericClassExporter() {
        GenericExporter ge = new GenericExporter();
        ge.setConfiguration(GenericExporterTest.getCfg());
        ge.setOutputDirectory(this.getOutputDir());
        ge.setProperties(new Properties());
        ge.setExporterClassName("org.hibernate.tool.hbm2x.POJOExporter");
        ge.start();
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Author.hbm.xml", "Article.hbm.xml", "HelloWorld.hbm.xml"};
    }
}

