/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;

public class Hbm2CfgTest
extends NonReflectiveTestCase {
    public Hbm2CfgTest(String name) {
        super(name, "cfg2cfgxmloutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        HibernateConfigurationExporter cfgexporter = new HibernateConfigurationExporter(Hbm2CfgTest.getCfg(), this.getOutputDir());
        cfgexporter.start();
    }

    public void testFileExistence() {
        this.assertFileAndExists(new File(this.getOutputDir(), "hibernate.cfg.xml"));
    }

    public void testNoVelocityLeftOvers() {
        Hbm2CfgTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "hibernate.cfg.xml")));
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Customer.hbm.xml", "Order.hbm.xml", "LineItem.hbm.xml", "Product.hbm.xml", "HelloWorld.hbm.xml"};
    }
}

