/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.ArrayList;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.DAOExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.test.TestHelper;

public class Hbm2DaoTest
extends NonReflectiveTestCase {
    public Hbm2DaoTest(String name) {
        super(name, "hbm2daooutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        POJOExporter javaExporter = new POJOExporter(Hbm2DaoTest.getCfg(), this.getOutputDir());
        DAOExporter exporter = new DAOExporter(Hbm2DaoTest.getCfg(), this.getOutputDir());
        exporter.setEjb3(false);
        exporter.setJdk5(true);
        exporter.start();
        javaExporter.start();
    }

    public void testFileExistence() {
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/ArticleHome.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/AuthorHome.java"));
    }

    public void testCompilable() {
        File file = new File("compilable");
        file.mkdir();
        ArrayList list = new ArrayList();
        TestHelper.compile(this.getOutputDir(), file, TestHelper.visitAllFiles(this.getOutputDir(), list), "1.5", "");
        TestHelper.deleteDir(file);
    }

    public void testNoVelocityLeftOvers() {
        Hbm2DaoTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/ArticleHome.java")));
        Hbm2DaoTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/AuthorHome.java")));
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Article.hbm.xml", "Author.hbm.xml"};
    }
}

