/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.HibernateUberspect;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.test.TestHelper;

public class Hbm2JavaConstructorTest
extends NonReflectiveTestCase {
    private ArtifactCollector artifactCollector;

    public Hbm2JavaConstructorTest(String name) {
        super(name, "hbm2javaoutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        POJOExporter exporter = new POJOExporter(Hbm2JavaConstructorTest.getCfg(), this.getOutputDir());
        this.artifactCollector = new ArtifactCollector();
        exporter.setArtifactCollector(this.artifactCollector);
        exporter.start();
    }

    public void testVelocityErrors() {
        Hbm2JavaConstructorTest.assertEquals((String)("Method not found errors during template processing:\n " + HibernateUberspect.getMethodErrors()), (int)0, (int)HibernateUberspect.getMethodNotFoundCount());
    }

    public void testCompilable() {
        File file = new File("compilable");
        file.mkdir();
        ArrayList<String> list = new ArrayList<String>();
        list.add(new File("src/testoutputdependent/ConstructorUsage.java").getAbsolutePath());
        TestHelper.compile(this.getOutputDir(), file, TestHelper.visitAllFiles(this.getOutputDir(), list));
        TestHelper.deleteDir(file);
    }

    public void testNoVelocityLeftOvers() {
        Hbm2JavaConstructorTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "Company.java")));
        Hbm2JavaConstructorTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "BigCompany.java")));
        Hbm2JavaConstructorTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "EntityAddress.java")));
    }

    public void testEntityConstructorLogic() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        POJOClass company = c2j.getPOJOClass(Hbm2JavaConstructorTest.getCfg().getClassMapping("Company"));
        List all = company.getPropertyClosureForFullConstructor();
        this.assertNoDuplicates(all);
        Hbm2JavaConstructorTest.assertEquals((int)3, (int)all.size());
        List superCons = company.getPropertyClosureForSuperclassFullConstructor();
        Hbm2JavaConstructorTest.assertEquals((String)"company is a base class, should not have superclass cons", (int)0, (int)superCons.size());
        List subCons = company.getPropertiesForFullConstructor();
        this.assertNoDuplicates(subCons);
        Hbm2JavaConstructorTest.assertEquals((int)3, (int)subCons.size());
        this.assertNoOverlap(superCons, subCons);
        POJOClass bigCompany = c2j.getPOJOClass(Hbm2JavaConstructorTest.getCfg().getClassMapping("BigCompany"));
        List bigsuperCons = bigCompany.getPropertyClosureForSuperclassFullConstructor();
        this.assertNoDuplicates(bigsuperCons);
        List bigsubCons = bigCompany.getPropertiesForFullConstructor();
        Hbm2JavaConstructorTest.assertEquals((int)1, (int)bigsubCons.size());
        this.assertNoOverlap(bigsuperCons, bigsubCons);
        List bigall = bigCompany.getPropertyClosureForFullConstructor();
        this.assertNoDuplicates(bigall);
        Hbm2JavaConstructorTest.assertEquals((int)4, (int)bigall.size());
        PersistentClass classMapping = Hbm2JavaConstructorTest.getCfg().getClassMapping("Person");
        POJOClass person = c2j.getPOJOClass(classMapping);
        List propertiesForMinimalConstructor = person.getPropertiesForMinimalConstructor();
        Hbm2JavaConstructorTest.assertEquals((int)2, (int)propertiesForMinimalConstructor.size());
        Hbm2JavaConstructorTest.assertFalse((boolean)propertiesForMinimalConstructor.contains(classMapping.getIdentifierProperty()));
        List propertiesForFullConstructor = person.getPropertiesForFullConstructor();
        Hbm2JavaConstructorTest.assertEquals((int)2, (int)propertiesForFullConstructor.size());
        Hbm2JavaConstructorTest.assertFalse((boolean)propertiesForFullConstructor.contains(classMapping.getIdentifierProperty()));
    }

    private void assertNoDuplicates(List bigall) {
        HashSet set = new HashSet();
        set.addAll(bigall);
        Hbm2JavaConstructorTest.assertEquals((String)"list had duplicates!", (int)set.size(), (int)bigall.size());
    }

    private void assertNoOverlap(List first, List second) {
        HashSet set = new HashSet();
        set.addAll(first);
        set.addAll(second);
        Hbm2JavaConstructorTest.assertEquals((int)set.size(), (int)(first.size() + second.size()));
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Constructors.hbm.xml"};
    }
}

