/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.ArrayList;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.test.TestHelper;

public class Hbm2JavaEjb3Test
extends NonReflectiveTestCase {
    public Hbm2JavaEjb3Test(String name) {
        super(name, "hbm2javaejb3output");
    }

    protected void setUp() throws Exception {
        super.setUp();
        POJOExporter exporter = new POJOExporter(Hbm2JavaEjb3Test.getCfg(), this.getOutputDir());
        exporter.setTemplatePath(new String[0]);
        exporter.setEjb3(true);
        exporter.setJdk5(true);
        exporter.start();
    }

    public void testFileExistence() {
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/Author.java"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/Article.java"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/Train.java"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/Passenger.java"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/TransportationPK.java"));
    }

    public void testBasicComponent() {
        Hbm2JavaEjb3Test.assertEquals((String)"@Embeddable", (String)this.findFirstString("@Embeddable", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/TransportationPK.java")));
    }

    public void testCompile() {
        File file = new File("ejb3compilable");
        file.mkdir();
        ArrayList list = new ArrayList();
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("ejb3-persistence.jar");
        jars.add("hibernate-annotations.jar");
        TestHelper.compile(this.getOutputDir(), file, TestHelper.visitAllFiles(this.getOutputDir(), list), "1.5", TestHelper.buildClasspath(jars));
        TestHelper.deleteDir(file);
    }

    public void testEqualsHashCode() {
        PersistentClass classMapping = Hbm2JavaEjb3Test.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Passenger");
        POJOClass clazz = new Cfg2JavaTool().getPOJOClass(classMapping);
        Hbm2JavaEjb3Test.assertFalse((boolean)clazz.needsEqualsHashCode());
        classMapping = Hbm2JavaEjb3Test.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Article");
        clazz = new Cfg2JavaTool().getPOJOClass(classMapping);
        Hbm2JavaEjb3Test.assertTrue((boolean)clazz.needsEqualsHashCode());
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Author.hbm.xml", "Article.hbm.xml", "Train.hbm.xml", "Passenger.hbm.xml"};
    }
}

