/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.BasicPOJOClass;
import org.hibernate.tool.hbm2x.pojo.ImportContextImpl;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.test.TestHelper;

public class Hbm2JavaTest
extends NonReflectiveTestCase {
    private ArtifactCollector artifactCollector;

    public Hbm2JavaTest(String name) {
        super(name, "hbm2javaoutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        POJOExporter exporter = new POJOExporter(Hbm2JavaTest.getCfg(), this.getOutputDir());
        this.artifactCollector = new ArtifactCollector();
        exporter.setArtifactCollector(this.artifactCollector);
        exporter.start();
    }

    public void testFileExistence() {
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Customer.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/LineItem.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Order.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Train.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Passenger.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Product.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "generated/BaseHelloWorld.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "HelloUniverse.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/FatherComponent.java"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/ChildComponent.java"));
        Hbm2JavaTest.assertEquals((int)15, (int)this.artifactCollector.getFileCount("java"));
    }

    public void testCompilable() {
        File file = new File("compilable");
        file.mkdir();
        ArrayList<String> list = new ArrayList<String>();
        list.add(new File("src/testoutputdependent/HelloWorld.java").getAbsolutePath());
        TestHelper.compile(this.getOutputDir(), file, TestHelper.visitAllFiles(this.getOutputDir(), list));
        TestHelper.deleteDir(file);
    }

    public void testNoVelocityLeftOvers() {
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Customer.java")));
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/LineItem.java")));
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Order.java")));
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Product.java")));
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Address.java")));
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Customer.hbm.xml", "Order.hbm.xml", "LineItem.hbm.xml", "Product.hbm.xml", "HelloWorld.hbm.xml", "Train.hbm.xml", "Passenger.hbm.xml"};
    }

    public void testPackageName() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass classMapping = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        POJOClass pc = c2j.getPOJOClass(classMapping);
        Hbm2JavaTest.assertEquals((String)"org.hibernate.tool.hbm2x", (String)pc.getPackageName());
        Hbm2JavaTest.assertEquals((String)"package org.hibernate.tool.hbm2x;", (String)pc.getPackageDeclaration());
        Hbm2JavaTest.assertEquals((String)"did not honor generated-class", (String)"package generated;", (String)c2j.getPOJOClass(Hbm2JavaTest.getCfg().getClassMapping("HelloWorld")).getPackageDeclaration());
    }

    public void testFieldNotThere() {
        Hbm2JavaTest.assertEquals(null, (String)this.findFirstString("notgenerated", new File(this.getOutputDir(), "HelloUniverse.java")));
    }

    public void testJavaDoc() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        Hbm2JavaTest.assertEquals((String)" * test", (String)c2j.toJavaDoc("test", 0));
        Hbm2JavaTest.assertEquals((String)"   * test", (String)c2j.toJavaDoc("test", 2));
        Hbm2JavaTest.assertEquals((String)"   * test\n   * me", (String)c2j.toJavaDoc("test\nme", 2));
        PersistentClass local = Hbm2JavaTest.getCfg().getClassMapping("HelloWorld");
        POJOClass pc = c2j.getPOJOClass(local);
        Hbm2JavaTest.assertEquals((String)" * Hey there", (String)pc.getClassJavaDoc("fallback", 0));
        Hbm2JavaTest.assertEquals((String)" * Test Field Description", (String)pc.getFieldJavaDoc(local.getIdentifierProperty(), 0));
    }

    public void testExtraCode() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        Hbm2JavaTest.assertFalse((boolean)c2j.hasMetaAttribute((MetaAttributable)Hbm2JavaTest.getCfg().getClassMapping("HelloWorld"), "class-code"));
        PersistentClass classMapping = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Hbm2JavaTest.assertEquals((String)"// extra code line 1\n// extra code line 2\n{ Collator.getInstance(); }", (String)c2j.getPOJOClass(classMapping).getExtraClassCode());
    }

    public void testScope() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Hbm2JavaTest.assertEquals((String)"public strictfp", (String)c2j.getClassModifiers((MetaAttributable)pc));
        Hbm2JavaTest.assertEquals((String)"public", (String)c2j.getClassModifiers((MetaAttributable)Hbm2JavaTest.getCfg().getClassMapping("HelloWorld")));
    }

    public void testDeclarationType() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Hbm2JavaTest.assertEquals((String)"class", (String)c2j.getPOJOClass(pc).getDeclarationType());
        Hbm2JavaTest.assertEquals((String)"interface", (String)c2j.getPOJOClass(Hbm2JavaTest.getCfg().getClassMapping("HelloWorld")).getDeclarationType());
    }

    public void testTypeName() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Property property = pc.getProperty("lineItems");
        Hbm2JavaTest.assertEquals((String)"java.util.Collection", (String)c2j.getJavaTypeName(property));
    }

    public void testUseRawTypeNullability() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Product");
        Property property = pc.getProperty("numberAvailable");
        Hbm2JavaTest.assertFalse((boolean)property.getValue().isNullable());
        Hbm2JavaTest.assertEquals((String)"typename should be used when rawtypemode", (String)"int", (String)c2j.getJavaTypeName(property));
        property = pc.getProperty("minStock");
        Hbm2JavaTest.assertTrue((boolean)property.getValue().isNullable());
        Hbm2JavaTest.assertEquals((String)"typename should be used when rawtypemode", (String)"long", (String)c2j.getJavaTypeName(property));
        property = pc.getProperty("otherStock");
        Hbm2JavaTest.assertFalse((boolean)property.getValue().isNullable());
        Hbm2JavaTest.assertEquals((String)"type should still be overriden by meta attribute", (String)"java.lang.Integer", (String)c2j.getJavaTypeName(property));
        property = pc.getIdentifierProperty();
        Hbm2JavaTest.assertFalse((boolean)property.getValue().isNullable());
        Hbm2JavaTest.assertEquals((String)"wrappers should be used by default", (String)"long", (String)c2j.getJavaTypeName(property));
        pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Customer");
        Component identifier = (Component)pc.getIdentifier();
        Hbm2JavaTest.assertFalse((boolean)((Property)identifier.getPropertyIterator().next()).getValue().isNullable());
        Hbm2JavaTest.assertEquals((String)"long", (String)c2j.getJavaTypeName(property));
    }

    public void testExtendsImplements() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Hbm2JavaTest.assertEquals(null, (String)c2j.getPOJOClass(pc).getExtends());
        POJOClass entityPOJOClass = c2j.getPOJOClass(Hbm2JavaTest.getCfg().getClassMapping("HelloWorld"));
        Hbm2JavaTest.assertEquals((String)"Comparable", (String)entityPOJOClass.getExtends());
        Hbm2JavaTest.assertEquals((String)"should be interface which cannot have implements", null, (String)entityPOJOClass.getImplements());
        Hbm2JavaTest.assertEquals((String)"should be interface which cannot have implements", (String)"", (String)entityPOJOClass.getImplementsDeclaration());
        RootClass base = new RootClass();
        base.setClassName("Base");
        Subclass sub = new Subclass((PersistentClass)base);
        sub.setClassName("Sub");
        Hbm2JavaTest.assertEquals(null, (String)c2j.getPOJOClass((PersistentClass)base).getExtends());
        Hbm2JavaTest.assertEquals((String)"Base", (String)c2j.getPOJOClass((PersistentClass)sub).getExtends());
        HashMap<String, MetaAttribute> m = new HashMap<String, MetaAttribute>();
        MetaAttribute attribute = new MetaAttribute("extends");
        attribute.addValue("x");
        attribute.addValue("y");
        m.put(attribute.getName(), attribute);
        attribute = new MetaAttribute("interface");
        attribute.addValue("true");
        m.put(attribute.getName(), attribute);
        sub.setMetaAttributes(m);
        Hbm2JavaTest.assertEquals((String)"Base,x,y", (String)c2j.getPOJOClass((PersistentClass)sub).getExtends());
        m = new HashMap();
        attribute = new MetaAttribute("implements");
        attribute.addValue("intf");
        m.put(attribute.getName(), attribute);
        base.setMetaAttributes(m);
        Hbm2JavaTest.assertEquals((String)"intf,java.io.Serializable", (String)c2j.getPOJOClass((PersistentClass)base).getImplements());
    }

    public void testDeclarationName() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        PersistentClass hw = Hbm2JavaTest.getCfg().getClassMapping("HelloWorld");
        POJOClass epc = c2j.getPOJOClass(pc);
        Hbm2JavaTest.assertEquals((String)"Order", (String)epc.getDeclarationName());
        epc = c2j.getPOJOClass(hw);
        Hbm2JavaTest.assertEquals((String)"BaseHelloWorld", (String)epc.getDeclarationName());
    }

    public void testAsArguments() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        Hbm2JavaTest.assertEquals((String)"java.util.Calendar orderDate, java.math.BigDecimal total, org.hibernate.tool.hbm2x.Customer customer, java.util.Collection lineItems", (String)c2j.asParameterList(pc.getPropertyIterator()));
        Hbm2JavaTest.assertEquals((String)"orderDate, total, customer, lineItems", (String)c2j.asArgumentList(pc.getPropertyIterator()));
    }

    public void testPropertiesForFullConstructor() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("HelloWorld");
        POJOClass pjc = c2j.getPOJOClass(pc);
        List wl = pjc.getPropertiesForFullConstructor();
        Hbm2JavaTest.assertEquals((int)3, (int)wl.size());
        PersistentClass uni = Hbm2JavaTest.getCfg().getClassMapping("HelloUniverse");
        pjc = c2j.getPOJOClass(pc);
        List local = pjc.getPropertyClosureForFullConstructor();
        Hbm2JavaTest.assertEquals((int)3, (int)local.size());
        Hbm2JavaTest.assertEquals(local.get(0), wl.get(0));
    }

    public void testToString() {
        Cfg2JavaTool c2j = new Cfg2JavaTool();
        PersistentClass pc = Hbm2JavaTest.getCfg().getClassMapping("HelloWorld");
        POJOClass pjc = c2j.getPOJOClass(pc);
        Hbm2JavaTest.assertTrue((boolean)pjc.needsToString());
        Iterator iter = pjc.getToStringPropertiesIterator();
        Hbm2JavaTest.assertEquals((String)"id", (String)((Property)iter.next()).getName());
        Hbm2JavaTest.assertEquals((String)"hello", (String)((Property)iter.next()).getName());
        Hbm2JavaTest.assertFalse((boolean)iter.hasNext());
        pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Order");
        pjc = c2j.getPOJOClass(pc);
        Hbm2JavaTest.assertFalse((boolean)pjc.needsToString());
        pc = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Customer");
        Component c = (Component)pc.getProperty("addressComponent").getValue();
        POJOClass cc = c2j.getPOJOClass(c);
        Hbm2JavaTest.assertTrue((boolean)cc.needsToString());
        iter = cc.getToStringPropertiesIterator();
        Hbm2JavaTest.assertEquals((String)"city", (String)((Property)iter.next()).getName());
        Hbm2JavaTest.assertFalse((boolean)iter.hasNext());
    }

    public void testImportOfSameName() {
        ImportContextImpl ic = new ImportContextImpl("foobar");
        Hbm2JavaTest.assertEquals((String)"CascadeType", (String)ic.importType("javax.persistence.CascadeType"));
        Hbm2JavaTest.assertEquals((String)"org.hibernate.annotations.CascadeType", (String)ic.importType("org.hibernate.annotations.CascadeType"));
        Hbm2JavaTest.assertTrue((String)"The hibernate annotation should not be imported to avoid name clashes", (ic.generateImports().indexOf("hibernate") < 0 ? 1 : 0) != 0);
    }

    public void testImporter() {
        ImportContextImpl context = new ImportContextImpl("org.hibernate");
        Hbm2JavaTest.assertEquals((String)"byte", (String)context.importType("byte"));
        Hbm2JavaTest.assertEquals((String)"Session", (String)context.importType("org.hibernate.Session"));
        Hbm2JavaTest.assertEquals((String)"Long", (String)context.importType("java.lang.Long"));
        Hbm2JavaTest.assertEquals((String)"org.test.Session", (String)context.importType("org.test.Session"));
        Hbm2JavaTest.assertEquals((String)"Entity", (String)context.importType("org.test.Entity"));
        Hbm2JavaTest.assertEquals((String)"org.other.test.Entity", (String)context.importType("org.other.test.Entity"));
        Hbm2JavaTest.assertEquals((String)"Collection<org.marvel.Hulk>", (String)context.importType("java.util.Collection<org.marvel.Hulk>"));
        Hbm2JavaTest.assertEquals((String)"Map<java.lang.String, org.marvel.Hulk>", (String)context.importType("java.util.Map<java.lang.String, org.marvel.Hulk>"));
        Hbm2JavaTest.assertEquals((String)"Collection<org.marvel.Hulk>[]", (String)context.importType("java.util.Collection<org.marvel.Hulk>[]"));
        Hbm2JavaTest.assertEquals((String)"Map<java.lang.String, org.marvel.Hulk>", (String)context.importType("java.util.Map<java.lang.String, org.marvel.Hulk>"));
        String string = context.generateImports();
        Hbm2JavaTest.assertTrue((string.indexOf("import org.hibernate.Session;") < 0 ? 1 : 0) != 0);
        Hbm2JavaTest.assertTrue((string.indexOf("import org.test.Entity;") > 0 ? 1 : 0) != 0);
        Hbm2JavaTest.assertTrue((String)"Entity can only be imported once", (string.indexOf("import org.other.test.Entity;") < 0 ? 1 : 0) != 0);
        Hbm2JavaTest.assertFalse((string.indexOf("<") >= 0 ? 1 : 0) != 0);
    }

    public void testGenerics() {
        File file = new File(this.getOutputDir().getParentFile(), "genericsoutput");
        POJOExporter exporter = new POJOExporter(Hbm2JavaTest.getCfg(), file);
        this.artifactCollector = new ArtifactCollector();
        exporter.setArtifactCollector(this.artifactCollector);
        exporter.setJdk5(true);
        exporter.start();
        File cfile = new File("genericscompilable");
        cfile.mkdir();
        ArrayList<String> list = new ArrayList<String>();
        list.add(new File("src/testoutputdependent/HelloWorld.java").getAbsolutePath());
        TestHelper.compile(file, cfile, TestHelper.visitAllFiles(file, list), "1.5", "");
        TestHelper.deleteDir(cfile);
        TestHelper.deleteDir(file);
    }

    public void testCapitializaiton() {
        Hbm2JavaTest.assertEquals((String)"Mail", (String)BasicPOJOClass.beanCapitalize("Mail"));
        Hbm2JavaTest.assertEquals((String)"Mail", (String)BasicPOJOClass.beanCapitalize("mail"));
        Hbm2JavaTest.assertEquals((String)"eMail", (String)BasicPOJOClass.beanCapitalize("eMail"));
        Hbm2JavaTest.assertEquals((String)"EMail", (String)BasicPOJOClass.beanCapitalize("EMail"));
    }

    public void testUserTypes() {
        PersistentClass classMapping = Hbm2JavaTest.getCfg().getClassMapping("org.hibernate.tool.hbm2x.Customer");
        Property property = classMapping.getProperty("customDate");
        Hbm2JavaTest.assertEquals((String)"java.sql.Date", (String)new Cfg2JavaTool().getJavaTypeName(property));
    }
}

