/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.ConfigurationVisitor;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;

public class HibernateMappingExporter
extends AbstractExporter
implements ConfigurationVisitor {
    protected HibernateMappingGlobalSettings globalSettings = new HibernateMappingGlobalSettings();
    private Writer writer;
    private File file;

    public HibernateMappingExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public HibernateMappingExporter() {
    }

    public void endComponent(Component componenet) throws ExporterException {
    }

    public void endMapping(Configuration cfg) {
    }

    public boolean startMapping(Configuration cfg) {
        return true;
    }

    public boolean startPersistentClass(PersistentClass clazz) {
        try {
            this.getTemplateHelper().putInContext("clazz", clazz);
            this.file = this.getFileForClassName(this.getOutputDirectory(), clazz.getEntityName(), ".hbm.xml");
            this.getTemplateHelper().ensureExistence(this.file);
            if (this.writer != null) {
                throw new IllegalStateException("Writer must be null when starting a new persistent class!");
            }
            this.writer = new BufferedWriter(new FileWriter(this.file));
            this.getTemplateHelper().processTemplate("hbm/hibernate-mapping.hbm.vm", this.writer);
            this.getTemplateHelper().processTemplate("hbm/persistentclass.hbm.vm", this.writer);
        }
        catch (IOException e) {
            throw new ExporterException("Error while starting on " + clazz, e);
        }
        return true;
    }

    public void endPersistentClass(PersistentClass clazz) throws ExporterException {
        try {
            this.writer.write("</" + this.getCfg2HbmTool().getTag(clazz) + ">\n");
            this.getTemplateHelper().removeFromContext("clazz", clazz);
            this.writer.write("</hibernate-mapping>");
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            XMLPrettyPrinter.prettyPrintFile(XMLPrettyPrinter.getDefaultTidy(), this.file, this.file);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template", e);
        }
    }

    public void startIdentifierProperty(Property identifierProperty) {
        this.getTemplateHelper().putInContext("property", identifierProperty);
        this.getTemplateHelper().processTemplate("hbm/id.hbm.vm", this.writer);
    }

    public void endIdentifierProperty(Property identifierProperty) {
        this.getTemplateHelper().removeFromContext("property", identifierProperty);
    }

    public void startEmbeddedIdentifier(Component identifierProperty) {
        this.getTemplateHelper().putInContext("embeddedid", identifierProperty);
        this.getTemplateHelper().processTemplate("hbm/id.hbm.vm", this.writer);
    }

    public void endEmbeddedIdentifier(Component identifierProperty) {
        this.getTemplateHelper().removeFromContext("embeddedid", identifierProperty);
    }

    public boolean startProperty(Property prop) {
        this.getTemplateHelper().putInContext("property", prop);
        String tag = this.getCfg2HbmTool().getTag(prop);
        this.getTemplateHelper().processTemplate("hbm/" + tag + ".hbm.vm", this.writer);
        this.getTemplateHelper().removeFromContext("property", prop);
        return false;
    }

    public void endProperty(Property prop) {
    }

    public boolean startComponent(Component component) throws ExporterException {
        return false;
    }

    public boolean startGeneralConfiguration(Configuration clazz) throws ExporterException {
        String baseLocPath = this.globalSettings != null ? (this.globalSettings.getDefaultPackage() != null ? this.globalSettings.getDefaultPackage() + "." : "") : "";
        try {
            File generalFile = this.getFileForClassName(this.getOutputDirectory(), baseLocPath + "GeneralHbmSettings", ".hbm.xml");
            if (this.writer != null) {
                throw new IllegalStateException("Writer must be null when starting a new hbm output stream!");
            }
            this.writer = new BufferedWriter(new FileWriter(generalFile));
            this.getTemplateHelper().processTemplate("hbm/generalhbm.hbm.vm", this.writer);
        }
        catch (IOException e) {
            throw new ExporterException("Error while starting on " + clazz, e);
        }
        return true;
    }

    public void endGeneralConfiguration(Configuration cfg) throws ExporterException {
        try {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template", e);
        }
    }

    public void finish() throws ExporterException {
    }

    public void setGlobalSettings(HibernateMappingGlobalSettings hgs) {
        this.globalSettings = hgs;
    }

    public void doStart() {
        ConfigurationNavigator navigator = new ConfigurationNavigator();
        navigator.export(this.getConfiguration(), this);
    }

    protected void setupContext() {
        super.setupContext();
        this.getTemplateHelper().putInContext("hmgs", this.globalSettings);
    }

    public String getName() {
        return "cfg2hbm";
    }
}

