/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;

public class OtherCfg2HbmTest
extends NonReflectiveTestCase {
    public OtherCfg2HbmTest(String name) {
        super(name, "hbm2xoutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(OtherCfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.start();
    }

    public void testFileExistence() {
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Customer.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/LineItem.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Order.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Product.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir(), "HelloWorld.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir(), "HelloUniverse.hbm.xml"));
    }

    public void testReadable() {
        Configuration cfg = new Configuration();
        cfg.addFile(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Customer.hbm.xml"));
        cfg.addFile(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/LineItem.hbm.xml"));
        cfg.addFile(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Order.hbm.xml"));
        cfg.addFile(new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Product.hbm.xml"));
        cfg.buildMappings();
    }

    public void testNoVelocityLeftOvers() {
        OtherCfg2HbmTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Customer.hbm.xml")));
        OtherCfg2HbmTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/LineItem.hbm.xml")));
        OtherCfg2HbmTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Order.hbm.xml")));
        OtherCfg2HbmTest.assertEquals(null, (String)this.findFirstString("$", new File(this.getOutputDir(), "org/hibernate/tool/hbm2x/Product.hbm.xml")));
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/";
    }

    protected String[] getMappings() {
        return new String[]{"Customer.hbm.xml", "Order.hbm.xml", "LineItem.hbm.xml", "Product.hbm.xml", "HelloWorld.hbm.xml"};
    }
}

