/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.GenericExporter;

public class POJOExporter
extends GenericExporter {
    private static final String POJO_JAVACLASS_VM = "Pojo";
    private static final Log log = LogFactory.getLog((Class)POJOExporter.class);
    private boolean ejb3;
    private boolean jdk5;

    public POJOExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
        this.init();
    }

    protected void init() {
        this.setTemplateName(POJO_JAVACLASS_VM);
        this.setFilePattern("{package-name}/{class-name}.java");
    }

    public POJOExporter() {
        this.init();
    }

    protected void setupContext() {
        this.getProperties().put("ejb3", "" + this.useEjb3());
        this.getProperties().put("jdk5", "" + this.useJdk5());
        super.setupContext();
    }

    public boolean useEjb3() {
        return this.ejb3;
    }

    public void setEjb3(boolean ejb3) {
        this.ejb3 = ejb3;
    }

    public boolean useJdk5() {
        return this.jdk5;
    }

    public void setJdk5(boolean jdk5) {
        this.jdk5 = jdk5;
    }

    public String getName() {
        return "hbm2java";
    }

    protected String getTemplatePrefix() {
        return "pojo/";
    }
}

