/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;

public class VelocityProducer {
    private static final Log log = LogFactory.getLog((Class)VelocityProducer.class);
    private final TemplateHelper th;
    private ArtifactCollector ac;

    public VelocityProducer(TemplateHelper th, ArtifactCollector ac) {
        this.th = th;
        this.ac = ac;
    }

    void produce(Map additionalContext, String templateName, File destination, String identifier, String fileType) {
        String tempResult = this.firstPass(additionalContext, templateName);
        this.secondPass(additionalContext, destination, identifier, fileType, tempResult);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void secondPass(Map additionalContext, File destination, String identifier, String fileType, String tempResult) {
        if (tempResult.trim().length() == 0) {
            log.warn((Object)("Generated output is empty. Skipped creation for file " + destination));
            return;
        }
        OutputStreamWriter fileWriter = null;
        Map spctx = this.getContextForSecondPass(additionalContext);
        this.putInContext(this.th, spctx);
        this.th.ensureExistence(destination);
        this.ac.addFile(destination, fileType);
        log.info((Object)("Writing " + identifier + " to " + destination.getAbsolutePath()));
        fileWriter = new FileWriter(destination);
        this.th.processString(tempResult, fileWriter);
        this.removeFromContext(this.th, spctx);
        Object var9_9 = null;
        if (fileWriter == null) return;
        try {
            fileWriter.flush();
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            log.warn((Object)("Exception while flushing/closing " + destination), (Throwable)e);
        }
        return;
        {
            catch (Exception e) {
                throw new ExporterException("Error while processing template the second time", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.flush();
                fileWriter.close();
                throw throwable;
            }
            catch (IOException e) {
                log.warn((Object)("Exception while flushing/closing " + destination), (Throwable)e);
            }
            throw throwable;
        }
    }

    private String firstPass(Map additionalContext, String templateName) {
        Map contextForFirstPass = this.getContextForFirstPass(additionalContext);
        this.putInContext(this.th, contextForFirstPass);
        StringWriter tempWriter = new StringWriter();
        BufferedWriter bw = new BufferedWriter(tempWriter);
        this.th.processTemplate(templateName, bw);
        this.removeFromContext(this.th, contextForFirstPass);
        try {
            bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while flushing to string", e);
        }
        return tempWriter.toString();
    }

    private void removeFromContext(TemplateHelper th, Map context) {
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            th.removeFromContext((String)element.getKey(), element.getValue());
        }
    }

    private void putInContext(TemplateHelper th, Map context) {
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            th.putInContext((String)element.getKey(), element.getValue());
        }
    }

    protected Map getContextForSecondPass(Map additionalContext) {
        return additionalContext;
    }

    protected Map getContextForFirstPass(Map additionalContext) {
        return additionalContext;
    }

    public void produce(Map additionalContext, String templateName, File outputFile, String identifier) {
        String filename = outputFile.getName();
        filename = filename.substring(filename.indexOf(46) + 1);
        this.produce(additionalContext, templateName, outputFile, identifier, filename);
    }
}

