/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.dom4j.DocumentException;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;
import org.xml.sax.SAXException;

public class XMLPrettyPrinterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBasics() throws IOException, DocumentException, SAXException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrettyPrinter.prettyPrint(new ByteArrayInputStream("<basic attrib='1'></basic>".getBytes()), byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        XMLPrettyPrinterTest.assertEquals((String)"<basic attrib='1'></basic>\r\n", (String)string);
    }

    public void testDeclarationWithoutValidation() throws IOException, DocumentException, SAXException {
        String input = "<hibernate-mapping defaultx-lazy=\"false\"/>";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLPrettyPrinter.prettyPrint(new ByteArrayInputStream(input.getBytes()), byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        XMLPrettyPrinterTest.assertEquals((String)"<hibernate-mapping defaultx-lazy=\"false\" />\r\n\r\n", (String)string);
    }
}

