/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.hbm2hbmxml;

import java.io.File;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.NonReflectiveTestCase;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.HibernateMappingGlobalSettings;
import org.hibernate.util.DTDEntityResolver;
import org.xml.sax.EntityResolver;

public class Cfg2HbmTest
extends NonReflectiveTestCase {
    public Cfg2HbmTest(String name) {
        super(name, "cfg2hbmoutput");
    }

    protected void setUp() throws Exception {
        super.setUp();
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(Cfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.start();
    }

    public void testAllFilesExistence() {
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml"));
        Cfg2HbmTest.assertFalse((boolean)new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/cfg2hbm/GeneralHbmSettings.hbm.xml").exists());
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/Basic.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml"));
        this.assertFileAndExists(new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicCompositeId.hbm.xml"));
    }

    public void testGlobalSettingsGeneratedDatabase() throws Exception {
        HibernateMappingGlobalSettings hgs = new HibernateMappingGlobalSettings();
        hgs.setDefaultPackage("org.hibernate.tool.hbm2x.hbm2hbmxml");
        hgs.setSchemaName("myschema");
        hgs.setCatalogName("mycatalog");
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(Cfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.setGlobalSettings(hgs);
        hbmexporter.start();
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        Element root = document.getRootElement();
        Cfg2HbmTest.assertEquals((String)"Unexpected number of hibernate-mapping elements ", (int)7, (int)root.attributeCount());
        Cfg2HbmTest.assertEquals((String)"Unexpected package name", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml", (String)root.attribute("package").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected schema name", (String)"myschema", (String)root.attribute("schema").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected mycatalog name", (String)"mycatalog", (String)root.attribute("catalog").getStringValue());
    }

    public void testGlobalSettingsGeneratedAccessAndCascadeNonDefault() throws Exception {
        HibernateMappingGlobalSettings hgs = new HibernateMappingGlobalSettings();
        hgs.setDefaultPackage("org.hibernate.tool.hbm2x.hbm2hbmxml");
        hgs.setDefaultAccess("field");
        hgs.setDefaultCascade("save-update");
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(Cfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.setGlobalSettings(hgs);
        hbmexporter.start();
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        Element root = document.getRootElement();
        Cfg2HbmTest.assertEquals((String)"Unexpected number of hibernate-mapping elements ", (int)5, (int)root.attributeCount());
        Cfg2HbmTest.assertEquals((String)"Unexpected package name", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml", (String)root.attribute("package").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected access setting", (String)"field", (String)root.attribute("default-access").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected cascade setting", (String)"save-update", (String)root.attribute("default-cascade").getStringValue());
    }

    public void testGlobalSettingsGeneratedAccessAndCascadeDefault() throws Exception {
        HibernateMappingGlobalSettings hgs = new HibernateMappingGlobalSettings();
        hgs.setDefaultPackage("org.hibernate.tool.hbm2x.hbm2hbmxml");
        hgs.setDefaultAccess("property");
        hgs.setDefaultCascade("none");
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(Cfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.setGlobalSettings(hgs);
        hbmexporter.start();
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        Element root = document.getRootElement();
        Cfg2HbmTest.assertEquals((String)"Unexpected number of hibernate-mapping elements ", (int)5, (int)root.attributeCount());
        Cfg2HbmTest.assertEquals((String)"Unexpected package name", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml", (String)root.attribute("package").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected access setting", (String)"property", (String)root.attribute("default-access").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected cascade setting", (String)"none", (String)root.attribute("default-cascade").getStringValue());
    }

    public void testGlobalSettingsLasyAndAutoImportNonDefault() throws Exception {
        HibernateMappingGlobalSettings hgs = new HibernateMappingGlobalSettings();
        hgs.setDefaultPackage("org.hibernate.tool.hbm2x.hbm2hbmxml");
        hgs.setDefaultLazy(false);
        hgs.setAutoImport(false);
        HibernateMappingExporter hbmexporter = new HibernateMappingExporter(Cfg2HbmTest.getCfg(), this.getOutputDir());
        hbmexporter.setGlobalSettings(hgs);
        hbmexporter.start();
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        Element root = document.getRootElement();
        Cfg2HbmTest.assertEquals((String)"Unexpected number of hibernate-mapping elements ", (int)5, (int)root.attributeCount());
        Cfg2HbmTest.assertEquals((String)"Unexpected package name", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml", (String)root.attribute("package").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected access setting", (String)"false", (String)root.attribute("default-lazy").getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected cascade setting", (String)"false", (String)root.attribute("auto-import").getStringValue());
    }

    public void testIdGeneratorHasNotArgumentParameters() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/BasicGlobals.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/class/id/generator");
        List list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertTrue((String)"Expected to get one generator element", (list.size() == 1 ? 1 : 0) != 0);
        Attribute genAtt = ((Element)list.get(0)).attribute("class");
        Cfg2HbmTest.assertEquals((String)"Unexpected generator class name", (String)"assigned", (String)genAtt.getStringValue());
        xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/class/id/generator/param");
        list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertTrue((String)"Expected to get no generator param elements", (list.size() == 0 ? 1 : 0) != 0);
    }

    public void testIdGeneratorHasArgumentParameters() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/org/hibernate/tool/hbm2x/hbm2hbmxml/Basic.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/class/id/generator");
        List list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertTrue((String)"Expected to get one generator element", (list.size() == 1 ? 1 : 0) != 0);
        Attribute genAtt = ((Element)list.get(0)).attribute("class");
        Cfg2HbmTest.assertEquals((String)"Unexpected generator class name", (String)"org.hibernate.id.TableHiLoGenerator", (String)genAtt.getStringValue());
        xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/class/id/generator/param");
        list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertEquals((String)"Expected to get correct number of generator param elements", (int)2, (int)list.size());
        Attribute paramTableAtt = ((Element)list.get(0)).attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected generator param name", (String)"table", (String)paramTableAtt.getStringValue());
        Attribute paramColumnAtt = ((Element)list.get(1)).attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected generator param name", (String)"column", (String)paramColumnAtt.getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected param value for table", (String)"uni_table", (String)((Element)list.get(0)).getStringValue());
        Cfg2HbmTest.assertEquals((String)"Unexpected param value for column", (String)"next_hi_value", (String)((Element)list.get(1)).getStringValue());
    }

    public void testGeneralHbmSettingsQuery() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/query");
        List list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertEquals((String)"Expected to get correct number of query elements", (int)2, (int)list.size());
        Attribute genAtt = ((Element)list.get(0)).attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_query_1", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(0)).attribute("flush-mode");
        Cfg2HbmTest.assertNull((String)"Expected flush-mode value to be null", (Object)genAtt);
        genAtt = ((Element)list.get(1)).attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_query_2", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(1)).attribute("flush-mode");
        Cfg2HbmTest.assertEquals((String)"Unexpected flush-mode value", (String)"auto", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(1)).attribute("cacheable");
        Cfg2HbmTest.assertEquals((String)"Unexpected cacheable value", (String)"true", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(1)).attribute("cache-region");
        Cfg2HbmTest.assertEquals((String)"Unexpected cache-region value", (String)"myregion", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(1)).attribute("fetch-size");
        Cfg2HbmTest.assertEquals((String)"Unexpected fetch-size value", (String)"10", (String)genAtt.getStringValue());
        genAtt = ((Element)list.get(1)).attribute("timeout");
        Cfg2HbmTest.assertEquals((String)"Unexpected timeout value", (String)"1000", (String)genAtt.getStringValue());
    }

    public void testGeneralHbmSettingsSQLQueryBasic() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query");
        List list = xpath.selectNodes((Object)document);
        Cfg2HbmTest.assertEquals((String)"Expected to get correct number of query elements", (int)6, (int)list.size());
        xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_1\"]");
        list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_1' not to be null", (Object)node);
        Attribute genAtt = node.attribute("flush-mode");
        Cfg2HbmTest.assertNull((String)"Expected flush-mode value to be null", (Object)genAtt);
    }

    public void testGeneralHbmSettingsSQLQueryAllAttributes() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_2\"]");
        List list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_2' not to be null", (Object)node);
        Attribute genAtt = node.attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_sqlquery_2", (String)genAtt.getStringValue());
        genAtt = node.attribute("flush-mode");
        Cfg2HbmTest.assertEquals((String)"Unexpected flush-mode value", (String)"auto", (String)genAtt.getStringValue());
        genAtt = node.attribute("cacheable");
        Cfg2HbmTest.assertEquals((String)"Unexpected cacheable value", (String)"true", (String)genAtt.getStringValue());
        genAtt = node.attribute("cache-region");
        Cfg2HbmTest.assertEquals((String)"Unexpected cache-region value", (String)"myregion", (String)genAtt.getStringValue());
        genAtt = node.attribute("fetch-size");
        Cfg2HbmTest.assertEquals((String)"Unexpected fetch-size value", (String)"10", (String)genAtt.getStringValue());
        genAtt = node.attribute("timeout");
        Cfg2HbmTest.assertEquals((String)"Unexpected timeout value", (String)"1000", (String)genAtt.getStringValue());
        Element syncTable = node.element("synchronize");
        Cfg2HbmTest.assertNull((String)"Expected synchronize element to be null", (Object)syncTable);
    }

    public void testGeneralHbmSettingsSQLQuerySynchronize() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_3\"]");
        List list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_3' not to be null", (Object)node);
        Attribute genAtt = node.attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_sqlquery_3", (String)genAtt.getStringValue());
        Element syncTable = node.element("synchronize");
        Cfg2HbmTest.assertNotNull((String)"Expected synchronize element to not be null", (Object)syncTable);
        genAtt = syncTable.attribute("table");
        Cfg2HbmTest.assertEquals((String)"Unexpected table value for synchronize element", (String)"mytable", (String)genAtt.getStringValue());
        Element returnEl = node.element("return");
        Cfg2HbmTest.assertNull((String)"Expected return element to be null", (Object)returnEl);
    }

    public void testGeneralHbmSettingsSQLQueryWithReturnRoot() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_4\"]");
        List list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_4' not to be null", (Object)node);
        Attribute genAtt = node.attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_sqlquery_4", (String)genAtt.getStringValue());
        Element returnEl = node.element("return");
        Cfg2HbmTest.assertNotNull((String)"Expected return element to not be null", (Object)returnEl);
        genAtt = returnEl.attribute("alias");
        Cfg2HbmTest.assertEquals((String)"Unexpected alias value for return element", (String)"e", (String)genAtt.getStringValue());
        genAtt = returnEl.attribute("class");
        Cfg2HbmTest.assertEquals((String)"Unexpected class value for return element", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml.elephant", (String)genAtt.getStringValue());
    }

    public void testGeneralHbmSettingsSQLQueryWithReturnRole() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_5\"]");
        List list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_5' not to be null", (Object)node);
        Attribute genAtt = node.attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_sqlquery_5", (String)genAtt.getStringValue());
        Element returnEl = node.element("return-join");
        Cfg2HbmTest.assertNotNull((String)"Expected return element to not be null", (Object)returnEl);
        genAtt = returnEl.attribute("alias");
        Cfg2HbmTest.assertEquals((String)"Unexpected alias value for return element", (String)"e", (String)genAtt.getStringValue());
        genAtt = returnEl.attribute("property");
        Cfg2HbmTest.assertEquals((String)"Unexpected property role value for return element", (String)"e.age", (String)genAtt.getStringValue());
    }

    public void testGeneralHbmSettingsSQLQueryWithReturnCollection() throws Exception {
        File outputXml = new File(this.getOutputDir().getAbsolutePath() + "/GeneralHbmSettings.hbm.xml");
        this.assertFileAndExists(outputXml);
        SAXReader xmlReader = this.getSAXReader();
        Document document = xmlReader.read(outputXml);
        XPath xpath = DocumentHelper.createXPath((String)"//hibernate-mapping/sql-query[@name=\"test_sqlquery_6\"]");
        List list = xpath.selectNodes((Object)document);
        Element node = (Element)list.get(0);
        Cfg2HbmTest.assertNotNull((String)"Expected sql-query named 'test_sqlquery_6' not to be null", (Object)node);
        Attribute genAtt = node.attribute("name");
        Cfg2HbmTest.assertEquals((String)"Unexpected query name", (String)"test_sqlquery_6", (String)genAtt.getStringValue());
        Element returnEl = node.element("load-collection");
        Cfg2HbmTest.assertNotNull((String)"Expected return element to not be null", (Object)returnEl);
        genAtt = returnEl.attribute("alias");
        Cfg2HbmTest.assertEquals((String)"Unexpected alias value for return element", (String)"e", (String)genAtt.getStringValue());
        genAtt = returnEl.attribute("role");
        Cfg2HbmTest.assertEquals((String)"Unexpected collection role value for return element", (String)"org.hibernate.tool.hbm2x.hbm2hbmxml.elephant.age", (String)genAtt.getStringValue());
        genAtt = returnEl.attribute("lock-mode");
        Cfg2HbmTest.assertEquals((String)"Unexpected class lock-mode for return element", (String)"none", (String)genAtt.getStringValue());
    }

    public void testProperties() throws Exception {
        Cfg2HbmTool c2h = new Cfg2HbmTool();
        PersistentClass pc = Cfg2HbmTest.getCfg().getClassMapping("Basic");
    }

    private SAXReader getSAXReader() {
        SAXReader xmlReader = new SAXReader();
        xmlReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
        xmlReader.setValidation(true);
        return xmlReader;
    }

    protected String getBaseForMappings() {
        return "org/hibernate/tool/hbm2x/hbm2hbmxml/";
    }

    protected String[] getMappings() {
        return new String[]{"Basic.hbm.xml", "BasicGlobals.hbm.xml", "ClassFullAttribute.hbm.xml", "BasicCompositeId.hbm.xml"};
    }

    public static Test suite() {
        return new TestSuite(Cfg2HbmTest.class);
    }
}

