/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.seam;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class SeamExporter
extends AbstractExporter {
    public SeamExporter() {
    }

    public SeamExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    protected void exportComponent(Map additionalContext, POJOClass element) {
    }

    public String getName() {
        return "hbm2seam";
    }

    protected String getTemplatePrefix() {
        return "seam/";
    }

    public void doStart() {
        this.configureExporter("seam/build.xml.vm", "build.xml").start();
        this.configureExporter("seam/build.properties.vm", "build.properties").start();
        new File(this.getOutputDirectory(), "lib").mkdir();
        this.configureExporter("seam/seam.properties.vm", "resources/seam.properties").start();
        this.configureExporter("seam/web.xml.vm", "resources/WEB-INF/web.xml").start();
        this.configureExporter("seam/faces-config.xml.vm", "resources/WEB-INF/faces-config.xml").start();
        new File(this.getOutputDirectory(), "resources/WEB-INF/lib").mkdir();
        this.configureExporter("seam/persistence.xml.vm", "resources/META-INF/persistence.xml").start();
        this.configureExporter("seam/application.xml.vm", "resources/META-INF/application.xml").start();
        this.configureExporter("seam/jboss-app.xml.vm", "resources/META-INF/jboss-app.xml").start();
        this.configureExporter("seam/edit.jsp.vm", "resources/jsp/edit{class-name}.jsp").start();
        this.configureExporter("seam/find.jsp.vm", "resources/jsp/find{class-name}.jsp").start();
        this.configureExporter("seam/screen.css.vm", "resources/jsp/style/default/screen.css").start();
        POJOExporter exporter = new POJOExporter(this.getConfiguration(), this.getOutputDirectory());
        exporter.setProperties((Properties)this.getProperties().clone());
        exporter.setTemplatePath(this.getTemplatePaths());
        exporter.setEjb3(true);
        exporter.setJdk5(true);
        exporter.setFilePattern("src/{package-name}/{class-name}.java");
        exporter.start();
        this.configureExporter("seam/finder.java.vm", "src/{package-name}/{class-name}Finder.java").start();
        this.configureExporter("seam/finderbean.java.vm", "src/{package-name}/{class-name}FinderBean.java").start();
        this.configureExporter("seam/editor.java.vm", "src/{package-name}/{class-name}Editor.java").start();
        this.configureExporter("seam/editorbean.java.vm", "src/{package-name}/{class-name}EditorBean.java").start();
    }

    private GenericExporter configureExporter(String template, String pattern) {
        GenericExporter exporter = new GenericExporter(this.getConfiguration(), this.getOutputDirectory());
        exporter.setProperties((Properties)this.getProperties().clone());
        exporter.setTemplatePath(this.getTemplatePaths());
        exporter.setTemplateName(template);
        exporter.setFilePattern(pattern);
        return exporter;
    }
}

