/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.hibernate.util.StringHelper;
import org.xml.sax.SAXException;

public final class TestHelper {
    private TestHelper() {
    }

    public static boolean compile(File srcdir, File outputdir) {
        List files = TestHelper.visitAllFiles(srcdir, new ArrayList());
        return TestHelper.compile(srcdir, outputdir, files);
    }

    public static boolean compile(File srcdir, File outputdir, List srcFiles) {
        return TestHelper.compile(srcdir, outputdir, srcFiles, "1.4", "");
    }

    public static boolean compile(File srcdir, File outputdir, List srcFiles, String jdktarget, String classPath) {
        ArrayList<String> togglesList = new ArrayList<String>();
        togglesList.add("-" + jdktarget);
        togglesList.add("-noExit");
        togglesList.add("-warn:unusedImport,noEffectAssign,fieldHiding,localHiding,semicolon,unusedPrivate,uselessTypeCheck");
        togglesList.add("-sourcepath");
        togglesList.add(srcdir.getAbsolutePath() + File.separatorChar);
        togglesList.add("-d");
        togglesList.add(outputdir.getAbsolutePath() + File.separatorChar);
        if (StringHelper.isNotEmpty((String)classPath)) {
            togglesList.add("-classpath");
            togglesList.add(classPath);
        }
        String[] toggles = togglesList.toArray(new String[togglesList.size()]);
        String[] strings = srcFiles.toArray(new String[srcFiles.size()]);
        String[] arguments = new String[toggles.length + strings.length];
        System.arraycopy(toggles, 0, arguments, 0, toggles.length);
        System.arraycopy(strings, 0, arguments, toggles.length, strings.length);
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        Main main = new Main(new PrintWriter(out), new PrintWriter(err), false);
        main.compile(arguments);
        if (main.globalErrorsCount > 0) {
            throw new RuntimeException(out.toString() + err.toString());
        }
        if (main.globalWarningsCount > 0) {
            throw new RuntimeException(out.toString() + err.toString());
        }
        return true;
    }

    private static boolean javaCompile(String[] arguments) {
        StringWriter sw = new StringWriter();
        int result = com.sun.tools.javac.Main.compile(arguments, new PrintWriter(sw));
        if (result != 0) {
            throw new RuntimeException(sw.toString());
        }
        return true;
    }

    public static List visitAllFiles(File dir, List files, String ext) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                TestHelper.visitAllFiles(new File(dir, children[i]), files, ext);
            }
        } else if (dir.getName().endsWith(ext)) {
            files.add(dir.getAbsolutePath());
        }
        return files;
    }

    public static List visitAllFiles(File dir, List file) {
        return TestHelper.visitAllFiles(dir, file, ".java");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestHelper.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean isWellFormed(String path) {
        boolean wellFormed = false;
        try {
            TestHelper.getDocumentBuilder().parse(path);
            wellFormed = true;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wellFormed;
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            return null;
        }
        return db;
    }

    public static String buildClasspath(List jars) {
        StringBuffer classpath = new StringBuffer();
        String dir = System.getProperty("org.hibernate.tool.test.libdir", "lib" + File.separator + "testlibs");
        if (dir == null) {
            throw new IllegalStateException("System property org.hibernate.tool.test.libdir must be set to run tests that compile with a custom classpath");
        }
        File libdir = new File(dir);
        Iterator iterator = jars.iterator();
        while (iterator.hasNext()) {
            String jar = (String)iterator.next();
            File f = new File(libdir, jar);
            if (!f.exists()) {
                throw new IllegalStateException(f + " not found. Check if system property org.hibernate.tool.test.libdir is set correctly.");
            }
            classpath.append(f);
            if (!iterator.hasNext()) continue;
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    public static String findFirstString(String string, File file) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if (str.indexOf(string) < 0) continue;
                return str;
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("trouble with searching in " + file, e);
        }
        return null;
    }
}

