/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;

public class BasicTest
extends JDBCMetaDataBinderTestCase {
    protected String[] getDropSQL() {
        return new String[]{"drop table basic", "drop table somecolumnsnopk", "drop table multikeyed"};
    }

    protected String[] getCreateSQL() {
        return new String[]{"create table basic ( a int not null, name varchar(20), primary key (a)  )", "create table somecolumnsnopk ( pk varchar(25) not null, b char, c int not null, aBoolean boolean )", "create table multikeyed ( orderid varchar(10), customerid varchar(10), name varchar(10), primary key(orderid, customerid) )"};
    }

    public void testBasic() throws SQLException {
        this.assertHasNext("There should be three tables!", 3, this.cfg.getTableMappings());
        Table table = this.getTable(this.identifier("basic"));
        this.assertEqualIdentifiers("basic", table.getName());
        BasicTest.assertEquals((int)2, (int)table.getColumnSpan());
        Column basicColumn = table.getColumn(0);
        this.assertEqualIdentifiers("a", basicColumn.getName());
        PrimaryKey key = table.getPrimaryKey();
        BasicTest.assertNotNull((String)"There should be a primary key!", (Object)key);
        BasicTest.assertEquals((int)key.getColumnSpan(), (int)1);
        Column column = key.getColumn(0);
        BasicTest.assertTrue((boolean)column.isUnique());
        BasicTest.assertSame((Object)basicColumn, (Object)column);
    }

    public void testScalePrecisionLength() {
        Table table = this.getTable(this.identifier("basic"));
        Column nameCol = table.getColumn(new Column(this.identifier("name")));
        BasicTest.assertEquals((int)nameCol.getLength(), (int)20);
        BasicTest.assertEquals((int)nameCol.getPrecision(), (int)19);
        BasicTest.assertEquals((int)nameCol.getScale(), (int)2);
    }

    public void testCompositeKeys() {
        Table table = this.getTable(this.identifier("multikeyed"));
        PrimaryKey primaryKey = table.getPrimaryKey();
        BasicTest.assertEquals((int)2, (int)primaryKey.getColumnSpan());
    }

    public static Test suite() {
        return new TestSuite(BasicTest.class);
    }
}

