/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.classic.Session;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;
import org.hibernate.tool.test.TestHelper;

public class CompositeIdTest
extends JDBCMetaDataBinderTestCase {
    protected void configure(JDBCMetaDataConfiguration cfg) {
        super.configure(cfg);
    }

    protected String[] getCreateSQL() {
        return new String[]{"create table SimpleLineItem (\r\n   lineItemId varchar not null,\r\n   customerOrderIdRef varchar,\r\n   productId varchar not null,\r\n   extraId varchar not null,\r\n   quantity double,\r\n   primary key (lineItemId)\r\n)", "create table Product (\r\n   productId varchar not null,\r\n   extraId varchar not null,\r\n   description varchar not null,\r\n   price double,\r\n   numberAvailable double,\r\n   primary key (productId, extraId)\r\n)", "create table Customer (\r\n   customerId varchar not null,\r\n   name varchar not null,\r\n   address varchar not null,\r\n   primary key (customerId)\r\n)", "create table SimpleCustomerOrder (\r\n   customerOrderId varchar not null,\r\n   customerId varchar not null,\r\n   orderNumber double not null,\r\n   orderDate date not null,\r\n   primary key (customerOrderId)\r\n)", "alter table SimpleLineItem add constraint toSimpleCustomerOrder foreign key (customerOrderIdRef) references SimpleCustomerOrder", "alter table SimpleLineItem add constraint fromSimpletoProduct foreign key (productId,extraId) references Product", "alter table SimpleCustomerOrder add constraint fromSimpletoCustomer foreign key (customerId) references Customer", "create table LineItem (\r\n   customerIdRef varchar not null,\r\n   orderNumber double not null,\r\n   productId varchar not null,\r\n   extraProdId varchar not null,\r\n   quantity double,\r\n   primary key (customerIdRef, orderNumber, productId, extraProdId)\r\n)", "create table CustomerOrder (\r\n   customerId varchar not null,\r\n   orderNumber double not null,\r\n   orderDate date not null,\r\n   primary key (customerId, orderNumber)\r\n)", "alter table LineItem add constraint toCustomerOrder foreign key (customerIdRef, orderNumber) references CustomerOrder", "alter table LineItem add constraint toProduct foreign key (productId,extraProdId) references Product", "alter table CustomerOrder add constraint toCustomer foreign key (customerId) references Customer"};
    }

    protected String[] getGenDataSQL() {
        return new String[]{"insert into PRODUCT (productId, extraId, description, price, numberAvailable) values('PC', '0', 'My PC', 100.0, 23)", "insert into PRODUCT (productId, extraId, description, price, numberAvailable) values('MS', '1', 'My Mouse', 101.0, 23)", "insert into CUSTOMER (customerId, name, address) values('MAX', 'Max Rydahl Andersen', 'Neuchatel')", "insert into CUSTOMERORDER (customerId, orderNumber, orderDate) values ('MAX', 1, '11-11-2005')", "insert into LINEITEM (customerIdref, orderNumber, productId, extraProdId, quantity) values ('MAX', 1, 'PC', '0', 10)", "insert into LINEITEM (customerIdref, orderNumber, productId, extraProdId, quantity) values ('MAX', 1, 'MS', '1', 12)"};
    }

    protected String[] getDropSQL() {
        return new String[]{"alter table LineItem drop constraint toCustomerOrder", "alter table LineItem drop constraint toProduct", "alter table CustomerOrder drop constraint toCustomer", "alter table SimpleLineItem drop constraint toSimpleCustomerOrder", "alter table SimpleLineItem drop constraint fromSimpletoProduct", "alter table SimpleCustomerOrder drop constraint fromSimpletoCustomer", "drop table SimpleLineItem ", "drop table Product ", "drop table Customer ", "drop table SimpleCustomerOrder ", "drop table CustomerOrder ", "drop table LineItem "};
    }

    public void testMultiColumnForeignKeys() {
        Table table = this.getTable(this.identifier("LineItem"));
        CompositeIdTest.assertNotNull((Object)table);
        ForeignKey foreignKey = this.getForeignKey(table, this.identifier("toCustomerOrder"));
        CompositeIdTest.assertNotNull((Object)foreignKey);
        CompositeIdTest.assertEquals((String)this.toClassName(this.identifier("CustomerOrder")), (String)foreignKey.getReferencedEntityName());
        CompositeIdTest.assertEquals((String)this.identifier("LineItem"), (String)foreignKey.getTable().getName());
        CompositeIdTest.assertEquals((int)2, (int)foreignKey.getColumnSpan());
        CompositeIdTest.assertEquals((String)foreignKey.getColumn(0).getName(), (String)"CUSTOMERIDREF");
        CompositeIdTest.assertEquals((String)foreignKey.getColumn(1).getName(), (String)"ORDERNUMBER");
        Table tab = this.getTable(this.identifier("CUSTOMERORDER"));
        CompositeIdTest.assertEquals((String)tab.getPrimaryKey().getColumn(0).getName(), (String)"CUSTOMERID");
        CompositeIdTest.assertEquals((String)tab.getPrimaryKey().getColumn(1).getName(), (String)"ORDERNUMBER");
        this.cfg.buildMappings();
        PersistentClass lineMapping = this.cfg.getClassMapping(this.toClassName(this.identifier("LineItem")));
        CompositeIdTest.assertEquals((int)4, (int)lineMapping.getIdentifier().getColumnSpan());
        Iterator columnIterator = lineMapping.getIdentifier().getColumnIterator();
        CompositeIdTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"CUSTOMERIDREF");
        CompositeIdTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"ORDERNUMBER");
    }

    public void testPossibleKeyManyToOne() {
        this.cfg.buildMappings();
        PersistentClass product = this.cfg.getClassMapping(this.toClassName(this.identifier("CustomerOrder")));
        Property identifierProperty = product.getIdentifierProperty();
        CompositeIdTest.assertTrue((boolean)(identifierProperty.getValue() instanceof Component));
        Component cmpid = (Component)identifierProperty.getValue();
        CompositeIdTest.assertEquals((int)2, (int)cmpid.getPropertySpan());
        Iterator iter = cmpid.getPropertyIterator();
        Property id = (Property)iter.next();
        Property extraId = (Property)iter.next();
        this.checkKeyProperties(id, extraId);
    }

    protected void checkKeyProperties(Property id, Property extraId) {
        CompositeIdTest.assertEquals((String)this.toPropertyName("customerid"), (String)id.getName());
        CompositeIdTest.assertEquals((String)this.toPropertyName("ordernumber"), (String)extraId.getName());
        CompositeIdTest.assertFalse((boolean)(id.getValue() instanceof ManyToOne));
        CompositeIdTest.assertFalse((boolean)(extraId.getValue() instanceof ManyToOne));
    }

    public void testKeyProperty() {
        this.cfg.buildMappings();
        PersistentClass product = this.cfg.getClassMapping(this.toClassName(this.identifier("Product")));
        Property identifierProperty = product.getIdentifierProperty();
        CompositeIdTest.assertTrue((boolean)(identifierProperty.getValue() instanceof Component));
        Component cmpid = (Component)identifierProperty.getValue();
        CompositeIdTest.assertEquals((int)2, (int)cmpid.getPropertySpan());
        Iterator iter = cmpid.getPropertyIterator();
        Property id = (Property)iter.next();
        Property extraId = (Property)iter.next();
        CompositeIdTest.assertEquals((String)this.toPropertyName("productid"), (String)id.getName());
        CompositeIdTest.assertEquals((String)this.toPropertyName("extraid"), (String)extraId.getName());
        CompositeIdTest.assertFalse((boolean)(id.getValue() instanceof ManyToOne));
        CompositeIdTest.assertFalse((boolean)(extraId.getValue() instanceof ManyToOne));
    }

    public void testGeneration() throws IOException, SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        File outputdir = new File("reverseoutput");
        outputdir.mkdirs();
        this.cfg.buildMappings();
        HibernateMappingExporter exporter = new HibernateMappingExporter(this.cfg, outputdir);
        POJOExporter javaExp = new POJOExporter(this.cfg, outputdir);
        exporter.start();
        javaExp.start();
        XMLPrettyPrinter.prettyPrintDirectory(outputdir, ".hbm.xml");
        TestHelper.compile(outputdir, outputdir);
        Configuration derived = new Configuration();
        derived.addFile(new File(outputdir, "SimplecustomerOrder.hbm.xml"));
        derived.addFile(new File(outputdir, "SimpleLineItem.hbm.xml"));
        derived.addFile(new File(outputdir, "Product.hbm.xml"));
        derived.addFile(new File(outputdir, "Customer.hbm.xml"));
        derived.addFile(new File(outputdir, "LineItem.hbm.xml"));
        derived.addFile(new File(outputdir, "CustomerOrder.hbm.xml"));
        derived.buildMappings();
        URL[] urls = new URL[]{outputdir.toURL()};
        URLClassLoader ucl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(ucl);
        SessionFactory factory = derived.buildSessionFactory();
        Session session = factory.openSession();
        this.executeDDL(this.getGenDataSQL());
        session.createQuery("from Lineitem").list();
        List list = session.createQuery("from Product").list();
        CompositeIdTest.assertEquals((int)2, (int)list.size());
        list = session.createQuery(this.getCustomerOrderQuery()).list();
        CompositeIdTest.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        Class<?> productIdClass = ucl.loadClass("ProductId");
        Object object = productIdClass.newInstance();
        int hash = -1;
        try {
            hash = object.hashCode();
        }
        catch (Throwable t) {
            CompositeIdTest.fail((String)("Hashcode on new instance should not fail " + t));
        }
        CompositeIdTest.assertFalse((String)"hashcode should be different from system", (hash == System.identityHashCode(object) ? 1 : 0) != 0);
        Thread.currentThread().setContextClassLoader(ucl.getParent());
        TestHelper.deleteDir(outputdir);
    }

    protected String getCustomerOrderQuery() {
        return "select li.customerorder.id from Lineitem as li";
    }

    public static Test suite() {
        return new TestSuite(CompositeIdTest.class);
    }
}

