/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.Column;

public class DefaultReverseNamingStrategyTest
extends TestCase {
    ReverseEngineeringStrategy rns = new DefaultReverseEngineeringStrategy();

    public void testColumnKeepCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "name"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"nameIsValid", (String)this.rns.columnToPropertyName(null, "nameIsValid"));
    }

    public void testColumnUpperToLower() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "NAME"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "Name"));
    }

    public void testColumnRemoveChars() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "_Name"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "_name"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"name", (String)this.rns.columnToPropertyName(null, "_name"));
    }

    public void testColumnToCamelCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"labelForField", (String)this.rns.columnToPropertyName(null, "LABEL_FOR_FIELD"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"nameToMe", (String)this.rns.columnToPropertyName(null, "_name-To-Me"));
    }

    public void testColumnChangeCamelCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"labelForField", (String)this.rns.columnToPropertyName(null, "LabelForField"));
    }

    public void testTableKeepCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"SickPatients", (String)this.rns.tableToClassName(new TableIdentifier("SickPatients")));
    }

    public void testTableUpperToLower() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"Patients", (String)this.rns.tableToClassName(new TableIdentifier("PATIENTS")));
        DefaultReverseNamingStrategyTest.assertEquals((String)"Patients", (String)this.rns.tableToClassName(new TableIdentifier("patients")));
    }

    public void testTableRemoveChars() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"Patients", (String)this.rns.tableToClassName(new TableIdentifier("_Patients")));
        DefaultReverseNamingStrategyTest.assertEquals((String)"Patients", (String)this.rns.tableToClassName(new TableIdentifier("_patients")));
        DefaultReverseNamingStrategyTest.assertEquals((String)"Patients", (String)this.rns.tableToClassName(new TableIdentifier("_patients")));
        DefaultReverseNamingStrategyTest.assertEquals((String)"PatientInterventions", (String)this.rns.tableToClassName(new TableIdentifier("_PATIENT_INTERVENTIONS")));
    }

    public void testTableToCamelCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"SickPatients", (String)this.rns.tableToClassName(new TableIdentifier("Sick_Patients")));
        DefaultReverseNamingStrategyTest.assertEquals((String)"SickPatients", (String)this.rns.tableToClassName(new TableIdentifier("_Sick-Patients")));
    }

    public void testTableKeepCamelCase() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"SickPatients", (String)this.rns.tableToClassName(new TableIdentifier("SickPatients")));
    }

    public void testBasicForeignKeyNames() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"products", (String)this.rns.foreignKeyToCollectionName("something", new TableIdentifier("product"), null, new TableIdentifier("order"), null, true));
        DefaultReverseNamingStrategyTest.assertEquals((String)"willies", (String)this.rns.foreignKeyToCollectionName("something", new TableIdentifier("willy"), null, new TableIdentifier("order"), null, true));
        DefaultReverseNamingStrategyTest.assertEquals((String)"boxes", (String)this.rns.foreignKeyToCollectionName("something", new TableIdentifier("box"), null, new TableIdentifier("order"), null, true));
        DefaultReverseNamingStrategyTest.assertEquals((String)"order", (String)this.rns.foreignKeyToEntityName("something", new TableIdentifier("product"), null, new TableIdentifier("order"), null, true));
    }

    public void testForeignKeyNamesToPropertyNames() {
        String fkName = "something";
        TableIdentifier fromTable = new TableIdentifier("company");
        ArrayList<Column> fromColumns = new ArrayList<Column>();
        TableIdentifier toTable = new TableIdentifier("address");
        ArrayList toColumns = new ArrayList();
        DefaultReverseNamingStrategyTest.assertEquals((String)"address", (String)this.rns.foreignKeyToEntityName(fkName, fromTable, fromColumns, toTable, toColumns, true));
        DefaultReverseNamingStrategyTest.assertEquals((String)"companies", (String)this.rns.foreignKeyToCollectionName(fkName, fromTable, fromColumns, toTable, toColumns, true));
        fkName = "billing";
        fromColumns.clear();
        fromColumns.add(new Column("bill_adr"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"addressByBillAdr", (String)this.rns.foreignKeyToEntityName(fkName, fromTable, fromColumns, toTable, toColumns, false));
        DefaultReverseNamingStrategyTest.assertEquals((String)"companiesForBillAdr", (String)this.rns.foreignKeyToCollectionName(fkName, fromTable, fromColumns, toTable, toColumns, false));
        fromColumns.add(new Column("bill_adrtype"));
        DefaultReverseNamingStrategyTest.assertEquals((String)"addressByBilling", (String)this.rns.foreignKeyToEntityName(fkName, fromTable, fromColumns, toTable, toColumns, false));
        DefaultReverseNamingStrategyTest.assertEquals((String)"companiesForBilling", (String)this.rns.foreignKeyToCollectionName(fkName, fromTable, fromColumns, toTable, toColumns, false));
    }

    public void testReservedKeywordsHandling() {
        DefaultReverseNamingStrategyTest.assertEquals((String)"class_", (String)this.rns.columnToPropertyName(new TableIdentifier("blah"), "class"));
    }

    public static Test suite() {
        return new TestSuite(DefaultReverseNamingStrategyTest.class);
    }
}

