/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class ForeignKeysTest
extends JDBCMetaDataBinderTestCase {
    protected String[] getCreateSQL() {
        return new String[]{"create table master ( id char not null, name varchar(20), primary key (id) )", "create table child  ( childid character not null, masterref character, primary key (childid), foreign key (masterref) references master(id) )", "create table connection  ( conid int, name varchar(50), masterref character, childref1 character, childref2 character, primary key(conid), constraint con2master foreign key (masterref) references master(id),constraint childref1 foreign key  (childref1) references child(childid), constraint childref2 foreign key  (childref2) references child(childid) )"};
    }

    protected String[] getDropSQL() {
        return new String[]{"drop table connection", "drop table child", "drop table master"};
    }

    public void testMultiRefs() {
        Table table = this.getTable(this.identifier("connection"));
        ForeignKey foreignKey = this.getForeignKey(table, this.identifier("con2master"));
        ForeignKeysTest.assertNotNull((Object)foreignKey);
        ForeignKeysTest.assertEquals((String)this.toClassName("master"), (String)foreignKey.getReferencedEntityName());
        ForeignKeysTest.assertEquals((String)this.identifier("connection"), (String)foreignKey.getTable().getName());
        ForeignKeysTest.assertEquals((Object)this.getTable(this.identifier("master")), (Object)foreignKey.getReferencedTable());
        ForeignKeysTest.assertNotNull((Object)this.getForeignKey(table, this.identifier("childref1")));
        ForeignKeysTest.assertNotNull((Object)this.getForeignKey(table, this.identifier("childref2")));
        ForeignKeysTest.assertNull((Object)this.getForeignKey(table, this.identifier("dummy")));
        this.assertHasNext(3, table.getForeignKeyIterator());
    }

    public void testMasterChild() {
        Table master = this.getTable(this.identifier("master"));
        Table child = this.getTable(this.identifier("child"));
        Iterator iterator = child.getForeignKeyIterator();
        ForeignKey fk = (ForeignKey)iterator.next();
        ForeignKeysTest.assertFalse((String)"should only be one fk", (boolean)iterator.hasNext());
        ForeignKeysTest.assertEquals((int)1, (int)fk.getColumnSpan());
        ForeignKeysTest.assertSame((Object)fk.getColumn(0), (Object)child.getColumn(new Column(this.identifier("masterref"))));
    }

    public void testExport() {
        new SchemaExport((Configuration)this.cfg).create(true, false);
    }

    public static Test suite() {
        return new TestSuite(ForeignKeysTest.class);
    }
}

