/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;

public class IndexTest
extends JDBCMetaDataBinderTestCase {
    protected String[] getCreateSQL() {
        return new String[]{"create table withIndex (first int, second int, third int)", "create index myIndex on withIndex(first,third)", "create unique index otherIdx on withIndex(third)"};
    }

    protected String[] getDropSQL() {
        return new String[]{"drop index otherIdx", "drop index myIndex", "drop table withIndex"};
    }

    public void testUniqueKey() {
        Table table = this.getTable(this.identifier("withIndex"));
        UniqueKey uniqueKey = table.getUniqueKey(this.identifier("otherIdx"));
        IndexTest.assertNotNull((Object)uniqueKey);
        IndexTest.assertEquals((int)1, (int)uniqueKey.getColumnSpan());
        Column keyCol = uniqueKey.getColumn(0);
        IndexTest.assertTrue((boolean)keyCol.isUnique());
        IndexTest.assertSame((Object)keyCol, (Object)table.getColumn(keyCol));
    }

    public void testWithIndex() {
        Table table = this.getTable(this.identifier("withIndex"));
        this.assertEqualIdentifiers("withIndex", table.getName());
        IndexTest.assertNull((String)"there should be no pk", (Object)table.getPrimaryKey());
        Iterator iterator = table.getIndexIterator();
        int cnt = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++cnt;
        }
        IndexTest.assertEquals((int)1, (int)cnt);
        Index index = table.getIndex(this.identifier("myIndex"));
        IndexTest.assertNotNull((String)"No index ?", (Object)index);
        this.assertEqualIdentifiers("myIndex", index.getName());
        IndexTest.assertEquals((int)2, (int)index.getColumnSpan());
        IndexTest.assertSame((Object)index.getTable(), (Object)table);
        Iterator cols = index.getColumnIterator();
        Column col1 = (Column)cols.next();
        Column col2 = (Column)cols.next();
        this.assertEqualIdentifiers("first", col1.getName());
        this.assertEqualIdentifiers("third", col2.getName());
        Column example = new Column();
        example.setName(col2.getName());
        IndexTest.assertSame((String)"column with same name should be same instance!", (Object)table.getColumn(example), (Object)col2);
    }

    public static Test suite() {
        return new TestSuite(IndexTest.class);
    }
}

