/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;

public class OracleCompositeIdOrderTest
extends JDBCMetaDataBinderTestCase {
    protected void configure(JDBCMetaDataConfiguration cfg) {
        cfg.setPreferBasicCompositeIds(false);
        super.configure(cfg);
    }

    protected String[] getCreateSQL() {
        return new String[]{"CREATE TABLE REQUEST(  REQUEST_KEY             NUMBER(11)            NOT NULL,  TIMEFRAME_KEY           NUMBER(11))", "CREATE UNIQUE INDEX PK_REQUEST ON REQUEST(REQUEST_KEY)", "ALTER TABLE REQUEST ADD (  CONSTRAINT PK_REQUEST PRIMARY KEY (REQUEST_KEY))", "CREATE TABLE SCHEDULE(  SCHEDULE_KEY           NUMBER(11)             NOT NULL,  TITLE                  VARCHAR2(255)     NOT NULL)", "CREATE UNIQUE INDEX PK_SCHEDULE ON SCHEDULE(SCHEDULE_KEY)", "ALTER TABLE SCHEDULE ADD (  CONSTRAINT PK_SCHEDULE PRIMARY KEY (SCHEDULE_KEY))", "CREATE TABLE COURSE(  SCHEDULE_KEY                 NUMBER(11)       NOT NULL,  REQUEST_KEY                  NUMBER(11)       NOT NULL,  TIMEFRAME_KEY                NUMBER(11))", "CREATE UNIQUE INDEX PK_COURSE ON COURSE(SCHEDULE_KEY, REQUEST_KEY)", "ALTER TABLE COURSE ADD (  CONSTRAINT PK_COURSE PRIMARY KEY (SCHEDULE_KEY, REQUEST_KEY))", "ALTER TABLE COURSE ADD (  CONSTRAINT FK_COURSE__REQUEST FOREIGN KEY (REQUEST_KEY)     REFERENCES REQUEST (REQUEST_KEY)    ON DELETE CASCADE)", "ALTER TABLE COURSE ADD (  CONSTRAINT FK_COURSE__SCHEDULE FOREIGN KEY (SCHEDULE_KEY)     REFERENCES SCHEDULE (SCHEDULE_KEY)    ON DELETE CASCADE)", "CREATE TABLE COURSE_TOPIC(  SCHEDULE_KEY        NUMBER(11)                NOT NULL,  REQUEST_KEY         NUMBER(11)                NOT NULL,  TOPIC_KEY           NUMBER(11))", "ALTER TABLE COURSE_TOPIC ADD (  CONSTRAINT FK_COURSE_TOPIC__COURSE FOREIGN KEY (SCHEDULE_KEY, REQUEST_KEY)     REFERENCES COURSE (SCHEDULE_KEY,REQUEST_KEY)    ON DELETE CASCADE)", "ALTER TABLE COURSE_TOPIC ADD (  CONSTRAINT PK_COURSE_TOPIC PRIMARY KEY (TOPIC_KEY))"};
    }

    protected String[] getGenDataSQL() {
        return new String[]{"insert into PRODUCT (productId, extraId, description, price, numberAvailable) values('PC', '0', 'My PC', 100.0, 23)", "insert into PRODUCT (productId, extraId, description, price, numberAvailable) values('MS', '1', 'My Mouse', 101.0, 23)", "insert into CUSTOMER (customerId, name, address) values('MAX', 'Max Rydahl Andersen', 'Neuchatel')", "insert into CUSTOMERORDER (customerId, orderNumber, orderDate) values ('MAX', 1, '11-11-2005')", "insert into LINEITEM (customerIdref, orderNumber, productId, extraProdId, quantity) values ('MAX', 1, 'PC', '0', 10)", "insert into LINEITEM (customerIdref, orderNumber, productId, extraProdId, quantity) values ('MAX', 1, 'MS', '1', 12)"};
    }

    protected String[] getDropSQL() {
        return new String[]{"drop TABLE SCHEDULE cascade constraints", "drop TABLE REQUEST cascade constraints", "drop TABLE COURSE cascade constraints", "drop TABLE COURSE_TOPIC cascade constraints"};
    }

    public void testMultiColumnForeignKeys() {
        Table table = this.getTable(this.identifier("Course"));
        OracleCompositeIdOrderTest.assertNotNull((Object)table);
        ForeignKey foreignKey = this.getForeignKey(table, this.identifier("FK_COURSE__SCHEDULE"));
        OracleCompositeIdOrderTest.assertNotNull((Object)foreignKey);
        OracleCompositeIdOrderTest.assertEquals((String)this.toClassName(this.identifier("Schedule")), (String)foreignKey.getReferencedEntityName());
        OracleCompositeIdOrderTest.assertEquals((String)this.identifier("Course"), (String)foreignKey.getTable().getName());
        OracleCompositeIdOrderTest.assertEquals((int)1, (int)foreignKey.getColumnSpan());
        OracleCompositeIdOrderTest.assertEquals((String)foreignKey.getColumn(0).getName(), (String)"SCHEDULE_KEY");
        Table tab = this.getTable(this.identifier("COURSE"));
        OracleCompositeIdOrderTest.assertEquals((String)tab.getPrimaryKey().getColumn(0).getName(), (String)"SCHEDULE_KEY");
        OracleCompositeIdOrderTest.assertEquals((String)tab.getPrimaryKey().getColumn(1).getName(), (String)"REQUEST_KEY");
        this.cfg.buildMappings();
        PersistentClass course = this.cfg.getClassMapping(this.toClassName(this.identifier("Course")));
        OracleCompositeIdOrderTest.assertEquals((int)2, (int)course.getIdentifier().getColumnSpan());
        Iterator columnIterator = course.getIdentifier().getColumnIterator();
        OracleCompositeIdOrderTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"SCHEDULE_KEY");
        OracleCompositeIdOrderTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"REQUEST_KEY");
        course = this.cfg.getClassMapping(this.toClassName(this.identifier("COURSE_TOPIC")));
        Property property = course.getProperty(this.toPropertyName(this.identifier("course")));
        columnIterator = property.getValue().getColumnIterator();
        OracleCompositeIdOrderTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"SCHEDULE_KEY");
        OracleCompositeIdOrderTest.assertEquals((String)((Column)columnIterator.next()).getName(), (String)"REQUEST_KEY");
    }

    public static Test suite() {
        return new TestSuite(OracleCompositeIdOrderTest.class);
    }
}

