/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;

public class OracleViewsTest
extends JDBCMetaDataBinderTestCase {
    protected String[] getDropSQL() {
        return new String[]{"drop table basic", "drop table somecolumnsnopk", "drop table multikeyed", "drop view basicView", "drop synonym weirdname"};
    }

    protected String[] getCreateSQL() {
        return new String[]{"create table basic ( a int not null, primary key (a) )", "create table somecolumnsnopk ( pk varchar(25) not null, b char, c int not null )", "create table multikeyed ( orderid varchar(10), customerid varchar(10), name varchar(10), primary key(orderid, customerid) )", "create view basicView as select a from basic", "create synonym weirdname for multikeyed", "comment on table basic is 'a basic comment'", "comment on column basic.a is 'a solid key'"};
    }

    public void testViewAndSynonyms() throws SQLException {
        PersistentClass classMapping = this.cfg.getClassMapping(this.toClassName("basicview"));
        OracleViewsTest.assertNotNull((Object)classMapping);
        classMapping = this.cfg.getClassMapping(this.toClassName("weirdname"));
        OracleViewsTest.assertTrue((String)"If this is not-null synonyms apparently work!", (classMapping == null ? 1 : 0) != 0);
        Table table = this.getTable(this.identifier("basic"));
        OracleViewsTest.assertEquals((String)"a basic comment", (String)table.getComment());
        OracleViewsTest.assertEquals((String)"a solid key", (String)table.getPrimaryKey().getColumn(0).getComment());
        table = this.getTable(this.identifier("multikeyed"));
        OracleViewsTest.assertNull((Object)table.getComment());
        OracleViewsTest.assertNull((Object)table.getColumn(0).getComment());
    }

    public static Test suite() {
        return new TestSuite(OracleViewsTest.class);
    }
}

