/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.util.Iterator;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;

public class OverrideBinderTest
extends JDBCMetaDataBinderTestCase {
    private static final String OVERRIDETEST_REVENG_XML = "org/hibernate/tool/test/jdbc2cfg/overridetest.reveng.xml";
    private static final String TEST_REVENG_XML = "org/hibernate/tool/test/jdbc2cfg/test.reveng.xml";
    static Settings settings;

    public void testReadTypeMappings() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(TEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertEquals((String)"int", (String)repository.columnToHibernateTypeName(null, null, 4, 5, Integer.MAX_VALUE, Integer.MAX_VALUE));
        OverrideBinderTest.assertEquals((String)"long", (String)repository.columnToHibernateTypeName(null, null, 4, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
        OverrideBinderTest.assertEquals((String)"byte[]", (String)repository.columnToHibernateTypeName(null, null, -5, Integer.MAX_VALUE, 5, Integer.MAX_VALUE));
        OverrideBinderTest.assertEquals((String)"java.math.BigInteger", (String)repository.columnToHibernateTypeName(null, null, -5, Integer.MAX_VALUE, 2, 3));
        OverrideBinderTest.assertEquals((String)"string", (String)repository.columnToHibernateTypeName(null, null, 1, 1, 10, Integer.MAX_VALUE));
    }

    private OverrideRepository buildOverrideRepository() {
        if (settings == null) {
            settings = new SettingsFactory(){}.buildSettings(Environment.getProperties());
        }
        return new OverrideRepository(settings.getDefaultCatalogName(), settings.getDefaultSchemaName());
    }

    public void testColumnTypeMappings() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(OVERRIDETEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertNull((Object)repository.columnToHibernateTypeName(new TableIdentifier("blah"), "bogus", 0, 0, 0, 0));
        OverrideBinderTest.assertNull((Object)repository.columnToHibernateTypeName(new TableIdentifier("ORDERS"), "CUSTID", 0, 0, 0, 0));
        OverrideBinderTest.assertEquals((String)"string", (String)repository.columnToHibernateTypeName(new TableIdentifier(settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), "ORDERS"), "NAME", 0, 0, 0, 0));
        PersistentClass classMapping = this.cfg.getClassMapping("Orders");
        Property property = classMapping.getProperty("completed");
        OverrideBinderTest.assertEquals((String)"boolean", (String)((SimpleValue)property.getValue()).getTypeName());
    }

    public void testColumnPropertyNameMappings() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(OVERRIDETEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertNull((Object)repository.columnToPropertyName(new TableIdentifier("blah"), "bogus"));
        OverrideBinderTest.assertNull((Object)repository.columnToPropertyName(new TableIdentifier("ORDERS"), "cust_id"));
        OverrideBinderTest.assertEquals((String)"orderName", (String)repository.columnToPropertyName(new TableIdentifier(null, "PUBLIC", "ORDERS"), "NAME"));
    }

    public void testIdGenerator() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(OVERRIDETEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertNull((Object)repository.getTableIdentifierStrategyName(new TableIdentifier("blah")));
        OverrideBinderTest.assertNull((Object)repository.getTableIdentifierProperties(new TableIdentifier("blah")));
        OverrideBinderTest.assertEquals((String)"sequence", (String)repository.getTableIdentifierStrategyName(new TableIdentifier(null, "PUBLIC", "ORDERS")));
        Properties props = repository.getTableIdentifierProperties(new TableIdentifier(null, "PUBLIC", "ORDERS"));
        OverrideBinderTest.assertEquals((Object)"seq_table", props.get("table"));
        PersistentClass classMapping = this.cfg.getClassMapping("Orders");
        SimpleValue sv = (SimpleValue)classMapping.getIdentifier();
        OverrideBinderTest.assertEquals((String)"sequence", (String)sv.getIdentifierGeneratorStrategy());
        OverrideBinderTest.assertNotNull((Object)sv.getIdentifierGeneratorProperties());
        OverrideBinderTest.assertEquals((String)"seq_table", (String)sv.getIdentifierGeneratorProperties().getProperty("table"));
        OverrideBinderTest.assertEquals((int)1, (int)classMapping.getIdentifierProperty().getColumnSpan());
    }

    public void testReadExcludeTables() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(OVERRIDETEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertTrue((boolean)repository.excludeTable(new TableIdentifier(null, null, "DoNotWantIt")));
        OverrideBinderTest.assertFalse((boolean)repository.excludeTable(new TableIdentifier(null, null, "NotListedThere")));
        OverrideBinderTest.assertFalse((boolean)repository.excludeTable(new TableIdentifier("cat", "sch", "WantedTable")));
        OverrideBinderTest.assertFalse((boolean)repository.excludeTable(new TableIdentifier("BAD", "SCHEMA", "WantedTable")));
        OverrideBinderTest.assertTrue((boolean)repository.excludeTable(new TableIdentifier("BAD", "SCHEMA", "SomethingElse")));
    }

    public void testReadPackageName() {
        OverrideRepository or = this.buildOverrideRepository();
        or.addResource(OVERRIDETEST_REVENG_XML);
        ReverseEngineeringStrategy repository = or.getReverseEngineeringStrategy(new DefaultReverseEngineeringStrategy());
        OverrideBinderTest.assertEquals((String)"org.werd.Q", (String)repository.tableToClassName(new TableIdentifier("q", "Werd", "Q")));
        OverrideBinderTest.assertEquals((String)"Notknown", (String)repository.tableToClassName(new TableIdentifier(null, null, "notknown")));
    }

    public Table findTable(String name) {
        Iterator tableIter = this.cfg.getTableMappings();
        Table table = null;
        while (tableIter.hasNext()) {
            table = (Table)tableIter.next();
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public void testRevEngExclude() {
        OverrideBinderTest.assertNull((Object)this.findTable(this.identifier("defunct_table")));
        Table foundTable = this.findTable(this.identifier("inthemiddle"));
        OverrideBinderTest.assertNotNull((Object)foundTable);
        Iterator fkiter = foundTable.getForeignKeyIterator();
        ForeignKey fk1 = (ForeignKey)fkiter.next();
        OverrideBinderTest.assertFalse((boolean)fkiter.hasNext());
    }

    public void testSQLTypeMappingComparisons() {
        SQLTypeMapping one = new SQLTypeMapping(-5, 5, Integer.MAX_VALUE, Integer.MAX_VALUE);
        SQLTypeMapping two = new SQLTypeMapping(-5, Integer.MAX_VALUE, 3, Integer.MAX_VALUE);
        SQLTypeMapping generic = new SQLTypeMapping(-5, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        SQLTypeMapping specific = new SQLTypeMapping(-5, 2, 3, 4);
        OverrideBinderTest.assertFalse((boolean)one.equals(two));
        OverrideBinderTest.assertFalse((boolean)two.equals(one));
        OverrideBinderTest.assertTrue((boolean)two.equals(two));
        OverrideBinderTest.assertTrue((boolean)one.equals(one));
        OverrideBinderTest.assertEquals((int)-1, (int)one.compareTo(two));
        OverrideBinderTest.assertEquals((int)1, (int)two.compareTo(one));
        OverrideBinderTest.assertEquals((int)1, (int)generic.compareTo(one));
        OverrideBinderTest.assertEquals((int)1, (int)generic.compareTo(two));
        OverrideBinderTest.assertEquals((int)1, (int)generic.compareTo(specific));
        OverrideBinderTest.assertEquals((int)-1, (int)specific.compareTo(one));
        OverrideBinderTest.assertEquals((int)-1, (int)specific.compareTo(two));
        OverrideBinderTest.assertEquals((int)-1, (int)specific.compareTo(generic));
    }

    public void testSqlTypeOverride() {
        OverrideRepository or = this.buildOverrideRepository();
        SQLTypeMapping sqltype = new SQLTypeMapping(-2);
        sqltype.setLength(1);
        sqltype.setHibernateType("boolean");
        or.addTypeMapping(sqltype);
        sqltype = new SQLTypeMapping(-7);
        sqltype.setHibernateType("yes_no");
        or.addTypeMapping(sqltype);
        ReverseEngineeringStrategy res = or.getReverseEngineeringStrategy(null);
        OverrideBinderTest.assertEquals((String)"boolean", (String)res.columnToHibernateTypeName(null, null, -2, 1, Integer.MAX_VALUE, Integer.MAX_VALUE));
        OverrideBinderTest.assertEquals(null, (String)res.columnToHibernateTypeName(null, null, -1, 1, Integer.MAX_VALUE, Integer.MAX_VALUE));
        OverrideBinderTest.assertEquals((String)"yes_no", (String)res.columnToHibernateTypeName(null, null, -7, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void testTableExclude() {
        TableFilter tf = new TableFilter();
        tf.setMatchName("max");
        tf.setExclude(Boolean.TRUE);
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("max")));
        OverrideBinderTest.assertNull((Object)tf.exclude(new TableIdentifier("maxnotexact")));
        tf.setMatchName(".*max");
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("max")));
        OverrideBinderTest.assertNull((Object)tf.exclude(new TableIdentifier("maxnotending")));
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("endingWithmax")));
        tf.setMatchName("max.*");
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("max")));
        tf.setMatchName(".*max.*");
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("max")));
        OverrideBinderTest.assertNull((Object)tf.exclude(new TableIdentifier("notxam")));
        OverrideBinderTest.assertTrue((boolean)tf.exclude(new TableIdentifier("heremaxsub")));
    }

    public void testSimpleUserDefinedForeignKeys() {
        Table table = this.findTable(this.identifier("Orders"));
        Iterator foreignKeyIterator = table.getForeignKeyIterator();
        ForeignKey fk = (ForeignKey)foreignKeyIterator.next();
        OverrideBinderTest.assertEquals((String)fk.getReferencedTable().getName(), (String)this.identifier("Customer"));
        PersistentClass classMapping = this.cfg.getClassMapping("Orders");
        classMapping.getProperty("customer");
        classMapping = this.cfg.getClassMapping("Customer");
        classMapping.getProperty("orderses");
    }

    public void testCompositeUserDefinedForeignKeys() {
        Table table = this.findTable(this.identifier("Children"));
        Iterator foreignKeyIterator = table.getForeignKeyIterator();
        ForeignKey fk = (ForeignKey)foreignKeyIterator.next();
        OverrideBinderTest.assertEquals((String)fk.getReferencedTable().getName(), (String)this.identifier("Parent"));
        OverrideBinderTest.assertEquals((int)2, (int)fk.getReferencedColumns().size());
        PersistentClass classMapping = this.cfg.getClassMapping("Children");
        Property property = classMapping.getProperty("parent");
        OverrideBinderTest.assertEquals((int)2, (int)property.getColumnSpan());
        classMapping = this.cfg.getClassMapping("Parent");
        property = classMapping.getProperty("childrens");
    }

    public void testTypes() {
        PersistentClass classMapping = this.cfg.getClassMapping("MiscTypes");
        OverrideBinderTest.assertEquals((String)"long", (String)this.getPropertyTypeName(classMapping.getIdentifierProperty()));
        OverrideBinderTest.assertEquals((String)"SomeUserType", (String)this.getPropertyTypeName(classMapping.getProperty("name")));
        OverrideBinderTest.assertEquals((String)"string", (String)this.getPropertyTypeName(classMapping.getProperty("shortname")));
        OverrideBinderTest.assertEquals((String)"yes_no", (String)this.getPropertyTypeName(classMapping.getProperty("flag")));
    }

    public void testTableToClass() {
        ReverseEngineeringStrategy res = this.buildOverrideRepository().addResource(OVERRIDETEST_REVENG_XML).getReverseEngineeringStrategy(new DefaultReverseEngineeringStrategy());
        TableIdentifier tableIdentifier = new TableIdentifier(settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), "TblTest");
        OverrideBinderTest.assertEquals((String)"org.test.Test", (String)res.tableToClassName(tableIdentifier));
        tableIdentifier = new TableIdentifier(settings.getDefaultCatalogName(), "Werd", "Testy");
        OverrideBinderTest.assertEquals((String)"org.werd.Testy", (String)res.tableToClassName(tableIdentifier));
        tableIdentifier = new TableIdentifier(settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), "Nothing");
        OverrideBinderTest.assertEquals((String)"Nothing", (String)res.tableToClassName(tableIdentifier));
    }

    protected void configure(JDBCMetaDataConfiguration cfg) {
        super.configure(cfg);
        Settings s = cfg.buildSettings();
        OverrideRepository or = new OverrideRepository(s.getDefaultCatalogName(), s.getDefaultSchemaName());
        or.addResource(OVERRIDETEST_REVENG_XML);
        cfg.setReverseEngineeringStrategy(or.getReverseEngineeringStrategy(new DefaultReverseEngineeringStrategy()));
    }

    private String getPropertyTypeName(Property property) {
        return ((SimpleValue)property.getValue()).getTypeName();
    }

    protected String[] getCreateSQL() {
        return new String[]{"create table dummy (id numeric(10,0) not null, primary key (id) )", "create table defunct_table ( id numeric(10,0) not null, name varchar(20), shortname varchar(5), flag varchar(1), dumid numeric(10,0), primary key (id), foreign key (dumid) references dummy)", "create table misc_types ( id numeric(10,0) not null, name varchar(20), shortname varchar(5), flag varchar(1), primary key (id) )", "create table inthemiddle ( miscid numeric(10,0), defunctid numeric(10,0), foreign key (miscid) references misc_types, foreign key (defunctid) references defunct_table )", "create table customer ( custid varchar(10), name varchar(20) )", "create table orders ( orderid varchar(10), name varchar(20),  custid varchar(10), completed numeric(1), primary key (orderid) )", "create table parent ( id varchar(10), name varchar(20))", "create table children ( id varchar(10), parentid varchar(10), name varchar(20) )"};
    }

    protected String[] getDropSQL() {
        return new String[]{"drop table parent", "drop table children", "drop table customer", "drop table orders", "drop table inthemiddle", "drop table misc_types", "drop table defunct_table", "drop table dummy"};
    }

    public static Test suite() {
        return new TestSuite(OverrideBinderTest.class);
    }
}

