/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;
import org.hibernate.type.Type;

public class PerformanceTest
extends JDBCMetaDataBinderTestCase {
    static final int TABLECOUNT = 200;
    static final int COLCOUNT = 10;
    List createSQL = new ArrayList();
    List dropSQL = new ArrayList();

    protected String[] getDropSQL() {
        return this.dropSQL.toArray(new String[this.dropSQL.size()]);
    }

    protected String[] getCreateSQL() {
        Dialect dia = this.cfg.buildSettings().getDialect();
        Mapping map = new Mapping(){

            public String getIdentifierPropertyName(String className) throws MappingException {
                return null;
            }

            public Type getIdentifierType(String className) throws MappingException {
                return null;
            }

            public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
                return null;
            }
        };
        this.dropSQL = new ArrayList(200);
        this.createSQL = new ArrayList(200);
        Table lastTable = null;
        for (int tablecount = 0; tablecount < 200; ++tablecount) {
            Table table = new Table("perftest" + tablecount);
            Column col = new Column("id");
            SimpleValue sv = new SimpleValue(table);
            sv.setTypeName("string");
            col.setValue((Value)sv);
            table.addColumn(col);
            PrimaryKey pk = new PrimaryKey();
            pk.addColumn(col);
            table.setPrimaryKey(pk);
            for (int colcount = 0; colcount < 10; ++colcount) {
                col = new Column("col" + tablecount + "_" + colcount);
                sv = new SimpleValue(table);
                sv.setTypeName("string");
                col.setValue((Value)sv);
                table.addColumn(col);
            }
            this.createSQL.add(table.sqlCreateString(dia, map, null, null));
            this.dropSQL.add(table.sqlDropString(dia, null, null));
            if (lastTable != null) {
                ForeignKey fk = new ForeignKey();
                fk.setName(col.getName() + lastTable.getName() + table.getName());
                fk.addColumn(col);
                fk.setTable(table);
                fk.setReferencedTable(lastTable);
                this.createSQL.add(fk.sqlCreateString(dia, map, null, null));
                this.dropSQL.add(0, fk.sqlDropString(dia, null, null));
            }
            lastTable = table;
        }
        return this.createSQL.toArray(new String[this.createSQL.size()]);
    }

    public void testBasic() throws SQLException {
        this.assertHasNext("There should be three tables!", 200, this.cfg.getTableMappings());
        Table tab = (Table)this.cfg.getTableMappings().next();
        PerformanceTest.assertEquals((int)tab.getColumnSpan(), (int)11);
    }

    public static Test suite() {
        return new TestSuite(PerformanceTest.class);
    }
}

