/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.test.jdbc2cfg;

import java.io.Serializable;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.classic.Session;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.tool.JDBCMetaDataBinderTestCase;
import persistentclasses.Item;
import persistentclasses.Orders;

public class PersistentClassesTest
extends JDBCMetaDataBinderTestCase {
    protected String[] getCreateSQL() {
        return new String[]{"create table orders ( id numeric(10,0) not null, name varchar(20), primary key (id) )", "create table item  ( child_id numeric(10,0) not null, name varchar(50), order_id numeric(10,0), related_order_id numeric(10,0), primary key (child_id), foreign key (order_id) references orders(id), foreign key (related_order_id) references orders(id) )"};
    }

    protected void configure(JDBCMetaDataConfiguration cfg) {
        DefaultReverseEngineeringStrategy c = new DefaultReverseEngineeringStrategy();
        c.setPackageName("persistentclasses");
        cfg.setReverseEngineeringStrategy(c);
    }

    protected String[] getDropSQL() {
        return new String[]{"drop table item", "drop table orders"};
    }

    public void testCreatePersistentClasses() {
        this.cfg.buildMappings();
        PersistentClass classMapping = this.cfg.getClassMapping(this.toClassName("orders"));
        PersistentClassesTest.assertNotNull((String)"class not found", (Object)classMapping);
        KeyValue identifier = classMapping.getIdentifier();
        PersistentClassesTest.assertNotNull((Object)identifier);
    }

    public void testCreateManyToOne() {
        this.cfg.buildMappings();
        PersistentClass classMapping = this.cfg.getClassMapping(this.toClassName("item"));
        PersistentClassesTest.assertNotNull((Object)classMapping);
        KeyValue identifier = classMapping.getIdentifier();
        PersistentClassesTest.assertNotNull((Object)identifier);
        PersistentClassesTest.assertEquals((int)3, (int)classMapping.getPropertyClosureSpan());
        Property property = classMapping.getProperty("ordersByRelatedOrderId");
        PersistentClassesTest.assertNotNull((Object)property);
        property = classMapping.getProperty("ordersByOrderId");
        PersistentClassesTest.assertNotNull((Object)property);
    }

    public void testCreateOneToMany() {
        this.cfg.buildMappings();
        PersistentClass orders = this.cfg.getClassMapping(this.toClassName("orders"));
        Property itemset = orders.getProperty("itemsForRelatedOrderId");
        Collection col = (Collection)itemset.getValue();
        OneToMany otm = (OneToMany)col.getElement();
        PersistentClassesTest.assertEquals((String)otm.getReferencedEntityName(), (String)this.toClassName("item"));
        PersistentClassesTest.assertEquals((String)otm.getAssociatedClass().getClassName(), (String)this.toClassName("item"));
        PersistentClassesTest.assertEquals((String)otm.getTable().getName(), (String)this.identifier("orders"));
        PersistentClassesTest.assertNotNull((Object)itemset);
        PersistentClassesTest.assertTrue((boolean)(itemset.getValue() instanceof Set));
    }

    public void testBinding() throws HibernateException, SQLException {
        SessionFactory sf = this.cfg.buildSessionFactory();
        Session session = sf.openSession();
        Transaction t = session.beginTransaction();
        Orders order = new Orders();
        order.setId(new Long(1L));
        order.setName("Mickey");
        session.save((Object)order);
        Item item = this.addItem(order, 42, "item 42");
        session.save((Object)item);
        session.save((Object)this.addItem(order, 43, "x"));
        session.save((Object)this.addItem(order, 44, "y"));
        session.save((Object)this.addItem(order, 45, "z"));
        session.save((Object)this.addItem(order, 46, "w"));
        t.commit();
        session.close();
        session = sf.openSession();
        t = session.beginTransaction();
        Item loadeditem = (Item)session.get(this.toClassName("item"), (Serializable)new Long(42L));
        PersistentClassesTest.assertEquals((String)item.getName(), (String)loadeditem.getName());
        PersistentClassesTest.assertEquals((Object)item.getChildId(), (Object)loadeditem.getChildId());
        PersistentClassesTest.assertEquals((Object)item.getOrderId().getId(), (Object)loadeditem.getOrderId().getId());
        PersistentClassesTest.assertTrue((boolean)loadeditem.getOrderId().getItemsForOrderId().contains(loadeditem));
        PersistentClassesTest.assertTrue((boolean)item.getOrderId().getItemsForOrderId().contains(item));
        PersistentClassesTest.assertEquals((int)5, (int)item.getOrderId().getItemsForOrderId().size());
        PersistentClassesTest.assertEquals((int)5, (int)loadeditem.getOrderId().getItemsForOrderId().size());
        t.commit();
        session.close();
        session = sf.openSession();
        t = session.beginTransaction();
        order = (Orders)session.load(Orders.class, (Serializable)new Long(1L));
        PersistentClassesTest.assertFalse((boolean)Hibernate.isInitialized((Object)order));
        PersistentClassesTest.assertFalse((boolean)Hibernate.isInitialized((Object)order.getItemsForOrderId()));
        order = (Orders)session.createQuery("from persistentclasses.Orders").uniqueResult();
        PersistentClassesTest.assertFalse((boolean)Hibernate.isInitialized((Object)order.getItemsForOrderId()));
        t.commit();
        session.close();
    }

    private Item addItem(Orders m, int itemid, String name) {
        Item item = new Item();
        item.setChildId(new Long(itemid));
        item.setOrderId(m);
        item.setName(name);
        m.getItemsForOrderId().add(item);
        return item;
    }

    public static Test suite() {
        return new TestSuite(PersistentClassesTest.class);
    }
}

