/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.hibernate.tool.hbm2x.xml.XMLPrettyPrinterStrategyFactory;

public final class XMLPrettyPrinter {
    public static void prettyPrintFile(File file) throws IOException {
        String input = XMLPrettyPrinter.readFile(file.getAbsolutePath(), Charset.defaultCharset());
        String output = XMLPrettyPrinter.prettyFormat(input);
        PrintWriter writer = new PrintWriter(file);
        writer.print(output);
        writer.flush();
        writer.close();
    }

    private static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private static String prettyFormat(String input) {
        try {
            return XMLPrettyPrinterStrategyFactory.newXMLPrettyPrinterStrategy().prettyPrint(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

