/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.tool.util.ReflectHelper;

public class H2MetaDataDialect
extends JDBCMetaDataDialect {
    private static final String SPKSQ_H2_1_X = "SELECT   idx.TABLE_CATALOG TABLE_CAT,   idx.TABLE_SCHEMA TABLE_SCHEM,   idx.TABLE_NAME,   idx.COLUMN_NAME FROM   INFORMATION_SCHEMA.INDEXES idx,   INFORMATION_SCHEMA.COLUMNS cols WHERE   idx.TABLE_CATALOG = cols.TABLE_CATALOG AND   idx.TABLE_SCHEMA = cols.TABLE_SCHEMA AND   idx.TABLE_NAME = cols.TABLE_NAME AND   idx.PRIMARY_KEY = TRUE AND   cols.COLUMN_DEFAULT like '%NEXT VALUE FOR%' ";
    private static final String SPKSQ_H2_2_X = "SELECT   idx.TABLE_CATALOG TABLE_CAT,   idx.TABLE_SCHEMA TABLE_SCHEM,   idx.TABLE_NAME,   cols.COLUMN_NAME FROM   INFORMATION_SCHEMA.INDEXES idx,   INFORMATION_SCHEMA.INDEX_COLUMNS idx_cols,   INFORMATION_SCHEMA.COLUMNS cols WHERE                                        idx.TABLE_CATALOG = cols.TABLE_CATALOG AND    idx.TABLE_SCHEMA = cols.TABLE_SCHEMA   AND    idx.TABLE_NAME = cols.TABLE_NAME AND    idx.INDEX_TYPE_NAME = 'PRIMARY KEY' AND    cols.COLUMN_NAME = idx_cols.COLUMN_NAME AND    cols.IS_IDENTITY = 'YES'";
    private static boolean understandsCatalogName = true;
    private String suggested_primary_key_strategy_query = null;

    public H2MetaDataDialect() {
        try {
            Class<?> constants = ReflectHelper.classForName("org.h2.engine.Constants");
            Integer build = (Integer)constants.getDeclaredField("BUILD_ID").get(null);
            if (build < 55) {
                understandsCatalogName = false;
            }
            this.suggested_primary_key_strategy_query = build > 200 ? SPKSQ_H2_2_X : SPKSQ_H2_1_X;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void putTableType(Map<String, Object> element, ResultSet tableRs) throws SQLException {
        String tableType = tableRs.getString("TABLE_TYPE");
        if ("BASE TABLE".equals(tableType)) {
            tableType = "TABLE";
        }
        element.put("TABLE_TYPE", tableType);
    }

    @Override
    protected void putTablePart(Map<String, Object> element, ResultSet tableRs) throws SQLException {
        super.putTablePart(element, tableRs);
        if (!understandsCatalogName) {
            element.put("TABLE_CAT", null);
        }
    }

    @Override
    protected void putExportedKeysPart(Map<String, Object> element, ResultSet rs) throws SQLException {
        super.putExportedKeysPart(element, rs);
        if (!understandsCatalogName) {
            element.put("PKTABLE_CAT", null);
        }
    }

    @Override
    public Iterator<Map<String, Object>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        try {
            catalog = this.caseForSearch(catalog);
            schema = this.caseForSearch(schema);
            table = this.caseForSearch(table);
            this.log.debug((Object)("geSuggestedPrimaryKeyStrategyName(" + catalog + "." + schema + "." + table + ")"));
            String sql = this.suggested_primary_key_strategy_query;
            if (catalog != null) {
                sql = sql + "AND idx.TABLE_CATALOG like '" + catalog + "' ";
            }
            if (schema != null) {
                sql = sql + "AND idx.TABLE_SCHEMA like '" + schema + "' ";
            }
            if (table != null) {
                sql = sql + "AND idx.TABLE_NAME like '" + table + "' ";
            }
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            return new ResultSetIterator(statement.executeQuery(), this.getSQLExceptionConverter()){
                Map<String, Object> element;
                {
                    this.element = new HashMap<String, Object>();
                }

                @Override
                protected Map<String, Object> convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    H2MetaDataDialect.this.putTablePart(this.element, tableRs);
                    this.element.put("HIBERNATE_STRATEGY", "identity");
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem.", null);
        }
    }
}

