/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.tool.util.TableNameQualifier;

public class HSQLMetaDataDialect
extends JDBCMetaDataDialect {
    private String quote(String columnName) {
        if (columnName == null) {
            return columnName;
        }
        if (this.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '\"' && columnName.charAt(columnName.length() - 1) == '\"') {
                return columnName;
            }
            return "\"" + columnName + "\"";
        }
        return columnName;
    }

    @Override
    public Iterator<Map<String, Object>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        String sql = null;
        try {
            catalog = this.caseForSearch(catalog);
            schema = this.caseForSearch(schema);
            table = this.caseForSearch(table);
            final String sc = schema;
            final String cat = catalog;
            return new ResultSetIterator(this.getMetaData().getTables(catalog, schema, table, new String[]{"TABLE"}), this.getSQLExceptionConverter()){
                Map<String, Object> element;
                {
                    super(resultset, sec);
                    this.element = new HashMap<String, Object>();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Map<String, Object> convertRow(ResultSet tableRs) throws SQLException {
                    String table = tableRs.getString("TABLE_NAME");
                    String fullTableName = TableNameQualifier.qualify(HSQLMetaDataDialect.this.quote(cat), HSQLMetaDataDialect.this.quote(sc), HSQLMetaDataDialect.this.quote(table));
                    String sql = "SELECT * FROM " + fullTableName + " WHERE 0>1";
                    boolean isAutoIncrement = false;
                    PreparedStatement statement = null;
                    try {
                        statement = HSQLMetaDataDialect.this.getConnection().prepareStatement(sql);
                        this.element.clear();
                        this.element.put("TABLE_NAME", table);
                        this.element.put("TABLE_SCHEM", sc);
                        this.element.put("TABLE_CAT", null);
                        ResultSet rs = statement.executeQuery();
                        ResultSetMetaData rsmd = rs.getMetaData();
                        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
                            isAutoIncrement = rsmd.isAutoIncrement(i + 1);
                            if (!isAutoIncrement) continue;
                            break;
                        }
                    }
                    catch (SQLException e) {
                        HSQLMetaDataDialect.this.log.debug((Object)("Error while getting suggested primary key strategy for " + fullTableName + ". Falling back to default strategy."), (Throwable)e);
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e) {
                                throw this.getSQLExceptionConverter().convert(e, "Problem while closing prepared statement", null);
                            }
                        }
                    }
                    if (isAutoIncrement) {
                        this.element.put("HIBERNATE_STRATEGY", "identity");
                    } else {
                        this.element.put("HIBERNATE_STRATEGY", null);
                    }
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", sql);
        }
    }
}

