/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.metadata;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.JDBCBinder;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.type.Type;

public class JdbcMetadataDescriptor
implements MetadataDescriptor {
    private ReverseEngineeringStrategy reverseEngineeringStrategy = new DefaultReverseEngineeringStrategy();
    private boolean preferBasicCompositeIds = true;
    private Properties properties = new Properties();

    public JdbcMetadataDescriptor(ReverseEngineeringStrategy reverseEngineeringStrategy, Properties properties, boolean preferBasicCompositeIds) {
        this.properties.putAll((Map<?, ?>)Environment.getProperties());
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        if (reverseEngineeringStrategy != null) {
            this.reverseEngineeringStrategy = reverseEngineeringStrategy;
        }
        this.preferBasicCompositeIds = preferBasicCompositeIds;
    }

    @Override
    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    @Override
    public Metadata createMetadata() {
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.getProperties()).build();
        MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
        BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(serviceRegistry, (MetadataBuildingOptions)metadataBuildingOptions);
        metadataBuildingOptions.setBootstrapContext(bootstrapContext);
        InFlightMetadataCollectorImpl metadataCollector = this.getMetadataCollector((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
        MetadataBuildingContextRootImpl metadataBuildingContext = new MetadataBuildingContextRootImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)metadataCollector);
        MetadataImpl metadata = metadataCollector.buildMetadataInstance((MetadataBuildingContext)metadataBuildingContext);
        metadata.getTypeConfiguration().scope((MetadataBuildingContext)metadataBuildingContext);
        JDBCBinder binder = new JDBCBinder((ServiceRegistry)serviceRegistry, this.getProperties(), (MetadataBuildingContext)metadataBuildingContext, this.reverseEngineeringStrategy, this.preferBasicCompositeIds);
        binder.readFromDatabase(null, null, this.buildMapping((Metadata)metadata));
        return metadata;
    }

    private InFlightMetadataCollectorImpl getMetadataCollector(BootstrapContext bootstrapContext, MetadataBuildingOptions metadataBuildingOptions) {
        return new InFlightMetadataCollectorImpl(bootstrapContext, metadataBuildingOptions);
    }

    private Mapping buildMapping(final Metadata metadata) {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = metadata.getEntityBinding(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }

            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return null;
            }
        };
    }
}

