/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.exists;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;

public class CheckSum {
    private static final int BUFFER_SIZE = 65536;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final MessageDigest digest = MessageDigest.getInstance("SHA-1");

    private static String hexEncode(byte[] bytes) {
        int cOffset = bytes.length * 2;
        char[] chars = new char[cOffset];
        int bOffset = bytes.length;
        while (--bOffset >= 0) {
            int c = bytes[bOffset] & 0xFF;
            chars[--cOffset] = HEX_DIGITS[c & 0xF];
            chars[--cOffset] = HEX_DIGITS[c >> 4];
        }
        return new String(chars);
    }

    public byte[] getChecksumBytes(Path path) throws IOException {
        try (SeekableByteChannel byteChannel = Files.newByteChannel(path, StandardOpenOption.READ);){
            this.digest.reset();
            this.readStream(byteChannel);
            byte[] byArray = this.digest.digest();
            return byArray;
        }
    }

    public String getChecksum(Path path) throws IOException {
        return CheckSum.hexEncode(this.getChecksumBytes(path));
    }

    private void readStream(ByteChannel byteChannel) throws IOException {
        int bytes;
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        while ((bytes = byteChannel.read(byteBuffer)) >= 0) {
            byteBuffer.flip();
            this.digest.update(byteBuffer);
            byteBuffer.clear();
        }
    }

    public void writeChecksum(Path path) throws IOException {
        Set<String> lines = Collections.singleton(this.getChecksum(path));
        Path sibling = path.resolveSibling(path.getFileName() + ".sha1");
        Files.write(sibling, lines, StandardCharsets.US_ASCII, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }
}

