/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.external.ExtensionNode;
import org.jahia.modules.external.ExtensionProperty;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalNodeImpl;
import org.jahia.modules.external.ExternalPropertyImpl;
import org.jahia.modules.external.ExternalProviderInitializerService;
import org.jahia.modules.external.ExternalRepositoryImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ExternalContentStoreProvider
extends JCRStoreProvider
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContentStoreProvider.class);
    private static final ThreadLocal<ExternalSessionImpl> currentSession = new ThreadLocal();
    private boolean readOnly;
    private ExternalDataSource dataSource;
    private String id;
    private ExternalProviderInitializerService externalProviderInitializerService;
    private List<String> extendableTypes;
    private List<String> nonExtendableMixins;
    private List<String> overridableItems;
    private List<String> nonOverridableItems;
    private List<String> reservedNodes = Arrays.asList("j:acl", "j:workflowRules", "j:conditionalVisibility", "thumbnail");
    private List<String> ignorePropertiesForExport = Arrays.asList("j:extendedType", "j:isExternalProviderRoot", "j:externalNodeIdentifier");
    private boolean slowConnection = true;
    private boolean lockSupport = false;
    private boolean cacheKeyOnReferenceSupport = false;
    private boolean aclSupport = true;

    public static ExternalSessionImpl getCurrentSession() {
        return currentSession.get();
    }

    public static void setCurrentSession(ExternalSessionImpl session) {
        currentSession.set(session);
    }

    public static void removeCurrentSession() {
        currentSession.remove();
    }

    protected Repository createRepository() {
        NamespaceRegistry namespaceRegistry;
        JCRStoreProvider defaultProvider = JCRSessionFactory.getInstance().getDefaultProvider();
        JCRSessionWrapper systemSession = null;
        try {
            systemSession = defaultProvider.getSystemSession();
            namespaceRegistry = systemSession.getProviderSession(defaultProvider).getWorkspace().getNamespaceRegistry();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
        ExternalRepositoryImpl instance = new ExternalRepositoryImpl(this, this.dataSource, namespaceRegistry);
        instance.setProviderKey(this.getKey());
        return instance;
    }

    public boolean start(boolean checkAvailability) throws JahiaInitializationException {
        ArrayList<String> l;
        if (this.aclSupport) {
            if (this.overridableItems != null) {
                l = new ArrayList<String>();
                l.addAll(this.overridableItems);
                l.addAll(this.externalProviderInitializerService.getOverridableItemsForACLs());
                this.overridableItems = l;
            } else {
                this.overridableItems = new ArrayList<String>(this.externalProviderInitializerService.getOverridableItemsForACLs());
            }
        }
        if (this.lockSupport) {
            if (this.overridableItems != null) {
                l = new ArrayList();
                l.addAll(this.overridableItems);
                l.addAll(this.externalProviderInitializerService.getOverridableItemsForLocks());
                this.overridableItems = l;
            } else {
                this.overridableItems = new ArrayList<String>(this.externalProviderInitializerService.getOverridableItemsForLocks());
            }
        }
        this.getId();
        if (this.dataSource instanceof ExternalDataSource.Initializable) {
            ((ExternalDataSource.Initializable)((Object)this.dataSource)).start();
        }
        return super.start(checkAvailability);
    }

    public void stop() {
        super.stop();
        if (this.dataSource instanceof ExternalDataSource.Initializable) {
            ((ExternalDataSource.Initializable)((Object)this.dataSource)).stop();
        }
    }

    protected void initObservers() throws RepositoryException {
    }

    public QueryManager getQueryManager(JCRSessionWrapper session) throws RepositoryException {
        return this.dataSource instanceof ExternalDataSource.Searchable ? super.getQueryManager(session) : null;
    }

    public ExternalDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ExternalDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getKey() != null) {
            this.init();
        }
    }

    protected void init() throws RepositoryException {
        if (this.getKey() == null) {
            throw new IllegalArgumentException("The key is not specified for the provider instance. Unable to initialize this provider.");
        }
        this.id = StringUtils.leftPad((String)this.externalProviderInitializerService.getProviderId(this.getKey()).toString(), (int)8, (String)"f");
    }

    public String getId() {
        if (this.id == null) {
            try {
                this.init();
            }
            catch (RepositoryException e) {
                throw new JahiaRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return this.id;
    }

    public ExternalProviderInitializerService getExternalProviderInitializerService() {
        return this.externalProviderInitializerService;
    }

    public void setExternalProviderInitializerService(ExternalProviderInitializerService mappingService) {
        this.externalProviderInitializerService = mappingService;
    }

    public JCRStoreProvider getExtensionProvider() {
        return this.extendableTypes != null || this.overridableItems != null ? this.externalProviderInitializerService.getExtensionProvider() : null;
    }

    public List<String> getExtendableTypes() {
        return this.extendableTypes;
    }

    public void setExtendableTypes(List<String> extendableTypes) {
        this.extendableTypes = extendableTypes;
    }

    public List<String> getOverridableItems() {
        return this.overridableItems;
    }

    public void setOverridableItems(List<String> overridableItems) {
        this.overridableItems = overridableItems;
    }

    public List<String> getNonOverridableItems() {
        return this.nonOverridableItems;
    }

    public void setNonOverridableItems(List<String> nonOverridableItems) {
        this.nonOverridableItems = nonOverridableItems;
    }

    public List<String> getNonExtendableMixins() {
        return this.nonExtendableMixins;
    }

    public void setNonExtendableMixins(List<String> nonExtendableMixins) {
        this.nonExtendableMixins = nonExtendableMixins;
    }

    public void setLockSupport(boolean lockSupport) {
        this.lockSupport = lockSupport;
    }

    public void setAclSupport(boolean aclSupport) {
        this.aclSupport = aclSupport;
    }

    public boolean isSlowConnection() {
        return this.slowConnection;
    }

    public void setSlowConnection(boolean slowConnection) {
        this.slowConnection = slowConnection;
    }

    public List<String> getReservedNodes() {
        return this.reservedNodes;
    }

    public void setReservedNodes(List<String> reservedNodes) {
        this.reservedNodes = reservedNodes;
    }

    protected String getInternalIdentifier(String externalId) throws RepositoryException {
        return this.getExternalProviderInitializerService().getInternalIdentifier(externalId, this.getKey());
    }

    protected String mapInternalIdentifier(String externalId) throws RepositoryException {
        return this.getExternalProviderInitializerService().mapInternalIdentifier(externalId, this.getKey(), this.getId());
    }

    public String getOrCreateInternalIdentifier(String externalId) throws RepositoryException {
        String internalId = this.getInternalIdentifier(externalId);
        if (internalId == null) {
            internalId = this.mapInternalIdentifier(externalId);
        }
        return internalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyIterator getWeakReferences(JCRNodeWrapper node, String propertyName, Session session) throws RepositoryException {
        if (this.dataSource instanceof ExternalDataSource.Referenceable && session instanceof ExternalSessionImpl) {
            String identifier = node.getIdentifier();
            if (this.equals(node.getProvider())) {
                identifier = ((ExternalNodeImpl)node.getRealNode()).getData().getId();
            }
            ExternalContentStoreProvider.setCurrentSession((ExternalSessionImpl)session);
            List<String> referringProperties = null;
            try {
                referringProperties = ((ExternalDataSource.Referenceable)((Object)this.dataSource)).getReferringProperties(identifier, propertyName);
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
            if (referringProperties == null) {
                return null;
            }
            if (referringProperties.isEmpty()) {
                return PropertyIteratorAdapter.EMPTY;
            }
            ArrayList<ExternalPropertyImpl> l = new ArrayList<ExternalPropertyImpl>();
            for (String propertyPath : referringProperties) {
                ExternalNodeImpl referringNode;
                String nodePath = StringUtils.substringBeforeLast((String)propertyPath, (String)"/");
                if (nodePath.isEmpty()) {
                    nodePath = "/";
                }
                if ((referringNode = (ExternalNodeImpl)session.getNode(nodePath)) == null) continue;
                l.add(new ExternalPropertyImpl(new Name(StringUtils.substringAfterLast((String)propertyPath, (String)"/"), NodeTypeRegistry.getInstance().getNamespaces()), referringNode, (ExternalSessionImpl)session));
            }
            return new PropertyIteratorAdapter(l);
        }
        return null;
    }

    public boolean canExportNode(Node node) {
        try {
            if (node instanceof JCRNodeWrapper) {
                node = ((JCRNodeWrapper)node).getRealNode();
            }
            return "default".equals(node.getSession().getWorkspace().getName()) && (node instanceof ExtensionNode || node instanceof ExternalNodeImpl && ((ExternalNodeImpl)node).getExtensionNode(false) != null);
        }
        catch (RepositoryException e) {
            logger.error("Error while checking if an extension node exists", (Throwable)e);
            return false;
        }
    }

    public boolean canExportProperty(Property property) {
        try {
            if (property instanceof JCRPropertyWrapper) {
                property = ((JCRNodeWrapper)property.getParent()).getRealNode().getProperty(property.getName());
            }
            return "default".equals(property.getSession().getWorkspace().getName()) && ("jcr:primaryType".equals(property.getName()) || "jcr:mixinTypes".equals(property.getName()) || property instanceof ExtensionProperty && !this.ignorePropertiesForExport.contains(property.getName()));
        }
        catch (RepositoryException e) {
            logger.error("Error while checking property name", (Throwable)e);
            return false;
        }
    }

    public boolean isCacheKeyOnReferenceSupport() {
        return this.cacheKeyOnReferenceSupport;
    }

    public void setCacheKeyOnReferenceSupport(boolean cacheKeyOnReferenceSupport) {
        this.cacheKeyOnReferenceSupport = cacheKeyOnReferenceSupport;
    }
}

