/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.jahia.modules.external.ExternalAccessControlManager;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalSessionImpl;

public abstract class ExternalItemImpl
implements Item {
    protected ExternalSessionImpl session;
    protected ExternalAccessControlManager controlManager;
    protected boolean isNew = false;

    public ExternalItemImpl(ExternalSessionImpl session) throws RepositoryException {
        this.session = session;
        this.controlManager = session.getAccessControlManager();
    }

    public ExternalSessionImpl getSession() {
        return this.session;
    }

    protected ExternalContentStoreProvider getStoreProvider() {
        return this.getSession().getRepository().getStoreProvider();
    }

    public boolean isNode() {
        return false;
    }

    void setNew(boolean isNew) throws RepositoryException {
        this.isNew = isNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isSame(Item item) throws RepositoryException {
        return false;
    }

    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (depth == 0) {
            return this.session.getItem("/");
        }
        Matcher matcher = Pattern.compile("(/[^/]+){" + depth + "}").matcher(this.getPath());
        if (matcher.find()) {
            return this.session.getItem(matcher.group(0));
        }
        throw new ItemNotFoundException();
    }

    public int getDepth() throws RepositoryException {
        if (this.getPath().equals("/")) {
            return 0;
        }
        return this.getPath().split("/").length - 1;
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.session.save();
    }

    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
        this.session.refresh(b);
    }

    protected void checkModify() throws RepositoryException {
        this.controlManager.checkModify(this.isNode() ? this.getPath() : this.getParent().getPath());
    }

    protected void checkRead() throws RepositoryException {
        this.controlManager.checkRead(this.isNode() ? this.getPath() : this.getParent().getPath());
    }

    protected void checkAddChildNodes() throws RepositoryException {
        this.controlManager.checkAddChildNodes(this.isNode() ? this.getPath() : this.getParent().getPath());
    }

    protected boolean canManageNodeTypes() throws RepositoryException {
        return this.controlManager.canManageNodeTypes(this.isNode() ? this.getPath() : this.getParent().getPath());
    }

    protected boolean canRemoveNode() throws RepositoryException {
        try {
            this.controlManager.checkRemoveNode(this.isNode() ? this.getPath() : this.getParent().getPath());
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }
}

