/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ChildrenCollectorFilter;
import org.apache.jackrabbit.value.BinaryImpl;
import org.jahia.modules.external.ExtensionNode;
import org.jahia.modules.external.ExtensionProperty;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalData;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalItemImpl;
import org.jahia.modules.external.ExternalPropertyImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalValueImpl;
import org.jahia.modules.external.acl.ExternalDataAce;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.Name;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalNodeImpl
extends ExternalItemImpl
implements Node {
    public static final String MATCH_ALL_PATTERN = "*";
    private static final Logger logger = LoggerFactory.getLogger(ExternalNodeImpl.class);
    private static final String J_TRANSLATION = "j:translation_";
    private ExternalData data;
    private List<String> externalChildren;
    private Map<String, ExternalPropertyImpl> properties = null;
    private String uuid;

    public ExternalNodeImpl(ExternalData data, ExternalSessionImpl session) throws RepositoryException {
        super(session);
        ExtendedPropertyDefinition definition;
        this.data = data;
        this.properties = new HashMap<String, ExternalPropertyImpl>();
        for (Map.Entry<String, String[]> entry : data.getProperties().entrySet()) {
            definition = this.getPropertyDefinition(entry.getKey());
            if (definition != null && definition.getName().equals(MATCH_ALL_PATTERN) && data.getType() != null && data.getType().equals("jnt:translation")) {
                definition = ((ExternalNodeImpl)this.getParent()).getPropertyDefinition(entry.getKey());
            }
            if (definition == null) continue;
            int requiredType = definition.getRequiredType();
            if (definition.isMultiple()) {
                Value[] values = new Value[entry.getValue().length];
                for (int i = 0; i < entry.getValue().length; ++i) {
                    values[i] = session.getValueFactory().createValue(entry.getValue()[i], requiredType);
                }
                this.properties.put(entry.getKey(), new ExternalPropertyImpl(new Name(entry.getKey(), NodeTypeRegistry.getInstance().getNamespaces()), this, session, values));
                continue;
            }
            this.properties.put(entry.getKey(), new ExternalPropertyImpl(new Name(entry.getKey(), NodeTypeRegistry.getInstance().getNamespaces()), this, session, session.getValueFactory().createValue(entry.getValue().length > 0 ? entry.getValue()[0] : null, requiredType)));
        }
        if (data.getBinaryProperties() != null) {
            for (Map.Entry<String, String[]> entry : data.getBinaryProperties().entrySet()) {
                definition = this.getPropertyDefinition(entry.getKey());
                if (definition == null || definition.getRequiredType() != 2) continue;
                if (definition.isMultiple()) {
                    Value[] values = new Value[((Binary[])entry.getValue()).length];
                    for (int i = 0; i < ((Binary[])entry.getValue()).length; ++i) {
                        values[i] = session.getValueFactory().createValue(((Binary[])entry.getValue())[i]);
                    }
                    this.properties.put(entry.getKey(), new ExternalPropertyImpl(new Name(entry.getKey(), NodeTypeRegistry.getInstance().getNamespaces()), this, session, values));
                    continue;
                }
                this.properties.put(entry.getKey(), new ExternalPropertyImpl(new Name(entry.getKey(), NodeTypeRegistry.getInstance().getNamespaces()), this, session, session.getValueFactory().createValue(((Binary[])entry.getValue())[0])));
            }
        }
        this.properties.put("jcr:uuid", new ExternalPropertyImpl(new Name("jcr:uuid", NodeTypeRegistry.getInstance().getNamespaces()), this, session, session.getValueFactory().createValue(this.getIdentifier())));
        this.properties.put("jcr:primaryType", new ExternalPropertyImpl(new Name("jcr:primaryType", NodeTypeRegistry.getInstance().getNamespaces()), this, session, session.getValueFactory().createValue(data.getType(), 7)));
        ExtendedNodeType[] values = this.getMixinNodeTypes();
        if (values.length > 0) {
            ArrayList<ExternalValueImpl> arrayList = new ArrayList<ExternalValueImpl>();
            for (ExtendedNodeType value : values) {
                arrayList.add(session.getValueFactory().createValue(value.getName(), 7));
            }
            this.properties.put("jcr:mixinTypes", new ExternalPropertyImpl(new Name("jcr:mixinTypes", NodeTypeRegistry.getInstance().getNamespaces()), this, session, arrayList.toArray(new Value[arrayList.size()])));
        }
    }

    private NodeDefinition getChildNodeDefinition(String name, String childType) throws RepositoryException {
        Map nodeDefinitionsAsMap = this.getExtendedPrimaryNodeType().getChildNodeDefinitionsAsMap();
        if (nodeDefinitionsAsMap.containsKey(name)) {
            return (NodeDefinition)nodeDefinitionsAsMap.get(name);
        }
        ExtendedNodeType childTypeNT = NodeTypeRegistry.getInstance().getNodeType(childType);
        for (ExtendedNodeType nodeType : this.getMixinNodeTypes()) {
            nodeDefinitionsAsMap = nodeType.getChildNodeDefinitionsAsMap();
            if (nodeDefinitionsAsMap.containsKey(name)) {
                return (NodeDefinition)nodeDefinitionsAsMap.get(name);
            }
            for (Map.Entry entry : nodeType.getUnstructuredChildNodeDefinitions().entrySet()) {
                if (!childTypeNT.isNodeType((String)entry.getKey())) continue;
                return (NodeDefinition)entry.getValue();
            }
        }
        for (Map.Entry entry : this.getExtendedPrimaryNodeType().getUnstructuredChildNodeDefinitions().entrySet()) {
            if (!childTypeNT.isNodeType((String)entry.getKey())) continue;
            return (NodeDefinition)entry.getValue();
        }
        Node extensionNode = this.getExtensionNode(false);
        if (extensionNode != null && extensionNode.isNodeType("jnt:externalProviderExtension")) {
            return extensionNode.getDefinition();
        }
        return null;
    }

    public ExtendedPropertyDefinition getPropertyDefinition(String name) throws RepositoryException {
        Map propertyDefinitionsAsMap = this.getExtendedPrimaryNodeType().getPropertyDefinitionsAsMap();
        if (propertyDefinitionsAsMap.containsKey(name)) {
            return (ExtendedPropertyDefinition)propertyDefinitionsAsMap.get(name);
        }
        for (ExtendedNodeType extendedNodeType : this.getMixinNodeTypes(false)) {
            propertyDefinitionsAsMap = extendedNodeType.getPropertyDefinitionsAsMap();
            if (!propertyDefinitionsAsMap.containsKey(name)) continue;
            return (ExtendedPropertyDefinition)propertyDefinitionsAsMap.get(name);
        }
        if (this.getExtensionNode(false) != null) {
            for (ExtendedNodeType extendedNodeType : this.getExtensionNode(false).getMixinNodeTypes()) {
                ExtendedNodeType extendedNodeType2 = NodeTypeRegistry.getInstance().getNodeType(extendedNodeType.getName());
                propertyDefinitionsAsMap = extendedNodeType2.getPropertyDefinitionsAsMap();
                if (!propertyDefinitionsAsMap.containsKey(name)) continue;
                return (ExtendedPropertyDefinition)propertyDefinitionsAsMap.get(name);
            }
        }
        if (!this.getExtendedPrimaryNodeType().getUnstructuredPropertyDefinitions().isEmpty()) {
            return (ExtendedPropertyDefinition)this.getExtendedPrimaryNodeType().getUnstructuredPropertyDefinitions().values().iterator().next();
        }
        return null;
    }

    public ExternalData getData() {
        return this.data;
    }

    public String getPath() throws RepositoryException {
        return this.data.getPath();
    }

    public String getName() throws RepositoryException {
        return this.data.getName();
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        if (this.data.getPath().equals("/")) {
            throw new ItemNotFoundException();
        }
        String path = StringUtils.substringBeforeLast((String)this.data.getPath(), (String)"/");
        try {
            this.controlManager.checkRead(path.isEmpty() ? "/" : path);
        }
        catch (PathNotFoundException e) {
            throw new AccessDeniedException(path);
        }
        return this.session.getNode(path.isEmpty() ? "/" : path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getExternalChildren() throws RepositoryException {
        if (this.externalChildren == null) {
            if (this.isNew) {
                this.externalChildren = new ArrayList<String>();
            } else {
                ExternalContentStoreProvider.setCurrentSession(this.session);
                try {
                    ExternalDataSource dataSource = this.session.getRepository().getDataSource();
                    if (dataSource instanceof ExternalDataSource.CanLoadChildrenInBatch) {
                        ExternalDataSource.CanLoadChildrenInBatch childrenLoader = (ExternalDataSource.CanLoadChildrenInBatch)((Object)dataSource);
                        List<ExternalData> childrenNodes = childrenLoader.getChildrenNodes(this.getPath());
                        if (this.externalChildren == null) {
                            this.externalChildren = new ArrayList<String>(childrenNodes.size());
                        }
                        for (ExternalData child : childrenNodes) {
                            String parentPath = StringUtils.substringBeforeLast((String)child.getPath(), (String)"/");
                            if (parentPath.equals("")) {
                                parentPath = "/";
                            }
                            if (parentPath.equals(this.getPath())) {
                                this.externalChildren.add(child.getName());
                            }
                            ExternalNodeImpl node = new ExternalNodeImpl(child, this.session);
                            this.session.registerNode(node);
                        }
                    } else {
                        this.externalChildren = new ArrayList<String>(dataSource.getChildren(this.getPath()));
                    }
                }
                finally {
                    ExternalContentStoreProvider.removeCurrentSession();
                }
            }
        }
        return this.externalChildren;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    void setNew(boolean isNew) throws RepositoryException {
        super.setNew(isNew);
        if (!isNew) {
            if (!this.data.getTmpId().equals(this.data.getId())) {
                this.getSession().getRepository().getStoreProvider().getExternalProviderInitializerService().updateExternalIdentifier(this.data.getTmpId(), this.data.getId(), this.getSession().getRepository().getProviderKey(), false);
            }
            this.data.markSaved();
        }
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (!this.canRemoveNode()) {
            throw new AccessDeniedException(this.getPath());
        }
        if (!this.data.getPath().equals("/")) {
            ((ExternalNodeImpl)this.getParent()).getExternalChildren().remove(this.getName());
        }
        this.session.getDeletedData().put(this.getPath(), this.data);
        this.session.unregisterNode(this);
        Node extensionNode = this.getExtensionNode(false);
        if (extensionNode != null) {
            extensionNode.remove();
        }
    }

    protected void removeProperty(String name) throws RepositoryException {
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        this.checkModify();
        boolean hasProperty = false;
        if (this.data.getBinaryProperties() != null && this.data.getBinaryProperties().containsKey(name)) {
            hasProperty = true;
            this.data.getBinaryProperties().remove(name);
            this.properties.remove(name);
        }
        if (this.data.getProperties() != null && this.data.getProperties().containsKey(name)) {
            hasProperty = true;
            this.data.getProperties().remove(name);
            this.properties.remove(name);
        }
        if (this.data.getLazyBinaryProperties() != null && this.data.getLazyBinaryProperties().contains(name)) {
            hasProperty = true;
            this.data.getLazyBinaryProperties().remove(name);
        }
        if (this.data.getLazyProperties() != null && this.data.getLazyProperties().contains(name)) {
            hasProperty = true;
            this.data.getLazyProperties().remove(name);
        }
        if (hasProperty) {
            this.session.getChangedData().put(this.getPath(), this.data);
        }
    }

    public Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, null);
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        this.checkAddChildNodes();
        if (this.canItemBeExtended(relPath, primaryNodeTypeName)) {
            if ((StringUtils.equals((String)primaryNodeTypeName, (String)"jnt:acl") || StringUtils.equals((String)primaryNodeTypeName, (String)"jnt:ace")) && (this.session.getRepository().getDataSource() instanceof ExternalDataSource.AccessControllable || this.session.getRepository().getDataSource() instanceof ExternalDataSource.SupportPrivileges)) {
                throw new UnsupportedRepositoryOperationException("Acl and Ace are handle by DataSource");
            }
            Node extendedNode = this.getExtensionNode(true);
            if (extendedNode != null) {
                Node n = extendedNode.addNode(relPath, primaryNodeTypeName);
                n.addMixin("jmix:externalProviderExtension");
                List<Value> values = ExtensionNode.createNodeTypeValues(this.session.getValueFactory(), primaryNodeTypeName);
                n.setProperty("j:extendedType", values.toArray(new Value[values.size()]));
                n.setProperty("j:isExternalProviderRoot", false);
                String localPath = (this.getPath().equals("/") ? "/" : this.getPath() + "/") + relPath;
                return new ExtensionNode(n, localPath, this.getSession());
            }
        }
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        String separator = StringUtils.equals((String)this.data.getId(), (String)"/") ? "" : "/";
        ExternalData subNodeData = new ExternalData(this.data.getId() + separator + relPath, this.getPath() + (this.getPath().equals("/") ? "" : "/") + relPath, primaryNodeTypeName, new HashMap<String, String[]>(), true);
        ExternalNodeImpl newNode = new ExternalNodeImpl(subNodeData, this.session);
        this.session.registerNode(newNode);
        this.session.getChangedData().put(subNodeData.getPath(), subNodeData);
        this.session.setNewItem(newNode);
        this.getExternalChildren().add(relPath);
        return newNode;
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        if (srcChildRelPath.equals(destChildRelPath)) {
            return;
        }
        List<String> children = this.getExternalChildren();
        children.remove(srcChildRelPath);
        if (destChildRelPath == null || !children.contains(destChildRelPath)) {
            children.add(srcChildRelPath);
        } else {
            children.add(children.indexOf(destChildRelPath), srcChildRelPath);
        }
        this.session.getOrderedData().put(this.getPath(), children);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Node extensionNode;
        this.checkModify();
        if (this.canItemBeExtended((ItemDefinition)this.getPropertyDefinition(name)) && (extensionNode = this.getExtensionNode(true)) != null) {
            return new ExtensionProperty(extensionNode.setProperty(name, value), this.getPath() + "/" + name, this.session, this);
        }
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (value == null) {
            if (this.hasProperty(name)) {
                this.removeProperty(name);
            }
            return null;
        }
        ExtendedPropertyDefinition epd = this.getPropertyDefinition(name);
        if (!this.hasProperty(name) || this.hasProperty(name) && !this.getProperty(name).getValue().equals(value)) {
            if (epd.getRequiredType() == 2) {
                if (this.data.getBinaryProperties() == null) {
                    this.data.setBinaryProperties(new HashMap<String, Binary[]>());
                }
                this.data.getBinaryProperties().put(name, new Binary[]{value.getBinary()});
            } else {
                this.data.getProperties().put(name, new String[]{value.getString()});
            }
            ExternalPropertyImpl newProperty = new ExternalPropertyImpl(new Name(name, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, value);
            this.properties.put(name, newProperty);
            this.session.setNewItem(newProperty);
            this.session.getChangedData().put(this.getPath(), this.data);
        }
        return this.getProperty(name);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, value);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Node extensionNode;
        this.checkModify();
        if (this.canItemBeExtended((ItemDefinition)this.getPropertyDefinition(name)) && (extensionNode = this.getExtensionNode(true)) != null) {
            return new ExtensionProperty(extensionNode.setProperty(name, values), this.getPath() + "/" + name, this.session, this);
        }
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (values == null) {
            if (this.hasProperty(name)) {
                this.removeProperty(name);
            }
            return null;
        }
        ExtendedPropertyDefinition epd = this.getPropertyDefinition(name);
        if (!this.hasProperty(name) || this.hasProperty(name) && !Arrays.equals(this.getProperty(name).getValues(), values)) {
            if (epd.getRequiredType() == 2) {
                if (this.data.getBinaryProperties() == null) {
                    this.data.setBinaryProperties(new HashMap<String, Binary[]>());
                }
                Binary[] b = new Binary[values.length];
                for (int i = 0; i < values.length; ++i) {
                    b[i] = values[i] != null ? values[i].getBinary() : null;
                }
                this.data.getBinaryProperties().put(name, b);
            } else {
                String[] s = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    s[i] = values[i] != null ? values[i].getString() : null;
                }
                this.data.getProperties().put(name, s);
            }
            ExternalPropertyImpl newProperty = new ExternalPropertyImpl(new Name(name, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, values);
            this.properties.put(name, newProperty);
            this.session.setNewItem(newProperty);
            this.session.getChangedData().put(this.getPath(), this.data);
        }
        return this.getProperty(name);
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] v = null;
        if (values != null) {
            v = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                v[i] = values[i] != null ? this.getSession().getValueFactory().createValue(values[i]) : null;
            }
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, values);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.setProperty(name, value);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Node extensionNode;
        this.checkModify();
        if (this.canItemBeExtended((ItemDefinition)this.getPropertyDefinition(name)) && (extensionNode = this.getExtensionNode(true)) != null) {
            return new ExtensionProperty(extensionNode.setProperty(name, value), this.getPath() + "/" + name, this.session, this);
        }
        if (!(this.session.getRepository().getDataSource() instanceof ExternalDataSource.Writable)) {
            throw new UnsupportedRepositoryOperationException();
        }
        if (value == null) {
            if (this.hasProperty(name)) {
                this.removeProperty(name);
            }
            return null;
        }
        ExternalValueImpl v = null;
        BinaryImpl binary = null;
        try {
            binary = new BinaryImpl(value);
            Binary[] b = new Binary[]{binary};
            if (this.data.getBinaryProperties() == null) {
                this.data.setBinaryProperties(new HashMap<String, Binary[]>());
            }
            this.data.getBinaryProperties().put(name, b);
            v = this.getSession().getValueFactory().createValue((Binary)binary);
            this.session.registerTemporaryBinary((Binary)binary);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = this.getSession().getValueFactory().createValue(value);
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public Node getNode(String s) throws RepositoryException {
        Node n = this.session.getNode(this.getPath().endsWith("/") ? this.getPath() + s : this.getPath() + "/" + s);
        if (n != null) {
            return n;
        }
        n = this.getExtensionNode(false);
        if (n != null) {
            return new ExtensionNode(n.getNode(s), this.getPath() + "/" + s, this.getSession());
        }
        throw new PathNotFoundException();
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodes(MATCH_ALL_PATTERN);
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        Node node;
        ArrayList<String> filteredList = new ArrayList<String>();
        boolean matchAll = MATCH_ALL_PATTERN.equals(namePattern);
        ExternalDataSource dataSource = this.session.getRepository().getDataSource();
        if ("j:acl".equals(this.data.getName()) && "jnt:acl".equals(this.data.getType()) && this.data.getId().startsWith("j:acl") && dataSource instanceof ExternalDataSource.AccessControllable) {
            ExternalNodeImpl parent = (ExternalNodeImpl)this.getParent();
            if (parent.data.getExternalDataAcl() != null && parent.data.getExternalDataAcl().getAcl() != null && parent.data.getExternalDataAcl().getAcl().size() > 0) {
                for (ExternalDataAce externalDataAce : parent.data.getExternalDataAcl().getAcl()) {
                    String aceNodeName = externalDataAce.toString();
                    if (!matchAll && !ChildrenCollectorFilter.matches((String)aceNodeName, (String)namePattern)) continue;
                    filteredList.add(aceNodeName);
                }
            }
            return new ExternalNodeIterator(filteredList);
        }
        List<String> externalChildren = this.getExternalChildren();
        if (!externalChildren.isEmpty() && !namePattern.equals("j:translation*")) {
            if (!matchAll) {
                for (String string : externalChildren) {
                    if (!ChildrenCollectorFilter.matches((String)string, (String)namePattern)) continue;
                    filteredList.add(string);
                }
            } else {
                filteredList.addAll(externalChildren);
            }
        }
        HashSet<String> languages = new HashSet<String>();
        if (this.data.getI18nProperties() != null) {
            languages.addAll(this.data.getI18nProperties().keySet());
        }
        if (this.data.getLazyI18nProperties() != null) {
            languages.addAll(this.data.getLazyI18nProperties().keySet());
        }
        for (String lang : languages) {
            if (!matchAll && !ChildrenCollectorFilter.matches((String)(J_TRANSLATION + lang), (String)namePattern)) continue;
            filteredList.add(J_TRANSLATION + lang);
        }
        if (this.data.getExternalDataAcl() != null && dataSource instanceof ExternalDataSource.AccessControllable && (matchAll || ChildrenCollectorFilter.matches((String)"j:acl", (String)namePattern))) {
            filteredList.add("j:acl");
        }
        if ((node = this.getExtensionNode(false)) != null) {
            return new ExternalNodeIterator(filteredList, matchAll ? node.getNodes() : node.getNodes(namePattern));
        }
        return new ExternalNodeIterator(filteredList);
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        Node node;
        ArrayList<String> filteredList = new ArrayList<String>();
        ExternalDataSource dataSource = this.session.getRepository().getDataSource();
        if ("j:acl".equals(this.data.getName()) && "jnt:acl".equals(this.data.getType()) && this.data.getId().startsWith("j:acl") && dataSource instanceof ExternalDataSource.AccessControllable) {
            ExternalNodeImpl parent = (ExternalNodeImpl)this.getParent();
            if (parent.data.getExternalDataAcl() != null && parent.data.getExternalDataAcl().getAcl() != null && parent.data.getExternalDataAcl().getAcl().size() > 0) {
                for (ExternalDataAce ace : parent.data.getExternalDataAcl().getAcl()) {
                    String aceNodeName = ace.toString();
                    if (!ChildrenCollectorFilter.matches((String)aceNodeName, (String[])nameGlobs)) continue;
                    filteredList.add(aceNodeName);
                }
            }
            return new ExternalNodeIterator(filteredList);
        }
        for (String string : this.getExternalChildren()) {
            if (!ChildrenCollectorFilter.matches((String)string, (String[])nameGlobs)) continue;
            filteredList.add(string);
        }
        HashSet<String> languages = new HashSet<String>();
        if (this.data.getI18nProperties() != null) {
            languages.addAll(this.data.getI18nProperties().keySet());
        }
        if (this.data.getLazyI18nProperties() != null) {
            languages.addAll(this.data.getLazyI18nProperties().keySet());
        }
        for (String lang : languages) {
            if (!ChildrenCollectorFilter.matches((String)(J_TRANSLATION + lang), (String[])nameGlobs)) continue;
            filteredList.add(J_TRANSLATION + lang);
        }
        if (this.data.getExternalDataAcl() != null && dataSource instanceof ExternalDataSource.AccessControllable && ChildrenCollectorFilter.matches((String)"j:acl", (String[])nameGlobs)) {
            filteredList.add("j:acl");
        }
        if ((node = this.getExtensionNode(false)) != null) {
            return new ExternalNodeIterator(filteredList, node.getNodes(nameGlobs));
        }
        return new ExternalNodeIterator(filteredList);
    }

    public Property getProperty(String s) throws PathNotFoundException, RepositoryException {
        Node n = this.getExtensionNode(false);
        if (n != null && n.hasProperty(s) && this.getPropertyDefinition(s) != null && this.canItemBeExtended((ItemDefinition)this.getPropertyDefinition(s))) {
            return new ExtensionProperty(n.getProperty(s), this.getPath() + "/" + s, this.session, this);
        }
        Property property = this.properties.get(s);
        if (property == null) {
            if (this.data.getLazyProperties() != null && this.data.getLazyProperties().contains(s)) {
                ExternalPropertyImpl p;
                String[] values = this.properties.containsKey("jcr:language") ? this.session.getI18nPropertyValues(this.data, this.properties.get("jcr:language").getString(), s) : this.session.getPropertyValues(this.data, s);
                this.data.getProperties().put(s, values);
                this.data.getLazyProperties().remove(s);
                ExtendedPropertyDefinition definition = this.getPropertyDefinition(s);
                if (definition != null && definition.getName().equals(MATCH_ALL_PATTERN) && this.data != null && this.data.getType() != null && this.data.getType().equals("jnt:translation")) {
                    definition = ((ExternalNodeImpl)this.getParent()).getPropertyDefinition(s);
                }
                if (definition != null && definition.isMultiple()) {
                    Value[] jcrValues = null;
                    if (values != null) {
                        jcrValues = new Value[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            jcrValues[i] = values[i] != null ? this.session.getValueFactory().createValue(values[i], definition.getRequiredType()) : null;
                        }
                    }
                    p = new ExternalPropertyImpl(new Name(s, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, jcrValues);
                } else {
                    ExternalValueImpl jcrValue = null;
                    if (values != null && values.length > 0) {
                        jcrValue = this.session.getValueFactory().createValue(values[0], definition.getRequiredType());
                    }
                    p = new ExternalPropertyImpl(new Name(s, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, jcrValue);
                }
                this.properties.put(s, p);
                return p;
            }
            if (this.data.getLazyBinaryProperties() != null && this.data.getLazyBinaryProperties().contains(s)) {
                ExternalPropertyImpl p;
                Binary[] values = this.session.getBinaryPropertyValues(this.data, s);
                this.data.getBinaryProperties().put(s, values);
                this.data.getLazyBinaryProperties().remove(s);
                ExtendedPropertyDefinition definition = this.getPropertyDefinition(s);
                if (definition != null && definition.isMultiple()) {
                    Value[] jcrValues = null;
                    if (values != null) {
                        jcrValues = new Value[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            jcrValues[i] = values[i] != null ? this.session.getValueFactory().createValue(values[i]) : null;
                        }
                    }
                    p = new ExternalPropertyImpl(new Name(s, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, jcrValues);
                } else {
                    ExternalValueImpl jcrValue = null;
                    if (values != null && values.length > 0) {
                        jcrValue = this.session.getValueFactory().createValue(values[0]);
                    }
                    p = new ExternalPropertyImpl(new Name(s, NodeTypeRegistry.getInstance().getNamespaces()), this, this.session, jcrValue);
                }
                this.properties.put(s, p);
                return p;
            }
            throw new PathNotFoundException(s);
        }
        return property;
    }

    public PropertyIterator getProperties() throws RepositoryException {
        Node n = this.getExtensionNode(false);
        if (n != null) {
            return new ExternalPropertyIterator(this.properties, n.getProperties(), this.data.getLazyProperties(), this.data.getLazyBinaryProperties(), this);
        }
        return new ExternalPropertyIterator(this.properties, this.data.getLazyProperties(), this.data.getLazyBinaryProperties(), this);
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        Node node;
        HashMap<String, ExternalPropertyImpl> filteredList = new HashMap<String, ExternalPropertyImpl>();
        for (Map.Entry<String, ExternalPropertyImpl> entry : this.properties.entrySet()) {
            if (!ChildrenCollectorFilter.matches((String)entry.getKey(), (String)namePattern)) continue;
            filteredList.put(entry.getKey(), entry.getValue());
        }
        HashSet<String> lazyProperties = null;
        if (this.data.getLazyProperties() != null) {
            lazyProperties = new HashSet<String>();
            for (String string : this.data.getLazyProperties()) {
                if (!ChildrenCollectorFilter.matches((String)string, (String)namePattern)) continue;
                lazyProperties.add(string);
            }
        }
        HashSet<String> lazyBinaryProperties = null;
        if (this.data.getLazyBinaryProperties() != null) {
            lazyBinaryProperties = new HashSet<String>();
            for (String propertyName : this.data.getLazyBinaryProperties()) {
                if (!ChildrenCollectorFilter.matches((String)propertyName, (String)namePattern)) continue;
                lazyBinaryProperties.add(propertyName);
            }
        }
        if ((node = this.getExtensionNode(false)) != null) {
            return new ExternalPropertyIterator(filteredList, node.getProperties(namePattern), lazyProperties, lazyBinaryProperties, this);
        }
        return new ExternalPropertyIterator(filteredList, lazyProperties, lazyBinaryProperties, this);
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException("External node does not support getPrimaryItem");
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getIdentifier();
    }

    public int getIndex() throws RepositoryException {
        return 1;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean hasNode(String s) throws RepositoryException {
        return this.session.itemExists(this.getPath().endsWith("/") ? this.getPath() + s : this.getPath() + "/" + s);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.properties.containsKey(relPath) || this.data.getLazyProperties() != null && this.data.getLazyProperties().contains(relPath) || this.data.getLazyBinaryProperties() != null && this.data.getLazyBinaryProperties().contains(relPath) || this.getExtensionNode(false) != null && this.getPropertyDefinition(relPath) != null && this.canItemBeExtended((ItemDefinition)this.getPropertyDefinition(relPath)) && this.getExtensionNode(false).hasProperty(relPath);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    public boolean hasProperties() throws RepositoryException {
        return !this.properties.isEmpty() || this.data.getLazyProperties() != null && !this.data.getLazyProperties().isEmpty() || this.data.getLazyBinaryProperties() != null && !this.data.getLazyBinaryProperties().isEmpty() || this.getProperties().hasNext();
    }

    public ExtendedNodeType getPrimaryNodeType() throws RepositoryException {
        return this.getExtendedPrimaryNodeType();
    }

    public ExtendedNodeType getExtendedPrimaryNodeType() throws RepositoryException {
        return NodeTypeRegistry.getInstance().getNodeType(this.data.getType());
    }

    public ExtendedNodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.getMixinNodeTypes(true);
    }

    private ExtendedNodeType[] getMixinNodeTypes(boolean withExtension) throws RepositoryException {
        Node extensionNode;
        ArrayList<ExtendedNodeType> nt = new ArrayList<ExtendedNodeType>();
        if (this.data.getMixin() != null) {
            for (String s : this.data.getMixin()) {
                nt.add(NodeTypeRegistry.getInstance().getNodeType(s));
            }
        }
        if (this.data.getExternalDataAcl() != null && this.data.getExternalDataAcl().getAcl().size() > 0 && this.session.getRepository().getDataSource() instanceof ExternalDataSource.AccessControllable) {
            nt.add(NodeTypeRegistry.getInstance().getNodeType("jmix:accessControlled"));
        }
        if (withExtension && (extensionNode = this.getExtensionNode(false)) != null) {
            for (NodeType type : extensionNode.getMixinNodeTypes()) {
                if (type.isNodeType("jmix:externalProviderExtension")) continue;
                nt.add(NodeTypeRegistry.getInstance().getNodeType(type.getName()));
            }
        }
        return nt.toArray(new ExtendedNodeType[nt.size()]);
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(nodeTypeName, true);
    }

    public boolean isNodeType(String nodeTypeName, boolean withExtension) throws RepositoryException {
        if (this.getPrimaryNodeType().isNodeType(nodeTypeName)) {
            return true;
        }
        for (ExtendedNodeType nodeType : this.getMixinNodeTypes(withExtension)) {
            if (!nodeType.isNodeType(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (this.isNodeType(mixinName) || !this.canManageNodeTypes()) {
            return;
        }
        if (this.isExtensionForbiddenMixin(mixinName) && (this.data.getMixin() == null || !this.data.getMixin().contains(mixinName))) {
            ArrayList<String> mixins = this.data.getMixin() == null ? new ArrayList<String>() : new ArrayList<String>(this.data.getMixin());
            mixins.add(mixinName);
            this.data.setMixin(mixins);
            return;
        }
        Node extensionNode = this.getExtensionNode(true);
        if (extensionNode != null) {
            extensionNode.addMixin(mixinName);
            return;
        }
        throw new UnsupportedRepositoryOperationException();
    }

    protected boolean isExtensionForbiddenMixin(String mixinName) throws RepositoryException {
        return this.getSession().getExtensionForbiddenMixins().contains(mixinName) || this.getSession().getExtensionForbiddenMixins().contains(MATCH_ALL_PATTERN);
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!this.canManageNodeTypes()) {
            return;
        }
        if (this.isExtensionForbiddenMixin(mixinName) && this.data.getMixin() != null && this.data.getMixin().contains(mixinName)) {
            ArrayList<String> mixins = new ArrayList<String>(this.data.getMixin());
            mixins.remove(mixinName);
            this.data.setMixin(mixins);
            return;
        }
        Node extensionNode = this.getExtensionNode(false);
        if (extensionNode != null) {
            extensionNode.removeMixin(mixinName);
            PropertyIterator pi = this.getProperties();
            while (pi.hasNext()) {
                Property extensionProperty = pi.nextProperty();
                ArrayList<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();
                nodeTypes.addAll(Arrays.asList(this.getMixinNodeTypes(true)));
                nodeTypes.add(NodeTypeRegistry.getInstance().getNodeType("jmix:externalProviderExtension"));
                boolean canSetProperty = extensionProperty.isMultiple() ? this.getPrimaryNodeType().canSetProperty(extensionProperty.getName(), extensionProperty.getValues()) : this.getPrimaryNodeType().canSetProperty(extensionProperty.getName(), extensionProperty.getValue());
                for (ExtendedNodeType extendedNodeType : this.getPrimaryNodeType().getPropertyDefinitions()) {
                    if (!extendedNodeType.getName().equals(extensionProperty.getName()) || extendedNodeType.getRequiredType() != extensionProperty.getType()) continue;
                    canSetProperty = true;
                    break;
                }
                if (canSetProperty) continue;
                for (NodeType nodeType : nodeTypes) {
                    if (StringUtils.equals((String)nodeType.getName(), (String)mixinName)) continue;
                    if (extensionProperty.isMultiple()) {
                        if (!nodeType.canSetProperty(extensionProperty.getName(), extensionProperty.getValues())) continue;
                        canSetProperty = true;
                        break;
                    }
                    if (!nodeType.canSetProperty(extensionProperty.getName(), extensionProperty.getValue())) continue;
                    canSetProperty = true;
                    break;
                }
                if (canSetProperty) continue;
                extensionProperty.remove();
            }
            NodeIterator ni = extensionNode.getNodes();
            while (ni.hasNext()) {
                Node extensionChildNode = ni.nextNode();
                boolean canAddChildNode = this.getPrimaryNodeType().canAddChildNode(extensionChildNode.getName(), this.getPrimaryNodeType().getName());
                if (canAddChildNode) continue;
                for (ExtendedNodeType extendedNodeType : this.getMixinNodeTypes(true)) {
                    if (StringUtils.equals((String)extendedNodeType.getName(), (String)mixinName) || !extendedNodeType.canAddChildNode(extensionChildNode.getName(), this.getPrimaryNodeType().getName())) continue;
                    canAddChildNode = true;
                    break;
                }
                if (canAddChildNode) continue;
                extensionChildNode.remove();
            }
            return;
        }
        if (!this.isNodeType(mixinName)) {
            throw new NoSuchNodeTypeException("Mixin " + mixinName + " not included in node " + this.getPath());
        }
        throw new UnsupportedRepositoryOperationException();
    }

    public boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        if (this.isExtensionForbiddenMixin(mixinName) && this.canManageNodeTypes()) {
            return true;
        }
        Node extensionNode = this.getExtensionNode(true);
        return extensionNode != null && extensionNode.canAddMixin(mixinName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        ExternalNodeImpl parentNode;
        try {
            parentNode = (ExternalNodeImpl)this.getParent();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        ExtendedNodeType parentNodeType = parentNode.getExtendedPrimaryNodeType();
        ExtendedNodeDefinition nodeDefinition = (ExtendedNodeDefinition)parentNodeType.getChildNodeDefinitionsAsMap().get(this.getName());
        if (nodeDefinition != null) {
            return nodeDefinition;
        }
        for (Map.Entry entry : parentNodeType.getUnstructuredChildNodeDefinitions().entrySet()) {
            if (!this.isNodeType((String)entry.getKey())) continue;
            return (NodeDefinition)entry.getValue();
        }
        return null;
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void update(String s) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator merge(String s, boolean b) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return this.getPath();
    }

    public boolean isCheckedOut() throws RepositoryException {
        return true;
    }

    public void restore(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restore(Version version, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restore(Version version, String s, boolean b) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restoreByLabel(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Lock lock(boolean b, boolean b1) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.session.getWorkspace().getLockManager().lock(this.getPath(), b, b1, Long.MAX_VALUE, null);
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.session.getWorkspace().getLockManager() != null ? this.session.getWorkspace().getLockManager().getLock(this.getPath()) : null;
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (this.session.getWorkspace().getLockManager() != null) {
            this.session.getWorkspace().getLockManager().unlock(this.getPath());
        }
    }

    public boolean holdsLock() throws RepositoryException {
        return this.session.getWorkspace().getLockManager() != null && this.session.getWorkspace().getLockManager().getLock(this.getPath()) != null;
    }

    public boolean isLocked() throws RepositoryException {
        return this.session.getWorkspace().getLockManager() != null && this.session.getWorkspace().getLockManager().isLocked(this.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property setProperty(String name, Binary value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value v = null;
        if (value != null) {
            InputStream stream = value.getStream();
            try {
                Property property = this.setProperty(name, stream);
                return property;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return this.setProperty(name, v);
    }

    public Property setProperty(String name, BigDecimal value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ExternalValueImpl v = null;
        if (value != null) {
            v = this.getSession().getValueFactory().createValue(value);
        }
        return this.setProperty(name, v);
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        Node node;
        HashMap<String, ExternalPropertyImpl> filteredList = new HashMap<String, ExternalPropertyImpl>();
        for (Map.Entry<String, ExternalPropertyImpl> entry : this.properties.entrySet()) {
            if (!ChildrenCollectorFilter.matches((String)entry.getKey(), (String[])nameGlobs)) continue;
            filteredList.put(entry.getKey(), entry.getValue());
        }
        HashSet<String> lazyProperties = null;
        if (this.data.getLazyProperties() != null) {
            lazyProperties = new HashSet<String>();
            for (String string : this.data.getLazyProperties()) {
                if (!ChildrenCollectorFilter.matches((String)string, (String[])nameGlobs)) continue;
                lazyProperties.add(string);
            }
        }
        HashSet<String> lazyBinaryProperties = null;
        if (this.data.getLazyBinaryProperties() != null) {
            lazyBinaryProperties = new HashSet<String>();
            for (String propertyName : this.data.getLazyBinaryProperties()) {
                if (!ChildrenCollectorFilter.matches((String)propertyName, (String[])nameGlobs)) continue;
                lazyBinaryProperties.add(propertyName);
            }
        }
        if ((node = this.getExtensionNode(false)) != null) {
            return new ExternalPropertyIterator(filteredList, node.getProperties(nameGlobs), lazyProperties, lazyBinaryProperties, this);
        }
        return new ExternalPropertyIterator(filteredList, lazyProperties, lazyBinaryProperties, this);
    }

    public final String getIdentifier() throws RepositoryException {
        if (this.uuid == null) {
            this.uuid = !this.session.getRepository().getDataSource().isSupportsUuid() || this.data.getId().startsWith("translation:") ? this.getStoreProvider().getOrCreateInternalIdentifier(this.data.getId()) : this.data.getId();
        }
        return this.uuid;
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        return new ExternalNodeIterator(new ArrayList<String>());
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new String[0];
    }

    public Node getExtensionNode(boolean create) throws RepositoryException {
        Session extensionSession = this.getSession().getExtensionSession();
        if (extensionSession == null) {
            return null;
        }
        List<String> extensionAllowedTypes = this.getSession().getExtensionAllowedTypes();
        boolean allowed = false;
        if (extensionAllowedTypes != null) {
            for (String type : extensionAllowedTypes) {
                if (!this.isNodeType(type, false)) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            return null;
        }
        String path = this.getPath();
        boolean isRoot = path.equals("/");
        String mountPointPath = this.getStoreProvider().getMountPoint();
        String globalPath = mountPointPath + (isRoot ? "" : path);
        if (!extensionSession.itemExists(globalPath)) {
            if (!create) {
                return null;
            }
            String[] pathElements = StringUtils.split((String)path, (String)"/");
            StringBuilder currentExtensionPath = new StringBuilder(mountPointPath);
            StringBuilder currentExternalPath = new StringBuilder();
            if (!extensionSession.nodeExists(mountPointPath)) {
                String parentPath = StringUtils.substringBeforeLast((String)mountPointPath, (String)"/");
                if (parentPath.equals("")) {
                    parentPath = "/";
                }
                Node extensionParent = extensionSession.getNode(parentPath);
                this.takeLockToken(extensionParent);
                extensionParent.addMixin("jmix:hasExternalProviderExtension");
                Node extensionNode = extensionParent.addNode(StringUtils.substringAfterLast((String)mountPointPath, (String)"/"), "jnt:externalProviderExtension");
                extensionNode.addMixin("jmix:externalProviderExtension");
                extensionNode.setProperty("j:isExternalProviderRoot", true);
                Node externalNode = (Node)this.session.getItemWithNoCheck("/");
                extensionNode.setProperty("j:externalNodeIdentifier", externalNode.getIdentifier());
                List<Value> values = ExtensionNode.createNodeTypeValues(this.session.getValueFactory(), externalNode.getPrimaryNodeType().getName());
                extensionNode.setProperty("j:extendedType", values.toArray(new Value[values.size()]));
            }
            for (String pathElement : pathElements) {
                currentExtensionPath.append("/").append(pathElement);
                currentExternalPath.append("/").append(pathElement);
                if (extensionSession.nodeExists(currentExtensionPath.toString())) continue;
                Node extensionParent = extensionSession.getNode(StringUtils.substringBeforeLast((String)currentExtensionPath.toString(), (String)"/"));
                this.takeLockToken(extensionParent);
                extensionParent.addMixin("jmix:hasExternalProviderExtension");
                Node extensionNode = extensionParent.addNode(pathElement, "jnt:externalProviderExtension");
                Node externalNode = (Node)this.session.getItemWithNoCheck(currentExternalPath.toString());
                List<Value> values = ExtensionNode.createNodeTypeValues(this.session.getValueFactory(), externalNode.getPrimaryNodeType().getName());
                extensionNode.setProperty("j:extendedType", values.toArray(new Value[values.size()]));
                extensionNode.addMixin("jmix:externalProviderExtension");
                extensionNode.setProperty("j:isExternalProviderRoot", false);
                extensionNode.setProperty("j:externalNodeIdentifier", externalNode.getIdentifier());
            }
        }
        Node extensionNode = extensionSession.getNode(globalPath);
        if (create && isRoot && !extensionNode.isNodeType("jmix:hasExternalProviderExtension")) {
            extensionNode.addMixin("jmix:hasExternalProviderExtension");
        }
        if (!extensionNode.isNodeType("jmix:externalProviderExtension")) {
            extensionNode.addMixin("jmix:externalProviderExtension");
        }
        return extensionNode;
    }

    public void takeLockToken(Node parentNode) throws RepositoryException {
        if (parentNode.isLocked() && parentNode.hasProperty("j:locktoken")) {
            parentNode.getSession().addLockToken(parentNode.getProperty("j:locktoken").getString());
        }
    }

    public boolean canItemBeExtended(String relPath, String primaryNodeTypeName) throws RepositoryException {
        return this.canItemBeExtended((ItemDefinition)this.getChildNodeDefinition(relPath, primaryNodeTypeName));
    }

    public boolean canItemBeExtended(ItemDefinition definition) throws RepositoryException {
        Node ext;
        if (definition == null) {
            throw new ConstraintViolationException();
        }
        NodeType type = definition.getDeclaringNodeType();
        Map<String, List<String>> overridableProperties = this.getSession().getOverridableProperties();
        Map<String, List<String>> nonOverridableProperties = this.getSession().getNonOverridableProperties();
        for (Map.Entry<String, List<String>> entry : overridableProperties.entrySet()) {
            if (!entry.getKey().equals(MATCH_ALL_PATTERN) && !type.getName().equals(entry.getKey()) || !entry.getValue().contains(MATCH_ALL_PATTERN) && !entry.getValue().contains(definition.getName()) || nonOverridableProperties.containsKey(MATCH_ALL_PATTERN) && nonOverridableProperties.get(MATCH_ALL_PATTERN).contains(definition.getName()) || nonOverridableProperties.containsKey(type.getName()) && nonOverridableProperties.get(type.getName()).contains(definition.getName())) continue;
            return true;
        }
        if (type.isMixin() && (ext = this.getExtensionNode(false)) != null) {
            for (NodeType assignedMixin : ext.getMixinNodeTypes()) {
                if (!assignedMixin.isNodeType(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "external node " + this.data.getPath();
    }

    private class ExternalNodeIterator
    implements NodeIterator {
        private int pos = 0;
        private Iterator<String> it;
        private final List<String> list;
        private NodeIterator extensionNodeIterator;
        private Node nextNode;

        public ExternalNodeIterator(List<String> list) {
            this(list, null);
        }

        public ExternalNodeIterator(List<String> list, NodeIterator extensionNodeIterator) {
            this.extensionNodeIterator = extensionNodeIterator;
            this.list = list;
            this.it = list.iterator();
            this.fetchNext();
        }

        private Node fetchNext() {
            this.nextNode = null;
            if (this.it.hasNext()) {
                Node next = null;
                do {
                    try {
                        next = ExternalNodeImpl.this.getNode(this.it.next());
                    }
                    catch (RepositoryException e) {
                        next = null;
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                } while (next == null && this.hasNext());
                this.nextNode = next;
                return this.nextNode;
            }
            if (this.extensionNodeIterator != null) {
                while (this.extensionNodeIterator.hasNext()) {
                    Node n = this.extensionNodeIterator.nextNode();
                    try {
                        if (this.list.contains(n.getName())) continue;
                        String path = ExternalNodeImpl.this.getPath();
                        if (!path.endsWith("/")) {
                            path = path + "/";
                        }
                        path = path + n.getName();
                        try {
                            this.nextNode = ExternalNodeImpl.this.session.getNode(path);
                        }
                        catch (PathNotFoundException e) {
                            logger.debug("Cannot find node " + path, (Throwable)e);
                        }
                        return this.nextNode;
                    }
                    catch (RepositoryException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return null;
        }

        public Node nextNode() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            Node next = this.nextNode;
            this.fetchNext();
            ++this.pos;
            return next;
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.nextNode();
                ++i;
            }
        }

        public long getSize() {
            return (long)this.list.size() + (this.extensionNodeIterator != null ? this.extensionNodeIterator.getSize() : 0L);
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.nextNode != null;
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ExternalPropertyIterator
    implements PropertyIterator {
        private int pos = 0;
        private Iterator<ExternalPropertyImpl> it;
        private PropertyIterator extensionPropertiesIterator;
        private Property nextProperty = null;
        private Map<String, ExternalPropertyImpl> externalProperties;
        private Set<String> lazyProperties;
        private Iterator<String> lazyPropertiesIterator;
        private ExternalNodeImpl node;

        ExternalPropertyIterator(Map<String, ExternalPropertyImpl> externalPropertyMap, Set<String> lazyProperties, Set<String> lazyBinaryProperties, ExternalNodeImpl node) {
            this(externalPropertyMap, null, lazyProperties, lazyBinaryProperties, node);
        }

        ExternalPropertyIterator(Map<String, ExternalPropertyImpl> externalPropertyMap, PropertyIterator extensionPropertiesIterator, Set<String> lazyProperties, Set<String> lazyBinaryProperties, ExternalNodeImpl node) {
            this.extensionPropertiesIterator = extensionPropertiesIterator;
            this.externalProperties = new HashMap<String, ExternalPropertyImpl>(externalPropertyMap);
            this.lazyProperties = new HashSet<String>();
            if (lazyProperties != null) {
                this.lazyProperties.addAll(lazyProperties);
            }
            if (lazyBinaryProperties != null) {
                this.lazyProperties.addAll(lazyBinaryProperties);
            }
            this.node = node;
            this.fetchNext();
        }

        private void fetchNext() {
            this.nextProperty = null;
            if (this.extensionPropertiesIterator != null) {
                while (this.extensionPropertiesIterator.hasNext()) {
                    Property next = this.extensionPropertiesIterator.nextProperty();
                    try {
                        ExtendedPropertyDefinition propertyDefinition = ExternalNodeImpl.this.getPropertyDefinition(next.getName());
                        if (propertyDefinition == null || !ExternalNodeImpl.this.canItemBeExtended((ItemDefinition)propertyDefinition)) continue;
                        this.nextProperty = new ExtensionProperty(next, ExternalNodeImpl.this.getPath() + "/" + next.getName(), this.node.getSession(), ExternalNodeImpl.this);
                        this.externalProperties.remove(next.getName());
                        this.lazyProperties.remove(next.getName());
                        return;
                    }
                    catch (RepositoryException e) {
                        logger.error("Cannot get property", (Throwable)e);
                    }
                }
            }
            if (this.it == null) {
                this.it = this.externalProperties.values().iterator();
            }
            if (this.it.hasNext()) {
                this.nextProperty = this.it.next();
                return;
            }
            if (this.lazyPropertiesIterator == null && this.lazyProperties != null) {
                this.lazyPropertiesIterator = this.lazyProperties.iterator();
            }
            if (this.lazyPropertiesIterator != null && this.lazyPropertiesIterator.hasNext()) {
                String propertyName = this.lazyPropertiesIterator.next();
                try {
                    this.nextProperty = ExternalNodeImpl.this.getProperty(propertyName);
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        public Property nextProperty() {
            if (this.nextProperty == null) {
                throw new NoSuchElementException();
            }
            Property next = this.nextProperty;
            this.fetchNext();
            ++this.pos;
            return next;
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i < skipNum) {
                this.nextProperty();
                ++i;
            }
        }

        public long getSize() {
            return (long)this.externalProperties.size() + (this.extensionPropertiesIterator != null ? this.extensionPropertiesIterator.getSize() : 0L);
        }

        public long getPosition() {
            return this.pos;
        }

        public boolean hasNext() {
            return this.nextProperty != null;
        }

        public Object next() {
            return this.nextProperty();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

