/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.external.ExternalBinaryImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalValueFactoryImpl
implements ValueFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExternalValueFactoryImpl.class);
    private ExternalSessionImpl session;

    public ExternalValueFactoryImpl(ExternalSessionImpl session) {
        this.session = session;
    }

    public ExternalValueImpl createValue(String value) {
        return new ExternalValueImpl(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExternalValueImpl createValue(String value, int type) throws ValueFormatException {
        if (type == 0) {
            type = 1;
        }
        switch (type) {
            case 2: {
                throw new ValueFormatException("Not allowed to convert string [" + value + "] to binary value");
            }
            case 6: {
                return this.createValue(Boolean.parseBoolean(value));
            }
            case 5: {
                return this.createValue(ISO8601.parse((String)value));
            }
            case 12: {
                return this.createValue(new BigDecimal(value));
            }
            case 4: {
                return this.createValue(Double.parseDouble(value));
            }
            case 3: {
                return this.createValue(Long.parseLong(value));
            }
            case 9: 
            case 10: {
                try {
                    if (this.session.getRepository().getDataSource().isSupportsUuid()) return new ExternalValueImpl(value, type);
                    try {
                        UUID.fromString(value);
                        return new ExternalValueImpl(value, type);
                    }
                    catch (IllegalArgumentException e) {
                        String internalId = this.session.getRepository().getStoreProvider().getOrCreateInternalIdentifier(value);
                        return new ExternalValueImpl(internalId, type);
                    }
                }
                catch (RepositoryException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return new ExternalValueImpl(value, type);
            }
            case 1: 
            case 7: 
            case 8: 
            case 11: {
                return new ExternalValueImpl(value, type);
            }
        }
        throw new ValueFormatException("Unsupported value type " + type);
    }

    public ExternalValueImpl createValue(long value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(double value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(BigDecimal value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(boolean value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(Calendar value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(InputStream value) {
        return new ExternalValueImpl(new ExternalBinaryImpl(value));
    }

    public ExternalValueImpl createValue(Binary value) {
        return new ExternalValueImpl(value);
    }

    public ExternalValueImpl createValue(Node value) throws RepositoryException {
        return new ExternalValueImpl(value, false);
    }

    public ExternalValueImpl createValue(Node value, boolean weak) throws RepositoryException {
        return new ExternalValueImpl(value, weak);
    }

    public Binary createBinary(InputStream stream) throws RepositoryException {
        return new ExternalBinaryImpl(stream);
    }
}

