/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.jahia.modules.external.ExternalContentStoreProvider;
import org.jahia.modules.external.ExternalDataSource;
import org.jahia.modules.external.ExternalNodeImpl;
import org.jahia.modules.external.ExternalSessionImpl;
import org.jahia.modules.external.ExternalVersionManagerImpl;
import org.jahia.modules.external.query.ExternalQueryManager;
import org.xml.sax.ContentHandler;

public class ExternalWorkspaceImpl
implements Workspace {
    private ExternalSessionImpl externalSession;
    private String workspaceName;

    public ExternalWorkspaceImpl(ExternalSessionImpl session, String workspaceName) {
        this.externalSession = session;
        this.workspaceName = workspaceName;
    }

    public ExternalSessionImpl getSession() {
        return this.externalSession;
    }

    public String getName() {
        return this.workspaceName;
    }

    public void copy(String s, String s1) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void copy(String s, String s1, String s2) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void clone(String s, String s1, String s2, boolean b) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void move(String source, String dest) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        if (this.externalSession.getRepository().getDataSource() instanceof ExternalDataSource.Writable) {
            ExternalContentStoreProvider.setCurrentSession(this.externalSession);
            try {
                ((ExternalDataSource.Writable)((Object)this.externalSession.getRepository().getDataSource())).move(source, dest);
            }
            finally {
                ExternalContentStoreProvider.removeCurrentSession();
            }
        } else {
            throw new UnsupportedRepositoryOperationException();
        }
    }

    public void restore(Version[] versions, boolean b) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public QueryManager getQueryManager() throws RepositoryException {
        if (this.externalSession.getRepository().getDataSource() instanceof ExternalDataSource.Searchable) {
            return new ExternalQueryManager(this);
        }
        return null;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.externalSession.getRepository().getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return new NodeTypeManager(){

            public NodeType getNodeType(String s) throws NoSuchNodeTypeException, RepositoryException {
                return null;
            }

            public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
                return null;
            }

            public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
                return null;
            }

            public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
                return null;
            }

            public boolean hasNodeType(String name) throws RepositoryException {
                return false;
            }

            public NodeTypeTemplate createNodeTypeTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public NodeDefinitionTemplate createNodeDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
                return null;
            }

            public void unregisterNodeType(String name) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
            }

            public void unregisterNodeTypes(String[] names) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
            }
        };
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new ObservationManager(){

            public void addEventListener(EventListener eventListener, int i, String s, boolean b, String[] strings, String[] strings1, boolean b1) throws RepositoryException {
            }

            public void removeEventListener(EventListener eventListener) throws RepositoryException {
            }

            public EventListenerIterator getRegisteredEventListeners() throws RepositoryException {
                return null;
            }

            public void setUserData(String userData) throws RepositoryException {
            }

            public EventJournal getEventJournal() throws RepositoryException {
                return null;
            }

            public EventJournal getEventJournal(int i, String s, boolean b, String[] strings, String[] strings1) throws RepositoryException {
                return null;
            }
        };
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        return new String[0];
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        return null;
    }

    public void importXML(String s, InputStream inputStream, int i) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
    }

    public LockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        final Session extensionSession = this.externalSession.getExtensionSession();
        if (extensionSession == null) {
            return null;
        }
        final LockManager extensionLockMgr = extensionSession.getWorkspace().getLockManager();
        return new LockManager(){

            public void addLockToken(String lockToken) throws LockException, RepositoryException {
                extensionLockMgr.addLockToken(lockToken);
            }

            public Lock getLock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
                Node n = ((ExternalNodeImpl)ExternalWorkspaceImpl.this.externalSession.getNode(absPath)).getExtensionNode(false);
                if (n != null) {
                    return extensionLockMgr.getLock(n.getPath());
                }
                throw new PathNotFoundException("unable to get node " + absPath);
            }

            public String[] getLockTokens() throws RepositoryException {
                return extensionLockMgr.getLockTokens();
            }

            public boolean holdsLock(String absPath) throws PathNotFoundException, RepositoryException {
                Node n = ((ExternalNodeImpl)ExternalWorkspaceImpl.this.externalSession.getNode(absPath)).getExtensionNode(false);
                return n != null && extensionLockMgr.holdsLock(n.getPath());
            }

            public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
                Node n = ((ExternalNodeImpl)ExternalWorkspaceImpl.this.externalSession.getNode(absPath)).getExtensionNode(true);
                extensionSession.save();
                return extensionLockMgr.lock(n.getPath(), isDeep, isSessionScoped, timeoutHint, ownerInfo);
            }

            public boolean isLocked(String absPath) throws PathNotFoundException, RepositoryException {
                Node n = ((ExternalNodeImpl)ExternalWorkspaceImpl.this.externalSession.getNode(absPath)).getExtensionNode(false);
                return n != null && extensionLockMgr.isLocked(n.getPath());
            }

            public void removeLockToken(String lockToken) throws LockException, RepositoryException {
                extensionLockMgr.removeLockToken(lockToken);
            }

            public void unlock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
                Node n = ((ExternalNodeImpl)ExternalWorkspaceImpl.this.externalSession.getNode(absPath)).getExtensionNode(false);
                if (n == null) {
                    throw new LockException("Node not locked");
                }
                extensionLockMgr.unlock(n.getPath());
            }
        };
    }

    public VersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new ExternalVersionManagerImpl();
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Workspace creation is not supported by the external Repository");
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Workspace creation is not supported by the external Repository");
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Workspace deleting is not supported by the external Repository");
    }
}

