/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.external.acl;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jahia.services.content.JCRContentUtils;

public class ExternalDataAce {
    public static final String ACE_TYPE_PROP = "j:aceType";
    public static final String ACE_PRINCIPAL_PROP = "j:principal";
    public static final String ACE_ROLES_PROP = "j:roles";
    public static final String ACE_PROTECTED_PROP = "j:protected";
    public static final String ACE_NODE_TYPE = "jnt:ace";
    private Type aceType;
    private String principal;
    private Set<String> roles;
    private boolean aceProtected;

    protected ExternalDataAce(Type aceType, String principal, Set<String> roles, boolean aceProtected) {
        this.aceType = aceType;
        this.principal = principal;
        this.roles = roles;
        this.aceProtected = aceProtected;
    }

    public Type getAceType() {
        return this.aceType;
    }

    public void setAceType(Type aceType) {
        this.aceType = aceType;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean isAceProtected() {
        return this.aceProtected;
    }

    public void setAceProtected(boolean aceProtected) {
        this.aceProtected = aceProtected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalDataAce that = (ExternalDataAce)o;
        return Objects.equal((Object)((Object)this.aceType), (Object)((Object)that.aceType)) && Objects.equal((Object)this.principal, (Object)that.principal) && Objects.equal(this.roles, that.roles);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.aceType, this.principal, this.roles});
    }

    public String toString() {
        return this.aceType.toString() + "_" + JCRContentUtils.replaceColon((String)this.principal).replaceAll("/", "_");
    }

    public Map<String, String[]> getProperties() {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        properties.put(ACE_TYPE_PROP, new String[]{this.aceType.toString()});
        properties.put(ACE_PRINCIPAL_PROP, new String[]{this.principal});
        properties.put(ACE_ROLES_PROP, this.roles.toArray(new String[this.roles.size()]));
        properties.put(ACE_PROTECTED_PROP, new String[]{String.valueOf(this.aceProtected)});
        return properties;
    }

    public static enum Type {
        GRANT("GRANT"),
        DENY("DENY");

        private final String name;

        private Type(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

